<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contact StructType
 * @subpackage Structs
 */
class Contact extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $Name;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EmailType[]
     */
    public $Email;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TelephoneInfoType[]
     */
    public $Telephone;
    /**
     * The PreferredContactMethod
     * @var string
     */
    public $PreferredContactMethod;
    /**
     * The IPAddress
     * @var string
     */
    public $IPAddress;
    /**
     * The TravelerPublicUUID
     * @var string
     */
    public $TravelerPublicUUID;
    /**
     * Constructor method for Contact
     * @uses Contact::setName()
     * @uses Contact::setEmail()
     * @uses Contact::setTelephone()
     * @uses Contact::setPreferredContactMethod()
     * @uses Contact::setIPAddress()
     * @uses Contact::setTravelerPublicUUID()
     * @param \StructType\PersonNameType $name
     * @param \StructType\EmailType[] $email
     * @param \StructType\TelephoneInfoType[] $telephone
     * @param string $preferredContactMethod
     * @param string $iPAddress
     * @param string $travelerPublicUUID
     */
    public function __construct(\StructType\PersonNameType $name = null, array $email = array(), array $telephone = array(), $preferredContactMethod = null, $iPAddress = null, $travelerPublicUUID = null)
    {
        $this
            ->setName($name)
            ->setEmail($email)
            ->setTelephone($telephone)
            ->setPreferredContactMethod($preferredContactMethod)
            ->setIPAddress($iPAddress)
            ->setTravelerPublicUUID($travelerPublicUUID);
    }
    /**
     * Get Name value
     * @return \StructType\PersonNameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \StructType\PersonNameType $name
     * @return \StructType\Contact
     */
    public function setName(\StructType\PersonNameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Email value
     * @return \StructType\EmailType[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactEmailItem) {
            // validation for constraint: itemType
            if (!$contactEmailItem instanceof \StructType\EmailType) {
                $invalidValues[] = is_object($contactEmailItem) ? get_class($contactEmailItem) : sprintf('%s(%s)', gettype($contactEmailItem), var_export($contactEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Email property can only contain items of type \StructType\EmailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \StructType\EmailType[] $email
     * @return \StructType\Contact
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \StructType\EmailType $item
     * @return \StructType\Contact
     */
    public function addToEmail(\StructType\EmailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmailType) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of type \StructType\EmailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\TelephoneInfoType[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneForArrayConstraintsFromSetTelephone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactTelephoneItem) {
            // validation for constraint: itemType
            if (!$contactTelephoneItem instanceof \StructType\TelephoneInfoType) {
                $invalidValues[] = is_object($contactTelephoneItem) ? get_class($contactTelephoneItem) : sprintf('%s(%s)', gettype($contactTelephoneItem), var_export($contactTelephoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Telephone property can only contain items of type \StructType\TelephoneInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\TelephoneInfoType[] $telephone
     * @return \StructType\Contact
     */
    public function setTelephone(array $telephone = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneArrayErrorMessage = self::validateTelephoneForArrayConstraintsFromSetTelephone($telephone))) {
            throw new \InvalidArgumentException($telephoneArrayErrorMessage, __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\TelephoneInfoType $item
     * @return \StructType\Contact
     */
    public function addToTelephone(\StructType\TelephoneInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TelephoneInfoType) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of type \StructType\TelephoneInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get PreferredContactMethod value
     * @return string|null
     */
    public function getPreferredContactMethod()
    {
        return $this->PreferredContactMethod;
    }
    /**
     * Set PreferredContactMethod value
     * @uses \EnumType\PreferredContactMethodType::valueIsValid()
     * @uses \EnumType\PreferredContactMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferredContactMethod
     * @return \StructType\Contact
     */
    public function setPreferredContactMethod($preferredContactMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferredContactMethodType::valueIsValid($preferredContactMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferredContactMethodType', is_array($preferredContactMethod) ? implode(', ', $preferredContactMethod) : var_export($preferredContactMethod, true), implode(', ', \EnumType\PreferredContactMethodType::getValidValues())), __LINE__);
        }
        $this->PreferredContactMethod = $preferredContactMethod;
        return $this;
    }
    /**
     * Get IPAddress value
     * @return string|null
     */
    public function getIPAddress()
    {
        return $this->IPAddress;
    }
    /**
     * Set IPAddress value
     * @param string $iPAddress
     * @return \StructType\Contact
     */
    public function setIPAddress($iPAddress = null)
    {
        // validation for constraint: string
        if (!is_null($iPAddress) && !is_string($iPAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iPAddress, true), gettype($iPAddress)), __LINE__);
        }
        $this->IPAddress = $iPAddress;
        return $this;
    }
    /**
     * Get TravelerPublicUUID value
     * @return string|null
     */
    public function getTravelerPublicUUID()
    {
        return $this->TravelerPublicUUID;
    }
    /**
     * Set TravelerPublicUUID value
     * @param string $travelerPublicUUID
     * @return \StructType\Contact
     */
    public function setTravelerPublicUUID($travelerPublicUUID = null)
    {
        // validation for constraint: string
        if (!is_null($travelerPublicUUID) && !is_string($travelerPublicUUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelerPublicUUID, true), gettype($travelerPublicUUID)), __LINE__);
        }
        $this->TravelerPublicUUID = $travelerPublicUUID;
        return $this;
    }
}
