<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitsType StructType
 * @subpackage Structs
 */
class UnitsType extends AbstractStructBase
{
    /**
     * The Unit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UnitValueMatchType[]
     */
    public $Unit;
    /**
     * Constructor method for UnitsType
     * @uses UnitsType::setUnit()
     * @param \StructType\UnitValueMatchType[] $unit
     */
    public function __construct(array $unit = array())
    {
        $this
            ->setUnit($unit);
    }
    /**
     * Get Unit value
     * @return \StructType\UnitValueMatchType[]|null
     */
    public function getUnit()
    {
        return $this->Unit;
    }
    /**
     * This method is responsible for validating the values passed to the setUnit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitForArrayConstraintsFromSetUnit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitsTypeUnitItem) {
            // validation for constraint: itemType
            if (!$unitsTypeUnitItem instanceof \StructType\UnitValueMatchType) {
                $invalidValues[] = is_object($unitsTypeUnitItem) ? get_class($unitsTypeUnitItem) : sprintf('%s(%s)', gettype($unitsTypeUnitItem), var_export($unitsTypeUnitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Unit property can only contain items of type \StructType\UnitValueMatchType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Unit value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitValueMatchType[] $unit
     * @return \StructType\UnitsType
     */
    public function setUnit(array $unit = array())
    {
        // validation for constraint: array
        if ('' !== ($unitArrayErrorMessage = self::validateUnitForArrayConstraintsFromSetUnit($unit))) {
            throw new \InvalidArgumentException($unitArrayErrorMessage, __LINE__);
        }
        $this->Unit = $unit;
        return $this;
    }
    /**
     * Add item to Unit value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitValueMatchType $item
     * @return \StructType\UnitsType
     */
    public function addToUnit(\StructType\UnitValueMatchType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnitValueMatchType) {
            throw new \InvalidArgumentException(sprintf('The Unit property can only contain items of type \StructType\UnitValueMatchType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Unit[] = $item;
        return $this;
    }
}
