<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitCalendarAvailSegmentType StructType
 * @subpackage Structs
 */
class UnitCalendarAvailSegmentType extends AbstractStructBase
{
    /**
     * The DailyAvailability
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DailyAvailability;
    /**
     * The StayRequirements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfStayRequirementType
     */
    public $StayRequirements;
    /**
     * The StartDate
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * @var string
     */
    public $EndDate;
    /**
     * Constructor method for UnitCalendarAvailSegmentType
     * @uses UnitCalendarAvailSegmentType::setDailyAvailability()
     * @uses UnitCalendarAvailSegmentType::setStayRequirements()
     * @uses UnitCalendarAvailSegmentType::setStartDate()
     * @uses UnitCalendarAvailSegmentType::setEndDate()
     * @param string $dailyAvailability
     * @param \ArrayType\ArrayOfStayRequirementType $stayRequirements
     * @param string $startDate
     * @param string $endDate
     */
    public function __construct($dailyAvailability = null, \ArrayType\ArrayOfStayRequirementType $stayRequirements = null, $startDate = null, $endDate = null)
    {
        $this
            ->setDailyAvailability($dailyAvailability)
            ->setStayRequirements($stayRequirements)
            ->setStartDate($startDate)
            ->setEndDate($endDate);
    }
    /**
     * Get DailyAvailability value
     * @return string|null
     */
    public function getDailyAvailability()
    {
        return $this->DailyAvailability;
    }
    /**
     * Set DailyAvailability value
     * @param string $dailyAvailability
     * @return \StructType\UnitCalendarAvailSegmentType
     */
    public function setDailyAvailability($dailyAvailability = null)
    {
        // validation for constraint: string
        if (!is_null($dailyAvailability) && !is_string($dailyAvailability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dailyAvailability, true), gettype($dailyAvailability)), __LINE__);
        }
        $this->DailyAvailability = $dailyAvailability;
        return $this;
    }
    /**
     * Get StayRequirements value
     * @return \ArrayType\ArrayOfStayRequirementType|null
     */
    public function getStayRequirements()
    {
        return $this->StayRequirements;
    }
    /**
     * Set StayRequirements value
     * @param \ArrayType\ArrayOfStayRequirementType $stayRequirements
     * @return \StructType\UnitCalendarAvailSegmentType
     */
    public function setStayRequirements(\ArrayType\ArrayOfStayRequirementType $stayRequirements = null)
    {
        $this->StayRequirements = $stayRequirements;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\UnitCalendarAvailSegmentType
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\UnitCalendarAvailSegmentType
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
}
