<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TelephoneInfo StructType
 * @subpackage Structs
 */
class TelephoneInfo extends AbstractStructBase
{
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The PhoneLocationType
     * @var string
     */
    public $PhoneLocationType;
    /**
     * The PhoneTechType
     * @var string
     */
    public $PhoneTechType;
    /**
     * The PhoneUseType
     * @var string
     */
    public $PhoneUseType;
    /**
     * The CountryAccessCode
     * @var string
     */
    public $CountryAccessCode;
    /**
     * The AreaCityCode
     * @var string
     */
    public $AreaCityCode;
    /**
     * The PhoneNumber
     * @var string
     */
    public $PhoneNumber;
    /**
     * The Extension
     * @var string
     */
    public $Extension;
    /**
     * The PIN
     * @var string
     */
    public $PIN;
    /**
     * The FormattedInd
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $FormattedInd;
    /**
     * The DefaultInd
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $DefaultInd;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for TelephoneInfo
     * @uses TelephoneInfo::setShareSynchInd()
     * @uses TelephoneInfo::setShareMarketInd()
     * @uses TelephoneInfo::setPhoneLocationType()
     * @uses TelephoneInfo::setPhoneTechType()
     * @uses TelephoneInfo::setPhoneUseType()
     * @uses TelephoneInfo::setCountryAccessCode()
     * @uses TelephoneInfo::setAreaCityCode()
     * @uses TelephoneInfo::setPhoneNumber()
     * @uses TelephoneInfo::setExtension()
     * @uses TelephoneInfo::setPIN()
     * @uses TelephoneInfo::setFormattedInd()
     * @uses TelephoneInfo::setDefaultInd()
     * @uses TelephoneInfo::setRPH()
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $phoneLocationType
     * @param string $phoneTechType
     * @param string $phoneUseType
     * @param string $countryAccessCode
     * @param string $areaCityCode
     * @param string $phoneNumber
     * @param string $extension
     * @param string $pIN
     * @param bool $formattedInd
     * @param bool $defaultInd
     * @param string $rPH
     */
    public function __construct($shareSynchInd = null, $shareMarketInd = null, $phoneLocationType = null, $phoneTechType = null, $phoneUseType = null, $countryAccessCode = null, $areaCityCode = null, $phoneNumber = null, $extension = null, $pIN = null, $formattedInd = false, $defaultInd = false, $rPH = null)
    {
        $this
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setPhoneLocationType($phoneLocationType)
            ->setPhoneTechType($phoneTechType)
            ->setPhoneUseType($phoneUseType)
            ->setCountryAccessCode($countryAccessCode)
            ->setAreaCityCode($areaCityCode)
            ->setPhoneNumber($phoneNumber)
            ->setExtension($extension)
            ->setPIN($pIN)
            ->setFormattedInd($formattedInd)
            ->setDefaultInd($defaultInd)
            ->setRPH($rPH);
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\TelephoneInfo
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\TelephoneInfo
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get PhoneLocationType value
     * @return string|null
     */
    public function getPhoneLocationType()
    {
        return $this->PhoneLocationType;
    }
    /**
     * Set PhoneLocationType value
     * @param string $phoneLocationType
     * @return \StructType\TelephoneInfo
     */
    public function setPhoneLocationType($phoneLocationType = null)
    {
        // validation for constraint: string
        if (!is_null($phoneLocationType) && !is_string($phoneLocationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneLocationType, true), gettype($phoneLocationType)), __LINE__);
        }
        $this->PhoneLocationType = $phoneLocationType;
        return $this;
    }
    /**
     * Get PhoneTechType value
     * @return string|null
     */
    public function getPhoneTechType()
    {
        return $this->PhoneTechType;
    }
    /**
     * Set PhoneTechType value
     * @param string $phoneTechType
     * @return \StructType\TelephoneInfo
     */
    public function setPhoneTechType($phoneTechType = null)
    {
        // validation for constraint: string
        if (!is_null($phoneTechType) && !is_string($phoneTechType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneTechType, true), gettype($phoneTechType)), __LINE__);
        }
        $this->PhoneTechType = $phoneTechType;
        return $this;
    }
    /**
     * Get PhoneUseType value
     * @return string|null
     */
    public function getPhoneUseType()
    {
        return $this->PhoneUseType;
    }
    /**
     * Set PhoneUseType value
     * @param string $phoneUseType
     * @return \StructType\TelephoneInfo
     */
    public function setPhoneUseType($phoneUseType = null)
    {
        // validation for constraint: string
        if (!is_null($phoneUseType) && !is_string($phoneUseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneUseType, true), gettype($phoneUseType)), __LINE__);
        }
        $this->PhoneUseType = $phoneUseType;
        return $this;
    }
    /**
     * Get CountryAccessCode value
     * @return string|null
     */
    public function getCountryAccessCode()
    {
        return $this->CountryAccessCode;
    }
    /**
     * Set CountryAccessCode value
     * @param string $countryAccessCode
     * @return \StructType\TelephoneInfo
     */
    public function setCountryAccessCode($countryAccessCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryAccessCode) && !is_string($countryAccessCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryAccessCode, true), gettype($countryAccessCode)), __LINE__);
        }
        $this->CountryAccessCode = $countryAccessCode;
        return $this;
    }
    /**
     * Get AreaCityCode value
     * @return string|null
     */
    public function getAreaCityCode()
    {
        return $this->AreaCityCode;
    }
    /**
     * Set AreaCityCode value
     * @param string $areaCityCode
     * @return \StructType\TelephoneInfo
     */
    public function setAreaCityCode($areaCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($areaCityCode) && !is_string($areaCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaCityCode, true), gettype($areaCityCode)), __LINE__);
        }
        $this->AreaCityCode = $areaCityCode;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\TelephoneInfo
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get Extension value
     * @return string|null
     */
    public function getExtension()
    {
        return $this->Extension;
    }
    /**
     * Set Extension value
     * @param string $extension
     * @return \StructType\TelephoneInfo
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extension, true), gettype($extension)), __LINE__);
        }
        $this->Extension = $extension;
        return $this;
    }
    /**
     * Get PIN value
     * @return string|null
     */
    public function getPIN()
    {
        return $this->PIN;
    }
    /**
     * Set PIN value
     * @param string $pIN
     * @return \StructType\TelephoneInfo
     */
    public function setPIN($pIN = null)
    {
        // validation for constraint: string
        if (!is_null($pIN) && !is_string($pIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIN, true), gettype($pIN)), __LINE__);
        }
        $this->PIN = $pIN;
        return $this;
    }
    /**
     * Get FormattedInd value
     * @return bool|null
     */
    public function getFormattedInd()
    {
        return $this->FormattedInd;
    }
    /**
     * Set FormattedInd value
     * @param bool $formattedInd
     * @return \StructType\TelephoneInfo
     */
    public function setFormattedInd($formattedInd = false)
    {
        // validation for constraint: boolean
        if (!is_null($formattedInd) && !is_bool($formattedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($formattedInd, true), gettype($formattedInd)), __LINE__);
        }
        $this->FormattedInd = $formattedInd;
        return $this;
    }
    /**
     * Get DefaultInd value
     * @return bool|null
     */
    public function getDefaultInd()
    {
        return $this->DefaultInd;
    }
    /**
     * Set DefaultInd value
     * @param bool $defaultInd
     * @return \StructType\TelephoneInfo
     */
    public function setDefaultInd($defaultInd = false)
    {
        // validation for constraint: boolean
        if (!is_null($defaultInd) && !is_bool($defaultInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultInd, true), gettype($defaultInd)), __LINE__);
        }
        $this->DefaultInd = $defaultInd;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\TelephoneInfo
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
}
