<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationUpdate StructType
 * @subpackage Structs
 */
class ReservationUpdate extends AbstractStructBase
{
    /**
     * The ReservationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReservationID;
    /**
     * The UnitID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitID;
    /**
     * The AgencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgencyID;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EndDate;
    /**
     * The BookingNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BookingNumber;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreationDate;
    /**
     * The ReservationType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReservationType;
    /**
     * The UnitRates
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfReservationUpdateUnitRate
     */
    public $UnitRates;
    /**
     * Constructor method for ReservationUpdate
     * @uses ReservationUpdate::setReservationID()
     * @uses ReservationUpdate::setUnitID()
     * @uses ReservationUpdate::setAgencyID()
     * @uses ReservationUpdate::setStartDate()
     * @uses ReservationUpdate::setEndDate()
     * @uses ReservationUpdate::setBookingNumber()
     * @uses ReservationUpdate::setCreationDate()
     * @uses ReservationUpdate::setReservationType()
     * @uses ReservationUpdate::setUnitRates()
     * @param string $reservationID
     * @param string $unitID
     * @param string $agencyID
     * @param string $startDate
     * @param string $endDate
     * @param string $bookingNumber
     * @param string $creationDate
     * @param string $reservationType
     * @param \ArrayType\ArrayOfReservationUpdateUnitRate $unitRates
     */
    public function __construct($reservationID = null, $unitID = null, $agencyID = null, $startDate = null, $endDate = null, $bookingNumber = null, $creationDate = null, $reservationType = null, \ArrayType\ArrayOfReservationUpdateUnitRate $unitRates = null)
    {
        $this
            ->setReservationID($reservationID)
            ->setUnitID($unitID)
            ->setAgencyID($agencyID)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setBookingNumber($bookingNumber)
            ->setCreationDate($creationDate)
            ->setReservationType($reservationType)
            ->setUnitRates($unitRates);
    }
    /**
     * Get ReservationID value
     * @return string|null
     */
    public function getReservationID()
    {
        return $this->ReservationID;
    }
    /**
     * Set ReservationID value
     * @param string $reservationID
     * @return \StructType\ReservationUpdate
     */
    public function setReservationID($reservationID = null)
    {
        // validation for constraint: string
        if (!is_null($reservationID) && !is_string($reservationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationID, true), gettype($reservationID)), __LINE__);
        }
        $this->ReservationID = $reservationID;
        return $this;
    }
    /**
     * Get UnitID value
     * @return string|null
     */
    public function getUnitID()
    {
        return $this->UnitID;
    }
    /**
     * Set UnitID value
     * @param string $unitID
     * @return \StructType\ReservationUpdate
     */
    public function setUnitID($unitID = null)
    {
        // validation for constraint: string
        if (!is_null($unitID) && !is_string($unitID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitID, true), gettype($unitID)), __LINE__);
        }
        $this->UnitID = $unitID;
        return $this;
    }
    /**
     * Get AgencyID value
     * @return string|null
     */
    public function getAgencyID()
    {
        return $this->AgencyID;
    }
    /**
     * Set AgencyID value
     * @param string $agencyID
     * @return \StructType\ReservationUpdate
     */
    public function setAgencyID($agencyID = null)
    {
        // validation for constraint: string
        if (!is_null($agencyID) && !is_string($agencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyID, true), gettype($agencyID)), __LINE__);
        }
        $this->AgencyID = $agencyID;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\ReservationUpdate
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\ReservationUpdate
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get BookingNumber value
     * @return string|null
     */
    public function getBookingNumber()
    {
        return $this->BookingNumber;
    }
    /**
     * Set BookingNumber value
     * @param string $bookingNumber
     * @return \StructType\ReservationUpdate
     */
    public function setBookingNumber($bookingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bookingNumber) && !is_string($bookingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingNumber, true), gettype($bookingNumber)), __LINE__);
        }
        $this->BookingNumber = $bookingNumber;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\ReservationUpdate
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get ReservationType value
     * @return string|null
     */
    public function getReservationType()
    {
        return $this->ReservationType;
    }
    /**
     * Set ReservationType value
     * @param string $reservationType
     * @return \StructType\ReservationUpdate
     */
    public function setReservationType($reservationType = null)
    {
        // validation for constraint: string
        if (!is_null($reservationType) && !is_string($reservationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationType, true), gettype($reservationType)), __LINE__);
        }
        $this->ReservationType = $reservationType;
        return $this;
    }
    /**
     * Get UnitRates value
     * @return \ArrayType\ArrayOfReservationUpdateUnitRate|null
     */
    public function getUnitRates()
    {
        return $this->UnitRates;
    }
    /**
     * Set UnitRates value
     * @param \ArrayType\ArrayOfReservationUpdateUnitRate $unitRates
     * @return \StructType\ReservationUpdate
     */
    public function setUnitRates(\ArrayType\ArrayOfReservationUpdateUnitRate $unitRates = null)
    {
        $this->UnitRates = $unitRates;
        return $this;
    }
}
