<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationTimeSpan StructType
 * @subpackage Structs
 */
class ReservationTimeSpan extends AbstractStructBase
{
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The Release
     * @var string
     */
    public $Release;
    /**
     * Constructor method for ReservationTimeSpan
     * @uses ReservationTimeSpan::setStart()
     * @uses ReservationTimeSpan::setDuration()
     * @uses ReservationTimeSpan::setEnd()
     * @uses ReservationTimeSpan::setRelease()
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $release
     */
    public function __construct($start = null, $duration = null, $end = null, $release = null)
    {
        $this
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setRelease($release);
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\ReservationTimeSpan
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\ReservationTimeSpan
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\ReservationTimeSpan
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Release value
     * @return string|null
     */
    public function getRelease()
    {
        return $this->Release;
    }
    /**
     * Set Release value
     * @param string $release
     * @return \StructType\ReservationTimeSpan
     */
    public function setRelease($release = null)
    {
        // validation for constraint: string
        if (!is_null($release) && !is_string($release)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($release, true), gettype($release)), __LINE__);
        }
        $this->Release = $release;
        return $this;
    }
}
