<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyManagers StructType
 * @subpackage Structs
 */
class PropertyManagers extends AbstractStructBase
{
    /**
     * The PropertyManager
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PropertyManagerType[]
     */
    public $PropertyManager;
    /**
     * Constructor method for PropertyManagers
     * @uses PropertyManagers::setPropertyManager()
     * @param \StructType\PropertyManagerType[] $propertyManager
     */
    public function __construct(array $propertyManager = array())
    {
        $this
            ->setPropertyManager($propertyManager);
    }
    /**
     * Get PropertyManager value
     * @return \StructType\PropertyManagerType[]|null
     */
    public function getPropertyManager()
    {
        return $this->PropertyManager;
    }
    /**
     * This method is responsible for validating the values passed to the setPropertyManager method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPropertyManager method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropertyManagerForArrayConstraintsFromSetPropertyManager(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $propertyManagersPropertyManagerItem) {
            // validation for constraint: itemType
            if (!$propertyManagersPropertyManagerItem instanceof \StructType\PropertyManagerType) {
                $invalidValues[] = is_object($propertyManagersPropertyManagerItem) ? get_class($propertyManagersPropertyManagerItem) : sprintf('%s(%s)', gettype($propertyManagersPropertyManagerItem), var_export($propertyManagersPropertyManagerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PropertyManager property can only contain items of type \StructType\PropertyManagerType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PropertyManager value
     * @throws \InvalidArgumentException
     * @param \StructType\PropertyManagerType[] $propertyManager
     * @return \StructType\PropertyManagers
     */
    public function setPropertyManager(array $propertyManager = array())
    {
        // validation for constraint: array
        if ('' !== ($propertyManagerArrayErrorMessage = self::validatePropertyManagerForArrayConstraintsFromSetPropertyManager($propertyManager))) {
            throw new \InvalidArgumentException($propertyManagerArrayErrorMessage, __LINE__);
        }
        $this->PropertyManager = $propertyManager;
        return $this;
    }
    /**
     * Add item to PropertyManager value
     * @throws \InvalidArgumentException
     * @param \StructType\PropertyManagerType $item
     * @return \StructType\PropertyManagers
     */
    public function addToPropertyManager(\StructType\PropertyManagerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PropertyManagerType) {
            throw new \InvalidArgumentException(sprintf('The PropertyManager property can only contain items of type \StructType\PropertyManagerType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PropertyManager[] = $item;
        return $this;
    }
}
