<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperationSchedulesType StructType
 * @subpackage Structs
 */
class OperationSchedulesType extends AbstractStructBase
{
    /**
     * The OperationSchedule
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OperationScheduleType[]
     */
    public $OperationSchedule;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The Release
     * @var string
     */
    public $Release;
    /**
     * Constructor method for OperationSchedulesType
     * @uses OperationSchedulesType::setOperationSchedule()
     * @uses OperationSchedulesType::setStart()
     * @uses OperationSchedulesType::setDuration()
     * @uses OperationSchedulesType::setEnd()
     * @uses OperationSchedulesType::setRelease()
     * @param \StructType\OperationScheduleType[] $operationSchedule
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $release
     */
    public function __construct(array $operationSchedule = array(), $start = null, $duration = null, $end = null, $release = null)
    {
        $this
            ->setOperationSchedule($operationSchedule)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setRelease($release);
    }
    /**
     * Get OperationSchedule value
     * @return \StructType\OperationScheduleType[]|null
     */
    public function getOperationSchedule()
    {
        return $this->OperationSchedule;
    }
    /**
     * This method is responsible for validating the values passed to the setOperationSchedule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOperationSchedule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOperationScheduleForArrayConstraintsFromSetOperationSchedule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $operationSchedulesTypeOperationScheduleItem) {
            // validation for constraint: itemType
            if (!$operationSchedulesTypeOperationScheduleItem instanceof \StructType\OperationScheduleType) {
                $invalidValues[] = is_object($operationSchedulesTypeOperationScheduleItem) ? get_class($operationSchedulesTypeOperationScheduleItem) : sprintf('%s(%s)', gettype($operationSchedulesTypeOperationScheduleItem), var_export($operationSchedulesTypeOperationScheduleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OperationSchedule property can only contain items of type \StructType\OperationScheduleType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OperationSchedule value
     * @throws \InvalidArgumentException
     * @param \StructType\OperationScheduleType[] $operationSchedule
     * @return \StructType\OperationSchedulesType
     */
    public function setOperationSchedule(array $operationSchedule = array())
    {
        // validation for constraint: array
        if ('' !== ($operationScheduleArrayErrorMessage = self::validateOperationScheduleForArrayConstraintsFromSetOperationSchedule($operationSchedule))) {
            throw new \InvalidArgumentException($operationScheduleArrayErrorMessage, __LINE__);
        }
        $this->OperationSchedule = $operationSchedule;
        return $this;
    }
    /**
     * Add item to OperationSchedule value
     * @throws \InvalidArgumentException
     * @param \StructType\OperationScheduleType $item
     * @return \StructType\OperationSchedulesType
     */
    public function addToOperationSchedule(\StructType\OperationScheduleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OperationScheduleType) {
            throw new \InvalidArgumentException(sprintf('The OperationSchedule property can only contain items of type \StructType\OperationScheduleType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OperationSchedule[] = $item;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\OperationSchedulesType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\OperationSchedulesType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\OperationSchedulesType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Release value
     * @return string|null
     */
    public function getRelease()
    {
        return $this->Release;
    }
    /**
     * Set Release value
     * @param string $release
     * @return \StructType\OperationSchedulesType
     */
    public function setRelease($release = null)
    {
        // validation for constraint: string
        if (!is_null($release) && !is_string($release)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($release, true), gettype($release)), __LINE__);
        }
        $this->Release = $release;
        return $this;
    }
}
