<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultimediaDescriptions StructType
 * @subpackage Structs
 */
class MultimediaDescriptions extends MultimediaDescriptionsType
{
    /**
     * The InfoCode
     * @var string
     */
    public $InfoCode;
    /**
     * The AdditionalDetailCode
     * @var string
     */
    public $AdditionalDetailCode;
    /**
     * Constructor method for MultimediaDescriptions
     * @uses MultimediaDescriptions::setInfoCode()
     * @uses MultimediaDescriptions::setAdditionalDetailCode()
     * @param string $infoCode
     * @param string $additionalDetailCode
     */
    public function __construct($infoCode = null, $additionalDetailCode = null)
    {
        $this
            ->setInfoCode($infoCode)
            ->setAdditionalDetailCode($additionalDetailCode);
    }
    /**
     * Get InfoCode value
     * @return string|null
     */
    public function getInfoCode()
    {
        return $this->InfoCode;
    }
    /**
     * Set InfoCode value
     * @param string $infoCode
     * @return \StructType\MultimediaDescriptions
     */
    public function setInfoCode($infoCode = null)
    {
        // validation for constraint: string
        if (!is_null($infoCode) && !is_string($infoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoCode, true), gettype($infoCode)), __LINE__);
        }
        $this->InfoCode = $infoCode;
        return $this;
    }
    /**
     * Get AdditionalDetailCode value
     * @return string|null
     */
    public function getAdditionalDetailCode()
    {
        return $this->AdditionalDetailCode;
    }
    /**
     * Set AdditionalDetailCode value
     * @param string $additionalDetailCode
     * @return \StructType\MultimediaDescriptions
     */
    public function setAdditionalDetailCode($additionalDetailCode = null)
    {
        // validation for constraint: string
        if (!is_null($additionalDetailCode) && !is_string($additionalDetailCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalDetailCode, true), gettype($additionalDetailCode)), __LINE__);
        }
        $this->AdditionalDetailCode = $additionalDetailCode;
        return $this;
    }
}
