<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Campaigns StructType
 * @subpackage Structs
 */
class Campaigns extends AbstractStructBase
{
    /**
     * The Campaign
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CampaignType[]
     */
    public $Campaign;
    /**
     * Constructor method for Campaigns
     * @uses Campaigns::setCampaign()
     * @param \StructType\CampaignType[] $campaign
     */
    public function __construct(array $campaign = array())
    {
        $this
            ->setCampaign($campaign);
    }
    /**
     * Get Campaign value
     * @return \StructType\CampaignType[]|null
     */
    public function getCampaign()
    {
        return $this->Campaign;
    }
    /**
     * This method is responsible for validating the values passed to the setCampaign method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCampaign method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCampaignForArrayConstraintsFromSetCampaign(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $campaignsCampaignItem) {
            // validation for constraint: itemType
            if (!$campaignsCampaignItem instanceof \StructType\CampaignType) {
                $invalidValues[] = is_object($campaignsCampaignItem) ? get_class($campaignsCampaignItem) : sprintf('%s(%s)', gettype($campaignsCampaignItem), var_export($campaignsCampaignItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Campaign property can only contain items of type \StructType\CampaignType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Campaign value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignType[] $campaign
     * @return \StructType\Campaigns
     */
    public function setCampaign(array $campaign = array())
    {
        // validation for constraint: array
        if ('' !== ($campaignArrayErrorMessage = self::validateCampaignForArrayConstraintsFromSetCampaign($campaign))) {
            throw new \InvalidArgumentException($campaignArrayErrorMessage, __LINE__);
        }
        $this->Campaign = $campaign;
        return $this;
    }
    /**
     * Add item to Campaign value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignType $item
     * @return \StructType\Campaigns
     */
    public function addToCampaign(\StructType\CampaignType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CampaignType) {
            throw new \InvalidArgumentException(sprintf('The Campaign property can only contain items of type \StructType\CampaignType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Campaign[] = $item;
        return $this;
    }
}
