<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Campaign ServiceType
 * @subpackage Services
 */
class Campaign extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Campaign
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EVRN_CampaignRQ $eVRN_CampaignRQ
     * @return \StructType\EVRN_CampaignRS|bool
     */
    public function Campaign(\StructType\EVRN_CampaignRQ $eVRN_CampaignRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->Campaign($eVRN_CampaignRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EVRN_CampaignRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
