<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRoomCountType ArrayType
 * @subpackage Arrays
 */
class ArrayOfRoomCountType extends AbstractStructArrayBase
{
    /**
     * The RoomCount
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoomCountType[]
     */
    public $RoomCount;
    /**
     * Constructor method for ArrayOfRoomCountType
     * @uses ArrayOfRoomCountType::setRoomCount()
     * @param \StructType\RoomCountType[] $roomCount
     */
    public function __construct(array $roomCount = array())
    {
        $this
            ->setRoomCount($roomCount);
    }
    /**
     * Get RoomCount value
     * @return \StructType\RoomCountType[]|null
     */
    public function getRoomCount()
    {
        return $this->RoomCount;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomCount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomCount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomCountForArrayConstraintsFromSetRoomCount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRoomCountTypeRoomCountItem) {
            // validation for constraint: itemType
            if (!$arrayOfRoomCountTypeRoomCountItem instanceof \StructType\RoomCountType) {
                $invalidValues[] = is_object($arrayOfRoomCountTypeRoomCountItem) ? get_class($arrayOfRoomCountTypeRoomCountItem) : sprintf('%s(%s)', gettype($arrayOfRoomCountTypeRoomCountItem), var_export($arrayOfRoomCountTypeRoomCountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomCount property can only contain items of type \StructType\RoomCountType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomCount value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomCountType[] $roomCount
     * @return \ArrayType\ArrayOfRoomCountType
     */
    public function setRoomCount(array $roomCount = array())
    {
        // validation for constraint: array
        if ('' !== ($roomCountArrayErrorMessage = self::validateRoomCountForArrayConstraintsFromSetRoomCount($roomCount))) {
            throw new \InvalidArgumentException($roomCountArrayErrorMessage, __LINE__);
        }
        $this->RoomCount = $roomCount;
        return $this;
    }
    /**
     * Add item to RoomCount value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomCountType $item
     * @return \ArrayType\ArrayOfRoomCountType
     */
    public function addToRoomCount(\StructType\RoomCountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomCountType) {
            throw new \InvalidArgumentException(sprintf('The RoomCount property can only contain items of type \StructType\RoomCountType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomCount[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RoomCountType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RoomCountType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RoomCountType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RoomCountType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RoomCountType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RoomCount
     */
    public function getAttributeName()
    {
        return 'RoomCount';
    }
}
