<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtendedProducerResponsibilityType StructType
 * Meta information extracted from the WSDL
 * - documentation: This type is used by the <b>ExtendedProducerResponsibility</b> container, which provides IDs for the producer or importer related to the new item, packaging, added documentation, or an eco-participation fee. In some markets, such as
 * in France, this may be the importer of the item. For more information, see the <b>Extended Producer Responsibility for business sellers</b> page for your site (for example, <a
 * href="https://www.ebay.com/help/selling/all-about-selling/selling-internationally/extended-producer-responsibility-for-business-sellers?id=5314"
 * target="_blank">https://www.ebay.com/help/selling/all-about-selling/selling-internationally/extended-producer-responsibility-for-business-sellers?id=5314</a>). <br/><br/>For <b>GetItem</b> calls, this container is only returned to the listing owner,
 * if the container is available.
 * @subpackage Structs
 */
class ExtendedProducerResponsibilityType extends AbstractStructBase
{
    /**
     * The EcoParticipationFee
     * Meta information extracted from the WSDL
     * - documentation: This is the fee paid for new items to the eco-organization (for example, "eco-organisme" in France). It is a contribution to the financing of the elimination of the item responsibly. For multiple-variation listings, the
     * <b>EcoParticipationFee</b> in the <b>VariationExtendedProducerResponsibility</b> container is used for each variation in the listing, and not the <b>EcoParticipationFee</b> in the <b>ExtendedProducerResponsibility</b> container.
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $EcoParticipationFee;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for ExtendedProducerResponsibilityType
     * @uses ExtendedProducerResponsibilityType::setEcoParticipationFee()
     * @uses ExtendedProducerResponsibilityType::setAny()
     * @param \StructType\AmountType $ecoParticipationFee
     * @param \DOMDocument $any
     */
    public function __construct(\StructType\AmountType $ecoParticipationFee = null, \DOMDocument $any = null)
    {
        $this
            ->setEcoParticipationFee($ecoParticipationFee)
            ->setAny($any);
    }
    /**
     * Get EcoParticipationFee value
     * @return \StructType\AmountType|null
     */
    public function getEcoParticipationFee()
    {
        return $this->EcoParticipationFee;
    }
    /**
     * Set EcoParticipationFee value
     * @param \StructType\AmountType $ecoParticipationFee
     * @return \StructType\ExtendedProducerResponsibilityType
     */
    public function setEcoParticipationFee(\StructType\AmountType $ecoParticipationFee = null)
    {
        $this->EcoParticipationFee = $ecoParticipationFee;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\ExtendedProducerResponsibilityType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
