<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MotorPurchaseType StructType
 * Meta information extracted from the WSDL
 * - documentation: This type is used to provide details on a motor vehicle order using Secure Purchase.
 * @subpackage Structs
 */
class MotorPurchaseType extends AbstractStructBase
{
    /**
     * The Facilitator
     * Meta information extracted from the WSDL
     * - documentation: The value returned in this field identifies the party that is facilitating the motor vehicle order.<br><br>Currently, only <code>CARAMEL</code> is supported.
     * - minOccurs: 0
     * @var string
     */
    public $Facilitator;
    /**
     * The FacilitatorRefId
     * Meta information extracted from the WSDL
     * - documentation: The facilitator's unique reference identifier associated with the motor vehicle order. This ID can be used to retrieve transaction details on the facilitator's website.
     * - minOccurs: 0
     * @var string
     */
    public $FacilitatorRefId;
    /**
     * The ServiceCost
     * Meta information extracted from the WSDL
     * - documentation: This container shows the service cost, if any, owed to the facilitator to complete the motor vehicle order.
     * - minOccurs: 0
     * @var \StructType\ServiceCostType
     */
    public $ServiceCost;
    /**
     * The BuyerStep
     * Meta information extracted from the WSDL
     * - documentation: This field returns the current status of the buying process for the motor vehicle order. The value returned in this field indicates the current step for the buyer in terms of the order. For more information, see <a
     * href="https://pages.ebay.com/secure-purchase/" target="_blank">Secure Purchase</a>.
     * - minOccurs: 0
     * @var string
     */
    public $BuyerStep;
    /**
     * The SellerStep
     * Meta information extracted from the WSDL
     * - documentation: This field returns the current status of the selling process for the motor vehicle order. The value returned in this field indicates the current step for the seller in terms of the order. For more information, see <a
     * href="https://pages.ebay.com/secure-purchase/" target="_blank">Secure Purchase</a>.
     * - minOccurs: 0
     * @var string
     */
    public $SellerStep;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: This field returns the current status of the overall motor vehicle order. The value returned in this field will indicate if the purchase process is active, inactive, or complete.
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for MotorPurchaseType
     * @uses MotorPurchaseType::setFacilitator()
     * @uses MotorPurchaseType::setFacilitatorRefId()
     * @uses MotorPurchaseType::setServiceCost()
     * @uses MotorPurchaseType::setBuyerStep()
     * @uses MotorPurchaseType::setSellerStep()
     * @uses MotorPurchaseType::setStatus()
     * @param string $facilitator
     * @param string $facilitatorRefId
     * @param \StructType\ServiceCostType $serviceCost
     * @param string $buyerStep
     * @param string $sellerStep
     * @param string $status
     */
    public function __construct($facilitator = null, $facilitatorRefId = null, \StructType\ServiceCostType $serviceCost = null, $buyerStep = null, $sellerStep = null, $status = null)
    {
        $this
            ->setFacilitator($facilitator)
            ->setFacilitatorRefId($facilitatorRefId)
            ->setServiceCost($serviceCost)
            ->setBuyerStep($buyerStep)
            ->setSellerStep($sellerStep)
            ->setStatus($status);
    }
    /**
     * Get Facilitator value
     * @return string|null
     */
    public function getFacilitator()
    {
        return $this->Facilitator;
    }
    /**
     * Set Facilitator value
     * @param string $facilitator
     * @return \StructType\MotorPurchaseType
     */
    public function setFacilitator($facilitator = null)
    {
        // validation for constraint: string
        if (!is_null($facilitator) && !is_string($facilitator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facilitator, true), gettype($facilitator)), __LINE__);
        }
        $this->Facilitator = $facilitator;
        return $this;
    }
    /**
     * Get FacilitatorRefId value
     * @return string|null
     */
    public function getFacilitatorRefId()
    {
        return $this->FacilitatorRefId;
    }
    /**
     * Set FacilitatorRefId value
     * @param string $facilitatorRefId
     * @return \StructType\MotorPurchaseType
     */
    public function setFacilitatorRefId($facilitatorRefId = null)
    {
        // validation for constraint: string
        if (!is_null($facilitatorRefId) && !is_string($facilitatorRefId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facilitatorRefId, true), gettype($facilitatorRefId)), __LINE__);
        }
        $this->FacilitatorRefId = $facilitatorRefId;
        return $this;
    }
    /**
     * Get ServiceCost value
     * @return \StructType\ServiceCostType|null
     */
    public function getServiceCost()
    {
        return $this->ServiceCost;
    }
    /**
     * Set ServiceCost value
     * @param \StructType\ServiceCostType $serviceCost
     * @return \StructType\MotorPurchaseType
     */
    public function setServiceCost(\StructType\ServiceCostType $serviceCost = null)
    {
        $this->ServiceCost = $serviceCost;
        return $this;
    }
    /**
     * Get BuyerStep value
     * @return string|null
     */
    public function getBuyerStep()
    {
        return $this->BuyerStep;
    }
    /**
     * Set BuyerStep value
     * @param string $buyerStep
     * @return \StructType\MotorPurchaseType
     */
    public function setBuyerStep($buyerStep = null)
    {
        // validation for constraint: string
        if (!is_null($buyerStep) && !is_string($buyerStep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buyerStep, true), gettype($buyerStep)), __LINE__);
        }
        $this->BuyerStep = $buyerStep;
        return $this;
    }
    /**
     * Get SellerStep value
     * @return string|null
     */
    public function getSellerStep()
    {
        return $this->SellerStep;
    }
    /**
     * Set SellerStep value
     * @param string $sellerStep
     * @return \StructType\MotorPurchaseType
     */
    public function setSellerStep($sellerStep = null)
    {
        // validation for constraint: string
        if (!is_null($sellerStep) && !is_string($sellerStep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerStep, true), gettype($sellerStep)), __LINE__);
        }
        $this->SellerStep = $sellerStep;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\MotorPurchaseType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
