<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Type that provides an array of one or more regulatory documents associated with a listing for Regulatory Compliance. <br /> <span class="tablenote"><b>Note: </b> As a part of General Product Safety Regulation (GPSR) requirements
 * effective from December 13th, 2024, sellers operating in, or shipping to, EU-based countries or Northern Ireland are conditionally required to provide document information in their eBay listings. For more information on GPSR, see <a href =
 * "https://www.ebay.com/sellercenter/resources/general-product-safety-regulation" target="_blank">General Product Safety Regulation (GPSR)</a>.</span>
 * @subpackage Structs
 */
class DocumentsType extends AbstractStructBase
{
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - documentation: A regulatory document associated with the listing.<br /><br />Regulatory documents can be created and uploaded using the <a href = "/api-docs/commerce/media/resources/document/methods/createDocument"
     * target="_blank">createDocument</a> method of the Media API. A variety of document types can be provided for regulatory compliance. For a list of supported document types, see <a href = "/api-docs/commerce/media/types/api:DocumentTypeEnum"
     * target="_blank">DocumentTypeEnum</a>.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DocumentType[]
     */
    public $Document;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for DocumentsType
     * @uses DocumentsType::setDocument()
     * @uses DocumentsType::setAny()
     * @param \StructType\DocumentType[] $document
     * @param \DOMDocument $any
     */
    public function __construct(array $document = array(), \DOMDocument $any = null)
    {
        $this
            ->setDocument($document)
            ->setAny($any);
    }
    /**
     * Get Document value
     * @return \StructType\DocumentType[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentForArrayConstraintsFromSetDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentsTypeDocumentItem) {
            // validation for constraint: itemType
            if (!$documentsTypeDocumentItem instanceof \StructType\DocumentType) {
                $invalidValues[] = is_object($documentsTypeDocumentItem) ? get_class($documentsTypeDocumentItem) : sprintf('%s(%s)', gettype($documentsTypeDocumentItem), var_export($documentsTypeDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document property can only contain items of type \StructType\DocumentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentType[] $document
     * @return \StructType\DocumentsType
     */
    public function setDocument(array $document = array())
    {
        // validation for constraint: array
        if ('' !== ($documentArrayErrorMessage = self::validateDocumentForArrayConstraintsFromSetDocument($document))) {
            throw new \InvalidArgumentException($documentArrayErrorMessage, __LINE__);
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \StructType\DocumentType $item
     * @return \StructType\DocumentsType
     */
    public function addToDocument(\StructType\DocumentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocumentType) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of type \StructType\DocumentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\DocumentsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
