<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponsiblePersonType StructType
 * Meta information extracted from the WSDL
 * - documentation: Type that provides information, such as name and contact details, for an EU-based Responsible Person or entity, associated with the product.
 * @subpackage Structs
 */
class ResponsiblePersonType extends AbstractStructBase
{
    /**
     * The Types
     * Meta information extracted from the WSDL
     * - documentation: The type(s) associated with the Responsible Person or entity.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ResponsiblePersonCodeTypes
     */
    public $Types;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - documentation: The name of the the Responsible Person or entity. <br />
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The Street1
     * Meta information extracted from the WSDL
     * - documentation: The first line of the responsible Responsible Person's address. <br />
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street1;
    /**
     * The Street2
     * Meta information extracted from the WSDL
     * - documentation: The second line of the Responsible Person's address. This field is not always used, but can be used for secondary address information such as 'Suite Number' or 'Apt Number'. <br />
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street2;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - documentation: The city of the Responsible Person's street address. <br />
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The StateOrProvince
     * Meta information extracted from the WSDL
     * - documentation: The state of province of the Responsible Person's street address. <br />
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StateOrProvince;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - documentation: The postal code of the Responsible Person's street address. <br />
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - documentation: The two letter <a href="https://www.iso.org/iso-3166-country-codes.html" target="_blank">ISO 3166-1</a> standard abbreviation of the country of the Responsible Person's address.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - documentation: The Responsible Person's business phone number. <br />
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - documentation: The Responsible Person's email address. <br />
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The ContactURL
     * Meta information extracted from the WSDL
     * - documentation: The Responsible Person's contact URL. <br />
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactURL;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for ResponsiblePersonType
     * @uses ResponsiblePersonType::setTypes()
     * @uses ResponsiblePersonType::setCompanyName()
     * @uses ResponsiblePersonType::setStreet1()
     * @uses ResponsiblePersonType::setStreet2()
     * @uses ResponsiblePersonType::setCityName()
     * @uses ResponsiblePersonType::setStateOrProvince()
     * @uses ResponsiblePersonType::setPostalCode()
     * @uses ResponsiblePersonType::setCountry()
     * @uses ResponsiblePersonType::setPhone()
     * @uses ResponsiblePersonType::setEmail()
     * @uses ResponsiblePersonType::setContactURL()
     * @uses ResponsiblePersonType::setAny()
     * @param \StructType\ResponsiblePersonCodeTypes $types
     * @param string $companyName
     * @param string $street1
     * @param string $street2
     * @param string $cityName
     * @param string $stateOrProvince
     * @param string $postalCode
     * @param string $country
     * @param string $phone
     * @param string $email
     * @param string $contactURL
     * @param \DOMDocument $any
     */
    public function __construct(\StructType\ResponsiblePersonCodeTypes $types = null, $companyName = null, $street1 = null, $street2 = null, $cityName = null, $stateOrProvince = null, $postalCode = null, $country = null, $phone = null, $email = null, $contactURL = null, \DOMDocument $any = null)
    {
        $this
            ->setTypes($types)
            ->setCompanyName($companyName)
            ->setStreet1($street1)
            ->setStreet2($street2)
            ->setCityName($cityName)
            ->setStateOrProvince($stateOrProvince)
            ->setPostalCode($postalCode)
            ->setCountry($country)
            ->setPhone($phone)
            ->setEmail($email)
            ->setContactURL($contactURL)
            ->setAny($any);
    }
    /**
     * Get Types value
     * @return \StructType\ResponsiblePersonCodeTypes
     */
    public function getTypes()
    {
        return $this->Types;
    }
    /**
     * Set Types value
     * @param \StructType\ResponsiblePersonCodeTypes $types
     * @return \StructType\ResponsiblePersonType
     */
    public function setTypes(\StructType\ResponsiblePersonCodeTypes $types = null)
    {
        $this->Types = $types;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \StructType\ResponsiblePersonType
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Street1 value
     * @return string|null
     */
    public function getStreet1()
    {
        return $this->Street1;
    }
    /**
     * Set Street1 value
     * @param string $street1
     * @return \StructType\ResponsiblePersonType
     */
    public function setStreet1($street1 = null)
    {
        // validation for constraint: string
        if (!is_null($street1) && !is_string($street1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street1, true), gettype($street1)), __LINE__);
        }
        $this->Street1 = $street1;
        return $this;
    }
    /**
     * Get Street2 value
     * @return string|null
     */
    public function getStreet2()
    {
        return $this->Street2;
    }
    /**
     * Set Street2 value
     * @param string $street2
     * @return \StructType\ResponsiblePersonType
     */
    public function setStreet2($street2 = null)
    {
        // validation for constraint: string
        if (!is_null($street2) && !is_string($street2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street2, true), gettype($street2)), __LINE__);
        }
        $this->Street2 = $street2;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \StructType\ResponsiblePersonType
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get StateOrProvince value
     * @return string|null
     */
    public function getStateOrProvince()
    {
        return $this->StateOrProvince;
    }
    /**
     * Set StateOrProvince value
     * @param string $stateOrProvince
     * @return \StructType\ResponsiblePersonType
     */
    public function setStateOrProvince($stateOrProvince = null)
    {
        // validation for constraint: string
        if (!is_null($stateOrProvince) && !is_string($stateOrProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateOrProvince, true), gettype($stateOrProvince)), __LINE__);
        }
        $this->StateOrProvince = $stateOrProvince;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\ResponsiblePersonType
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @uses \EnumType\CountryCodeType::valueIsValid()
     * @uses \EnumType\CountryCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $country
     * @return \StructType\ResponsiblePersonType
     */
    public function setCountry($country = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CountryCodeType::valueIsValid($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CountryCodeType', is_array($country) ? implode(', ', $country) : var_export($country, true), implode(', ', \EnumType\CountryCodeType::getValidValues())), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\ResponsiblePersonType
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\ResponsiblePersonType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get ContactURL value
     * @return string|null
     */
    public function getContactURL()
    {
        return $this->ContactURL;
    }
    /**
     * Set ContactURL value
     * @param string $contactURL
     * @return \StructType\ResponsiblePersonType
     */
    public function setContactURL($contactURL = null)
    {
        // validation for constraint: string
        if (!is_null($contactURL) && !is_string($contactURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactURL, true), gettype($contactURL)), __LINE__);
        }
        $this->ContactURL = $contactURL;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\ResponsiblePersonType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
