<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupportedSellerProfileType StructType
 * Meta information extracted from the WSDL
 * - documentation: Type defining the <b>SupportedSellerProfile</b> container, which contains summary information related to specific Business Policies payment, return policy, and shipping profiles. The profile type is found in the <b>ProfileType</b>
 * field.
 * @subpackage Structs
 */
class SupportedSellerProfileType extends AbstractStructBase
{
    /**
     * The ProfileID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier of a Business Policies profile. This identifier is auto-generated by eBay when the seller creates the profile. This field is always returned with the <b>SupportedSellerProfile</b> container.
     * - minOccurs: 0
     * @var int
     */
    public $ProfileID;
    /**
     * The ProfileType
     * Meta information extracted from the WSDL
     * - documentation: Indicates the type of the Business Policies profile. Valid values are PAYMENT, RETURN_POLICY, and SHIPPING. This field is always returned with the <b>SupportedSellerProfile</b> container.
     * - minOccurs: 0
     * @var string
     */
    public $ProfileType;
    /**
     * The ProfileName
     * Meta information extracted from the WSDL
     * - documentation: The seller-defined name for a Business Policies profile. This field is always returned with the <b>SupportedSellerProfile</b> container.
     * - minOccurs: 0
     * @var string
     */
    public $ProfileName;
    /**
     * The ShortSummary
     * Meta information extracted from the WSDL
     * - documentation: Seller-provided description of a Business Policies profile. This field is only returned if a seller has provided a description for the profile.
     * - minOccurs: 0
     * @var string
     */
    public $ShortSummary;
    /**
     * The CategoryGroup
     * Meta information extracted from the WSDL
     * - documentation: Identifies the the Business Policies category group associated with the Business Policies profile. Current values are ALL (referring to all non-motor vehicle categories) and MOTORS_VEHICLE (for motor vehicle listings).
     * - minOccurs: 0
     * @var \StructType\CategoryGroupType
     */
    public $CategoryGroup;
    /**
     * Constructor method for SupportedSellerProfileType
     * @uses SupportedSellerProfileType::setProfileID()
     * @uses SupportedSellerProfileType::setProfileType()
     * @uses SupportedSellerProfileType::setProfileName()
     * @uses SupportedSellerProfileType::setShortSummary()
     * @uses SupportedSellerProfileType::setCategoryGroup()
     * @param int $profileID
     * @param string $profileType
     * @param string $profileName
     * @param string $shortSummary
     * @param \StructType\CategoryGroupType $categoryGroup
     */
    public function __construct($profileID = null, $profileType = null, $profileName = null, $shortSummary = null, \StructType\CategoryGroupType $categoryGroup = null)
    {
        $this
            ->setProfileID($profileID)
            ->setProfileType($profileType)
            ->setProfileName($profileName)
            ->setShortSummary($shortSummary)
            ->setCategoryGroup($categoryGroup);
    }
    /**
     * Get ProfileID value
     * @return int|null
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param int $profileID
     * @return \StructType\SupportedSellerProfileType
     */
    public function setProfileID($profileID = null)
    {
        // validation for constraint: int
        if (!is_null($profileID) && !(is_int($profileID) || ctype_digit($profileID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileID, true), gettype($profileID)), __LINE__);
        }
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Get ProfileType value
     * @return string|null
     */
    public function getProfileType()
    {
        return $this->ProfileType;
    }
    /**
     * Set ProfileType value
     * @param string $profileType
     * @return \StructType\SupportedSellerProfileType
     */
    public function setProfileType($profileType = null)
    {
        // validation for constraint: string
        if (!is_null($profileType) && !is_string($profileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileType, true), gettype($profileType)), __LINE__);
        }
        $this->ProfileType = $profileType;
        return $this;
    }
    /**
     * Get ProfileName value
     * @return string|null
     */
    public function getProfileName()
    {
        return $this->ProfileName;
    }
    /**
     * Set ProfileName value
     * @param string $profileName
     * @return \StructType\SupportedSellerProfileType
     */
    public function setProfileName($profileName = null)
    {
        // validation for constraint: string
        if (!is_null($profileName) && !is_string($profileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileName, true), gettype($profileName)), __LINE__);
        }
        $this->ProfileName = $profileName;
        return $this;
    }
    /**
     * Get ShortSummary value
     * @return string|null
     */
    public function getShortSummary()
    {
        return $this->ShortSummary;
    }
    /**
     * Set ShortSummary value
     * @param string $shortSummary
     * @return \StructType\SupportedSellerProfileType
     */
    public function setShortSummary($shortSummary = null)
    {
        // validation for constraint: string
        if (!is_null($shortSummary) && !is_string($shortSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortSummary, true), gettype($shortSummary)), __LINE__);
        }
        $this->ShortSummary = $shortSummary;
        return $this;
    }
    /**
     * Get CategoryGroup value
     * @return \StructType\CategoryGroupType|null
     */
    public function getCategoryGroup()
    {
        return $this->CategoryGroup;
    }
    /**
     * Set CategoryGroup value
     * @param \StructType\CategoryGroupType $categoryGroup
     * @return \StructType\SupportedSellerProfileType
     */
    public function setCategoryGroup(\StructType\CategoryGroupType $categoryGroup = null)
    {
        $this->CategoryGroup = $categoryGroup;
        return $this;
    }
}
