<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vouchers StructType
 * Meta information extracted from the WSDL
 * - documentation: This node contains information about any voucher that might exist in the reservation
 * @subpackage Structs
 */
class Vouchers extends AbstractStructBase
{
    /**
     * The CouponReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\CouponReference[]
     */
    public $CouponReference;
    /**
     * Constructor method for Vouchers
     * @uses Vouchers::setCouponReference()
     * @param \StructType\CouponReference[] $couponReference
     */
    public function __construct(array $couponReference = array())
    {
        $this
            ->setCouponReference($couponReference);
    }
    /**
     * Get CouponReference value
     * @return \StructType\CouponReference[]|null
     */
    public function getCouponReference()
    {
        return $this->CouponReference;
    }
    /**
     * This method is responsible for validating the values passed to the setCouponReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCouponReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCouponReferenceForArrayConstraintsFromSetCouponReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vouchersCouponReferenceItem) {
            // validation for constraint: itemType
            if (!$vouchersCouponReferenceItem instanceof \StructType\CouponReference) {
                $invalidValues[] = is_object($vouchersCouponReferenceItem) ? get_class($vouchersCouponReferenceItem) : sprintf('%s(%s)', gettype($vouchersCouponReferenceItem), var_export($vouchersCouponReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CouponReference property can only contain items of type \StructType\CouponReference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CouponReference value
     * @throws \InvalidArgumentException
     * @param \StructType\CouponReference[] $couponReference
     * @return \StructType\Vouchers
     */
    public function setCouponReference(array $couponReference = array())
    {
        // validation for constraint: array
        if ('' !== ($couponReferenceArrayErrorMessage = self::validateCouponReferenceForArrayConstraintsFromSetCouponReference($couponReference))) {
            throw new \InvalidArgumentException($couponReferenceArrayErrorMessage, __LINE__);
        }
        $this->CouponReference = $couponReference;
        return $this;
    }
    /**
     * Add item to CouponReference value
     * @throws \InvalidArgumentException
     * @param \StructType\CouponReference $item
     * @return \StructType\Vouchers
     */
    public function addToCouponReference(\StructType\CouponReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CouponReference) {
            throw new \InvalidArgumentException(sprintf('The CouponReference property can only contain items of type \StructType\CouponReference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CouponReference[] = $item;
        return $this;
    }
}
