<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoucherType StructType
 * Meta information extracted from the WSDL
 * - documentation: A document that entitles the holder to a discount or that may be exchanged for goods or services.
 * @subpackage Structs
 */
class VoucherType extends AbstractStructBase
{
    /**
     * The VoucherID
     * Meta information extracted from the WSDL
     * - documentation: Voucher ID or Number. Example: XX12345 | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $VoucherID;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - documentation: Voucher Effective Date. Example: 2017-01-13 | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - documentation: Voucher Expiration date. Example: 2017-06-13 | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpirationDate;
    /**
     * The RemainingAmount
     * Meta information extracted from the WSDL
     * - documentation: Remaining Amount on Voucher.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $RemainingAmount;
    /**
     * Constructor method for VoucherType
     * @uses VoucherType::setVoucherID()
     * @uses VoucherType::setEffectiveDate()
     * @uses VoucherType::setExpirationDate()
     * @uses VoucherType::setRemainingAmount()
     * @param string $voucherID
     * @param string $effectiveDate
     * @param string $expirationDate
     * @param \StructType\AmountType $remainingAmount
     */
    public function __construct($voucherID = null, $effectiveDate = null, $expirationDate = null, \StructType\AmountType $remainingAmount = null)
    {
        $this
            ->setVoucherID($voucherID)
            ->setEffectiveDate($effectiveDate)
            ->setExpirationDate($expirationDate)
            ->setRemainingAmount($remainingAmount);
    }
    /**
     * Get VoucherID value
     * @return string
     */
    public function getVoucherID()
    {
        return $this->VoucherID;
    }
    /**
     * Set VoucherID value
     * @param string $voucherID
     * @return \StructType\VoucherType
     */
    public function setVoucherID($voucherID = null)
    {
        // validation for constraint: string
        if (!is_null($voucherID) && !is_string($voucherID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherID, true), gettype($voucherID)), __LINE__);
        }
        $this->VoucherID = $voucherID;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\VoucherType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\VoucherType
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get RemainingAmount value
     * @return \StructType\AmountType|null
     */
    public function getRemainingAmount()
    {
        return $this->RemainingAmount;
    }
    /**
     * Set RemainingAmount value
     * @param \StructType\AmountType $remainingAmount
     * @return \StructType\VoucherType
     */
    public function setRemainingAmount(\StructType\AmountType $remainingAmount = null)
    {
        $this->RemainingAmount = $remainingAmount;
        return $this;
    }
}
