<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VisaType StructType
 * Meta information extracted from the WSDL
 * - documentation: An official entry in a Passport or other Travel Document made by an official of a government to indicate that the bearer has been granted authority to enter or re-enter the country or region concerned.
 * @subpackage Structs
 */
class VisaType extends AbstractStructBase
{
    /**
     * The EntryQty
     * Meta information extracted from the WSDL
     * - documentation: Number of entries permitted by the visa into the host country. | A quantity is a counted number of non-monetary units, possibly including fractions
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $EntryQty;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - documentation: Date at which the visa expires and is no longer a valid entry document. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpiryDate;
    /**
     * The HostCountryCode
     * Meta information extracted from the WSDL
     * - documentation: ISO Country Code where the visa is valid. | The code list of ISO 3166 two-alpha Country Codes {codeListAgencyName}ISO{/codeListAgencyName} {codeListName}3166 two-alpha Country Codes{/codeListName} | The code list of ISO 3166
     * two-alpha Country Codes | ISO Country Code.
     * - base: CountryCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $HostCountryCode;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - documentation: Date at which the visa is issued. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssueDate;
    /**
     * The IssuingCountryCode
     * Meta information extracted from the WSDL
     * - documentation: ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR. | The code list of ISO 3166 two-alpha Country Codes {codeListAgencyName}ISO{/codeListAgencyName} {codeListName}3166
     * two-alpha Country Codes{/codeListName} | The code list of ISO 3166 two-alpha Country Codes | ISO Country Code.
     * - base: CountryCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $IssuingCountryCode;
    /**
     * The StayDuration
     * Meta information extracted from the WSDL
     * - documentation: Duration permitted of the Passenger's stay in the visa host country (in days). | A duration is the specification of a length of time without a fixed start or end time, expressed in Gregorian calendar time units (Year, Month, Week, or
     * Day) and Hours, Minutes or Seconds
     * - base: xs:duration
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StayDuration;
    /**
     * The VisaID
     * Meta information extracted from the WSDL
     * - documentation: Visa ID value. Example: NY122345. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VisaID;
    /**
     * The VisaTypeCode
     * Meta information extracted from the WSDL
     * - documentation: The type of visa. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VisaTypeCode;
    /**
     * Constructor method for VisaType
     * @uses VisaType::setEntryQty()
     * @uses VisaType::setExpiryDate()
     * @uses VisaType::setHostCountryCode()
     * @uses VisaType::setIssueDate()
     * @uses VisaType::setIssuingCountryCode()
     * @uses VisaType::setStayDuration()
     * @uses VisaType::setVisaID()
     * @uses VisaType::setVisaTypeCode()
     * @param float $entryQty
     * @param string $expiryDate
     * @param string $hostCountryCode
     * @param string $issueDate
     * @param string $issuingCountryCode
     * @param string $stayDuration
     * @param string $visaID
     * @param string $visaTypeCode
     */
    public function __construct($entryQty = null, $expiryDate = null, $hostCountryCode = null, $issueDate = null, $issuingCountryCode = null, $stayDuration = null, $visaID = null, $visaTypeCode = null)
    {
        $this
            ->setEntryQty($entryQty)
            ->setExpiryDate($expiryDate)
            ->setHostCountryCode($hostCountryCode)
            ->setIssueDate($issueDate)
            ->setIssuingCountryCode($issuingCountryCode)
            ->setStayDuration($stayDuration)
            ->setVisaID($visaID)
            ->setVisaTypeCode($visaTypeCode);
    }
    /**
     * Get EntryQty value
     * @return float|null
     */
    public function getEntryQty()
    {
        return $this->EntryQty;
    }
    /**
     * Set EntryQty value
     * @param float $entryQty
     * @return \StructType\VisaType
     */
    public function setEntryQty($entryQty = null)
    {
        // validation for constraint: float
        if (!is_null($entryQty) && !(is_float($entryQty) || is_numeric($entryQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($entryQty, true), gettype($entryQty)), __LINE__);
        }
        $this->EntryQty = $entryQty;
        return $this;
    }
    /**
     * Get ExpiryDate value
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->ExpiryDate;
    }
    /**
     * Set ExpiryDate value
     * @param string $expiryDate
     * @return \StructType\VisaType
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        $this->ExpiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get HostCountryCode value
     * @return string|null
     */
    public function getHostCountryCode()
    {
        return $this->HostCountryCode;
    }
    /**
     * Set HostCountryCode value
     * @param string $hostCountryCode
     * @return \StructType\VisaType
     */
    public function setHostCountryCode($hostCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($hostCountryCode) && !is_string($hostCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hostCountryCode, true), gettype($hostCountryCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2})
        if (!is_null($hostCountryCode) && !preg_match('/[A-Z]{2}/', $hostCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}', var_export($hostCountryCode, true)), __LINE__);
        }
        $this->HostCountryCode = $hostCountryCode;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \StructType\VisaType
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get IssuingCountryCode value
     * @return string|null
     */
    public function getIssuingCountryCode()
    {
        return $this->IssuingCountryCode;
    }
    /**
     * Set IssuingCountryCode value
     * @param string $issuingCountryCode
     * @return \StructType\VisaType
     */
    public function setIssuingCountryCode($issuingCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($issuingCountryCode) && !is_string($issuingCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuingCountryCode, true), gettype($issuingCountryCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2})
        if (!is_null($issuingCountryCode) && !preg_match('/[A-Z]{2}/', $issuingCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}', var_export($issuingCountryCode, true)), __LINE__);
        }
        $this->IssuingCountryCode = $issuingCountryCode;
        return $this;
    }
    /**
     * Get StayDuration value
     * @return string|null
     */
    public function getStayDuration()
    {
        return $this->StayDuration;
    }
    /**
     * Set StayDuration value
     * @param string $stayDuration
     * @return \StructType\VisaType
     */
    public function setStayDuration($stayDuration = null)
    {
        // validation for constraint: string
        if (!is_null($stayDuration) && !is_string($stayDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stayDuration, true), gettype($stayDuration)), __LINE__);
        }
        $this->StayDuration = $stayDuration;
        return $this;
    }
    /**
     * Get VisaID value
     * @return string|null
     */
    public function getVisaID()
    {
        return $this->VisaID;
    }
    /**
     * Set VisaID value
     * @param string $visaID
     * @return \StructType\VisaType
     */
    public function setVisaID($visaID = null)
    {
        // validation for constraint: string
        if (!is_null($visaID) && !is_string($visaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visaID, true), gettype($visaID)), __LINE__);
        }
        $this->VisaID = $visaID;
        return $this;
    }
    /**
     * Get VisaTypeCode value
     * @return string|null
     */
    public function getVisaTypeCode()
    {
        return $this->VisaTypeCode;
    }
    /**
     * Set VisaTypeCode value
     * @param string $visaTypeCode
     * @return \StructType\VisaType
     */
    public function setVisaTypeCode($visaTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($visaTypeCode) && !is_string($visaTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visaTypeCode, true), gettype($visaTypeCode)), __LINE__);
        }
        $this->VisaTypeCode = $visaTypeCode;
        return $this;
    }
}
