<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UseDocument StructType
 * Meta information extracted from the WSDL
 * - documentation: Allows documents (tickets/EMDs) to be sent with the request
 * @subpackage Structs
 */
class UseDocument extends AbstractStructBase
{
    /**
     * The TicketDocNbr
     * Meta information extracted from the WSDL
     * - documentation: Coupon Document Number.Note: This is the document number comprised of the airline code, form code, and serial number.
     * - base: xs:string
     * - maxLength: 14
     * - minLength: 1
     * @var string
     */
    public $TicketDocNbr;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Coupon Type. Example: Y (EMD-S Standalone)Encoding Scheme: IATA Padis Codeset - List for data element 1001 (Document/ Message Name, coded) | Used for codes in the IATA code tables. Possible values of this pattern are 1, 101, EQP
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}
     * @var string
     */
    public $Type;
    /**
     * Constructor method for UseDocument
     * @uses UseDocument::setTicketDocNbr()
     * @uses UseDocument::setType()
     * @param string $ticketDocNbr
     * @param string $type
     */
    public function __construct($ticketDocNbr = null, $type = null)
    {
        $this
            ->setTicketDocNbr($ticketDocNbr)
            ->setType($type);
    }
    /**
     * Get TicketDocNbr value
     * @return string|null
     */
    public function getTicketDocNbr()
    {
        return $this->TicketDocNbr;
    }
    /**
     * Set TicketDocNbr value
     * @param string $ticketDocNbr
     * @return \StructType\UseDocument
     */
    public function setTicketDocNbr($ticketDocNbr = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDocNbr) && !is_string($ticketDocNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDocNbr, true), gettype($ticketDocNbr)), __LINE__);
        }
        // validation for constraint: maxLength(14)
        if (!is_null($ticketDocNbr) && mb_strlen($ticketDocNbr) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 14', mb_strlen($ticketDocNbr)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ticketDocNbr) && mb_strlen($ticketDocNbr) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ticketDocNbr)), __LINE__);
        }
        $this->TicketDocNbr = $ticketDocNbr;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\UseDocument
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3})
        if (!is_null($type) && !preg_match('/[0-9A-Z]{1,3}/', $type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}', var_export($type, true)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
