<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Units StructType
 * Meta information extracted from the WSDL
 * - documentation: The units credited based on the request type.Units may be number of services, cost of service in points, miles or awardsExample: 52.25
 * @subpackage Structs
 */
class Units extends AbstractStructBase
{
    /**
     * The InitialUnits
     * @var mixed
     */
    public $InitialUnits;
    /**
     * The AvailableUnits
     * @var mixed
     */
    public $AvailableUnits;
    /**
     * The PendingUnits
     * @var mixed
     */
    public $PendingUnits;
    /**
     * The UsedUnits
     * @var mixed
     */
    public $UsedUnits;
    /**
     * The DiscountLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DiscountLevel
     */
    public $DiscountLevel;
    /**
     * The Threshold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $Threshold;
    /**
     * The EventType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EventType;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - documentation: Date in ISO 8601 format (yyyy-mm-dd). Example: 2001-12-25
     * - minOccurs: 0
     * @var string
     */
    public $CreationDate;
    /**
     * The TravelDates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TravelDates
     */
    public $TravelDates;
    /**
     * The BookingDates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BookingDates
     */
    public $BookingDates;
    /**
     * The DateControlled
     * @var string
     */
    public $DateControlled;
    /**
     * The OfferSubCode
     * @var string
     */
    public $OfferSubCode;
    /**
     * Constructor method for Units
     * @uses Units::setInitialUnits()
     * @uses Units::setAvailableUnits()
     * @uses Units::setPendingUnits()
     * @uses Units::setUsedUnits()
     * @uses Units::setDiscountLevel()
     * @uses Units::setThreshold()
     * @uses Units::setEventType()
     * @uses Units::setCreationDate()
     * @uses Units::setTravelDates()
     * @uses Units::setBookingDates()
     * @uses Units::setDateControlled()
     * @uses Units::setOfferSubCode()
     * @param mixed $initialUnits
     * @param mixed $availableUnits
     * @param mixed $pendingUnits
     * @param mixed $usedUnits
     * @param \StructType\DiscountLevel $discountLevel
     * @param mixed $threshold
     * @param string $eventType
     * @param string $creationDate
     * @param \StructType\TravelDates $travelDates
     * @param \StructType\BookingDates $bookingDates
     * @param string $dateControlled
     * @param string $offerSubCode
     */
    public function __construct($initialUnits = null, $availableUnits = null, $pendingUnits = null, $usedUnits = null, \StructType\DiscountLevel $discountLevel = null, $threshold = null, $eventType = null, $creationDate = null, \StructType\TravelDates $travelDates = null, \StructType\BookingDates $bookingDates = null, $dateControlled = null, $offerSubCode = null)
    {
        $this
            ->setInitialUnits($initialUnits)
            ->setAvailableUnits($availableUnits)
            ->setPendingUnits($pendingUnits)
            ->setUsedUnits($usedUnits)
            ->setDiscountLevel($discountLevel)
            ->setThreshold($threshold)
            ->setEventType($eventType)
            ->setCreationDate($creationDate)
            ->setTravelDates($travelDates)
            ->setBookingDates($bookingDates)
            ->setDateControlled($dateControlled)
            ->setOfferSubCode($offerSubCode);
    }
    /**
     * Get InitialUnits value
     * @return mixed|null
     */
    public function getInitialUnits()
    {
        return $this->InitialUnits;
    }
    /**
     * Set InitialUnits value
     * @param mixed $initialUnits
     * @return \StructType\Units
     */
    public function setInitialUnits($initialUnits = null)
    {
        $this->InitialUnits = $initialUnits;
        return $this;
    }
    /**
     * Get AvailableUnits value
     * @return mixed|null
     */
    public function getAvailableUnits()
    {
        return $this->AvailableUnits;
    }
    /**
     * Set AvailableUnits value
     * @param mixed $availableUnits
     * @return \StructType\Units
     */
    public function setAvailableUnits($availableUnits = null)
    {
        $this->AvailableUnits = $availableUnits;
        return $this;
    }
    /**
     * Get PendingUnits value
     * @return mixed|null
     */
    public function getPendingUnits()
    {
        return $this->PendingUnits;
    }
    /**
     * Set PendingUnits value
     * @param mixed $pendingUnits
     * @return \StructType\Units
     */
    public function setPendingUnits($pendingUnits = null)
    {
        $this->PendingUnits = $pendingUnits;
        return $this;
    }
    /**
     * Get UsedUnits value
     * @return mixed|null
     */
    public function getUsedUnits()
    {
        return $this->UsedUnits;
    }
    /**
     * Set UsedUnits value
     * @param mixed $usedUnits
     * @return \StructType\Units
     */
    public function setUsedUnits($usedUnits = null)
    {
        $this->UsedUnits = $usedUnits;
        return $this;
    }
    /**
     * Get DiscountLevel value
     * @return \StructType\DiscountLevel|null
     */
    public function getDiscountLevel()
    {
        return $this->DiscountLevel;
    }
    /**
     * Set DiscountLevel value
     * @param \StructType\DiscountLevel $discountLevel
     * @return \StructType\Units
     */
    public function setDiscountLevel(\StructType\DiscountLevel $discountLevel = null)
    {
        $this->DiscountLevel = $discountLevel;
        return $this;
    }
    /**
     * Get Threshold value
     * @return mixed|null
     */
    public function getThreshold()
    {
        return $this->Threshold;
    }
    /**
     * Set Threshold value
     * @param mixed $threshold
     * @return \StructType\Units
     */
    public function setThreshold($threshold = null)
    {
        $this->Threshold = $threshold;
        return $this;
    }
    /**
     * Get EventType value
     * @return string|null
     */
    public function getEventType()
    {
        return $this->EventType;
    }
    /**
     * Set EventType value
     * @uses \EnumType\EventType::valueIsValid()
     * @uses \EnumType\EventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eventType
     * @return \StructType\Units
     */
    public function setEventType($eventType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EventType::valueIsValid($eventType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EventType', is_array($eventType) ? implode(', ', $eventType) : var_export($eventType, true), implode(', ', \EnumType\EventType::getValidValues())), __LINE__);
        }
        $this->EventType = $eventType;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \StructType\Units
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get TravelDates value
     * @return \StructType\TravelDates|null
     */
    public function getTravelDates()
    {
        return $this->TravelDates;
    }
    /**
     * Set TravelDates value
     * @param \StructType\TravelDates $travelDates
     * @return \StructType\Units
     */
    public function setTravelDates(\StructType\TravelDates $travelDates = null)
    {
        $this->TravelDates = $travelDates;
        return $this;
    }
    /**
     * Get BookingDates value
     * @return \StructType\BookingDates|null
     */
    public function getBookingDates()
    {
        return $this->BookingDates;
    }
    /**
     * Set BookingDates value
     * @param \StructType\BookingDates $bookingDates
     * @return \StructType\Units
     */
    public function setBookingDates(\StructType\BookingDates $bookingDates = null)
    {
        $this->BookingDates = $bookingDates;
        return $this;
    }
    /**
     * Get DateControlled value
     * @return string|null
     */
    public function getDateControlled()
    {
        return $this->DateControlled;
    }
    /**
     * Set DateControlled value
     * @param string $dateControlled
     * @return \StructType\Units
     */
    public function setDateControlled($dateControlled = null)
    {
        // validation for constraint: string
        if (!is_null($dateControlled) && !is_string($dateControlled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateControlled, true), gettype($dateControlled)), __LINE__);
        }
        $this->DateControlled = $dateControlled;
        return $this;
    }
    /**
     * Get OfferSubCode value
     * @return string|null
     */
    public function getOfferSubCode()
    {
        return $this->OfferSubCode;
    }
    /**
     * Set OfferSubCode value
     * @param string $offerSubCode
     * @return \StructType\Units
     */
    public function setOfferSubCode($offerSubCode = null)
    {
        // validation for constraint: string
        if (!is_null($offerSubCode) && !is_string($offerSubCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerSubCode, true), gettype($offerSubCode)), __LINE__);
        }
        $this->OfferSubCode = $offerSubCode;
        return $this;
    }
}
