<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxSummaryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Tax summary information.
 * @subpackage Structs
 */
class TaxSummaryType extends AbstractStructBase
{
    /**
     * The AllRefundableInd
     * Meta information extracted from the WSDL
     * - documentation: When true, all tax breakdown amounts are refundable. | DEPRECATED - This element is deprecated as of 24.1 and will be decommissioned in a future release. Please consult implementation guidance on alternatives to this element. When
     * true, all tax breakdown amounts are refundable. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AllRefundableInd;
    /**
     * The ApproximateInd
     * Meta information extracted from the WSDL
     * - documentation: When true, this tax is approximate. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ApproximateInd;
    /**
     * The CollectionInd
     * Meta information extracted from the WSDL
     * - documentation: When true, all specified tax breakdowns must be collected. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $CollectionInd;
    /**
     * The GuaranteeTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The length of time the Tax of an offer item is guaranteed. In the absence of the Tax guarantee time limit, the Tax is not guaranteed. Upon expiry, the Tax may no longer be guaranteed and either a new shopping process should begin, or
     * the offer should be repriced resulting in a new Offer. Should the Tax guarantee time limit extend beyond Order creation, the remaining length of time persists into the corresponding Order Item. The airline can increase the remaining length of time
     * beyond the original time limit should they wish to. This field should only be used when the Airline indicates that a Price Guarantee is available.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GuaranteeTimeLimitDateTime;
    /**
     * The RefundMethodText
     * Meta information extracted from the WSDL
     * - documentation: Information from the Airline detailing to the Customer how the tax refund will be processed and what the Customer has to do for the refund. | A name is a word or phrase that constitutes the distinctive designation of a person, place,
     * thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefundMethodText;
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - documentation: A compulsory contribution to state revenue, levied by the government on workers' income and business profits or added to the cost of some goods, services, and transactions.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxType[]
     */
    public $Tax;
    /**
     * The TotalRefundableTaxAmount
     * Meta information extracted from the WSDL
     * - documentation: The total amount of all refundable taxes as calculated by the Airline.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $TotalRefundableTaxAmount;
    /**
     * The TotalTaxAmount
     * Meta information extracted from the WSDL
     * - documentation: Total of all applicable tax amounts included in the price. If tax breakdowns are provided, this amount should match the sum of the tax breakdown amounts.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $TotalTaxAmount;
    /**
     * Constructor method for TaxSummaryType
     * @uses TaxSummaryType::setAllRefundableInd()
     * @uses TaxSummaryType::setApproximateInd()
     * @uses TaxSummaryType::setCollectionInd()
     * @uses TaxSummaryType::setGuaranteeTimeLimitDateTime()
     * @uses TaxSummaryType::setRefundMethodText()
     * @uses TaxSummaryType::setTax()
     * @uses TaxSummaryType::setTotalRefundableTaxAmount()
     * @uses TaxSummaryType::setTotalTaxAmount()
     * @param bool $allRefundableInd
     * @param bool $approximateInd
     * @param bool $collectionInd
     * @param string $guaranteeTimeLimitDateTime
     * @param string $refundMethodText
     * @param \StructType\TaxType[] $tax
     * @param \StructType\AmountType $totalRefundableTaxAmount
     * @param \StructType\AmountType $totalTaxAmount
     */
    public function __construct($allRefundableInd = null, $approximateInd = null, $collectionInd = null, $guaranteeTimeLimitDateTime = null, $refundMethodText = null, array $tax = array(), \StructType\AmountType $totalRefundableTaxAmount = null, \StructType\AmountType $totalTaxAmount = null)
    {
        $this
            ->setAllRefundableInd($allRefundableInd)
            ->setApproximateInd($approximateInd)
            ->setCollectionInd($collectionInd)
            ->setGuaranteeTimeLimitDateTime($guaranteeTimeLimitDateTime)
            ->setRefundMethodText($refundMethodText)
            ->setTax($tax)
            ->setTotalRefundableTaxAmount($totalRefundableTaxAmount)
            ->setTotalTaxAmount($totalTaxAmount);
    }
    /**
     * Get AllRefundableInd value
     * @return bool|null
     */
    public function getAllRefundableInd()
    {
        return $this->AllRefundableInd;
    }
    /**
     * Set AllRefundableInd value
     * @param bool $allRefundableInd
     * @return \StructType\TaxSummaryType
     */
    public function setAllRefundableInd($allRefundableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($allRefundableInd) && !is_bool($allRefundableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allRefundableInd, true), gettype($allRefundableInd)), __LINE__);
        }
        $this->AllRefundableInd = $allRefundableInd;
        return $this;
    }
    /**
     * Get ApproximateInd value
     * @return bool|null
     */
    public function getApproximateInd()
    {
        return $this->ApproximateInd;
    }
    /**
     * Set ApproximateInd value
     * @param bool $approximateInd
     * @return \StructType\TaxSummaryType
     */
    public function setApproximateInd($approximateInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($approximateInd) && !is_bool($approximateInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($approximateInd, true), gettype($approximateInd)), __LINE__);
        }
        $this->ApproximateInd = $approximateInd;
        return $this;
    }
    /**
     * Get CollectionInd value
     * @return bool|null
     */
    public function getCollectionInd()
    {
        return $this->CollectionInd;
    }
    /**
     * Set CollectionInd value
     * @param bool $collectionInd
     * @return \StructType\TaxSummaryType
     */
    public function setCollectionInd($collectionInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($collectionInd) && !is_bool($collectionInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($collectionInd, true), gettype($collectionInd)), __LINE__);
        }
        $this->CollectionInd = $collectionInd;
        return $this;
    }
    /**
     * Get GuaranteeTimeLimitDateTime value
     * @return string|null
     */
    public function getGuaranteeTimeLimitDateTime()
    {
        return $this->GuaranteeTimeLimitDateTime;
    }
    /**
     * Set GuaranteeTimeLimitDateTime value
     * @param string $guaranteeTimeLimitDateTime
     * @return \StructType\TaxSummaryType
     */
    public function setGuaranteeTimeLimitDateTime($guaranteeTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteeTimeLimitDateTime) && !is_string($guaranteeTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guaranteeTimeLimitDateTime, true), gettype($guaranteeTimeLimitDateTime)), __LINE__);
        }
        $this->GuaranteeTimeLimitDateTime = $guaranteeTimeLimitDateTime;
        return $this;
    }
    /**
     * Get RefundMethodText value
     * @return string|null
     */
    public function getRefundMethodText()
    {
        return $this->RefundMethodText;
    }
    /**
     * Set RefundMethodText value
     * @param string $refundMethodText
     * @return \StructType\TaxSummaryType
     */
    public function setRefundMethodText($refundMethodText = null)
    {
        // validation for constraint: string
        if (!is_null($refundMethodText) && !is_string($refundMethodText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refundMethodText, true), gettype($refundMethodText)), __LINE__);
        }
        $this->RefundMethodText = $refundMethodText;
        return $this;
    }
    /**
     * Get Tax value
     * @return \StructType\TaxType[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * This method is responsible for validating the values passed to the setTax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxForArrayConstraintsFromSetTax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxSummaryTypeTaxItem) {
            // validation for constraint: itemType
            if (!$taxSummaryTypeTaxItem instanceof \StructType\TaxType) {
                $invalidValues[] = is_object($taxSummaryTypeTaxItem) ? get_class($taxSummaryTypeTaxItem) : sprintf('%s(%s)', gettype($taxSummaryTypeTaxItem), var_export($taxSummaryTypeTaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax property can only contain items of type \StructType\TaxType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxType[] $tax
     * @return \StructType\TaxSummaryType
     */
    public function setTax(array $tax = array())
    {
        // validation for constraint: array
        if ('' !== ($taxArrayErrorMessage = self::validateTaxForArrayConstraintsFromSetTax($tax))) {
            throw new \InvalidArgumentException($taxArrayErrorMessage, __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxType $item
     * @return \StructType\TaxSummaryType
     */
    public function addToTax(\StructType\TaxType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxType) {
            throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of type \StructType\TaxType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get TotalRefundableTaxAmount value
     * @return \StructType\AmountType|null
     */
    public function getTotalRefundableTaxAmount()
    {
        return $this->TotalRefundableTaxAmount;
    }
    /**
     * Set TotalRefundableTaxAmount value
     * @param \StructType\AmountType $totalRefundableTaxAmount
     * @return \StructType\TaxSummaryType
     */
    public function setTotalRefundableTaxAmount(\StructType\AmountType $totalRefundableTaxAmount = null)
    {
        $this->TotalRefundableTaxAmount = $totalRefundableTaxAmount;
        return $this;
    }
    /**
     * Get TotalTaxAmount value
     * @return \StructType\AmountType|null
     */
    public function getTotalTaxAmount()
    {
        return $this->TotalTaxAmount;
    }
    /**
     * Set TotalTaxAmount value
     * @param \StructType\AmountType $totalTaxAmount
     * @return \StructType\TaxSummaryType
     */
    public function setTotalTaxAmount(\StructType\AmountType $totalTaxAmount = null)
    {
        $this->TotalTaxAmount = $totalTaxAmount;
        return $this;
    }
}
