<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SurchargeTypeBasic StructType
 * Meta information extracted from the WSDL
 * - documentation: Fare Amount as filed in the currency defined in FiledCurrencyCode | Currency for this FareComponent may not be the same as POS Currency Code. Example: HKD
 * @subpackage Structs
 */
class SurchargeTypeBasic extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Individual surcharge amount. Example: 270
     * - use: required
     * @var int
     */
    public $Amount;
    /**
     * The Designator
     * Meta information extracted from the WSDL
     * - documentation: Tax or surcharge designator. Example: US | Surcharge designator.
     * - base: xs:string
     * - minLength: 1
     * - type: xs:string
     * @var string
     */
    public $Designator;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Summary (one line) event description | Description of the offer | Tax or surcharge description. Example: US national transportation | Surcharge descriptions as free form text.
     * - base: xs:string
     * - minLength: 1
     * - minOccurs: 0
     * - type: xs:string
     * @var string
     */
    public $Description;
    /**
     * The FiledCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: FiledCurrencyCode
     * @var \StructType\FiledCurrencyCode
     */
    public $FiledCurrencyCode;
    /**
     * The FiledAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: FiledAmount
     * @var \StructType\FiledAmount
     */
    public $FiledAmount;
    /**
     * Constructor method for SurchargeTypeBasic
     * @uses SurchargeTypeBasic::setAmount()
     * @uses SurchargeTypeBasic::setDesignator()
     * @uses SurchargeTypeBasic::setDescription()
     * @uses SurchargeTypeBasic::setFiledCurrencyCode()
     * @uses SurchargeTypeBasic::setFiledAmount()
     * @param int $amount
     * @param string $designator
     * @param string $description
     * @param \StructType\FiledCurrencyCode $filedCurrencyCode
     * @param \StructType\FiledAmount $filedAmount
     */
    public function __construct($amount = null, $designator = null, $description = null, \StructType\FiledCurrencyCode $filedCurrencyCode = null, \StructType\FiledAmount $filedAmount = null)
    {
        $this
            ->setAmount($amount)
            ->setDesignator($designator)
            ->setDescription($description)
            ->setFiledCurrencyCode($filedCurrencyCode)
            ->setFiledAmount($filedAmount);
    }
    /**
     * Get Amount value
     * @return int
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param int $amount
     * @return \StructType\SurchargeTypeBasic
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: int
        if (!is_null($amount) && !(is_int($amount) || ctype_digit($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Designator value
     * @return string|null
     */
    public function getDesignator()
    {
        return $this->Designator;
    }
    /**
     * Set Designator value
     * @param string $designator
     * @return \StructType\SurchargeTypeBasic
     */
    public function setDesignator($designator = null)
    {
        // validation for constraint: string
        if (!is_null($designator) && !is_string($designator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($designator, true), gettype($designator)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($designator) && mb_strlen($designator) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($designator)), __LINE__);
        }
        $this->Designator = $designator;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\SurchargeTypeBasic
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($description) && mb_strlen($description) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get FiledCurrencyCode value
     * @return \StructType\FiledCurrencyCode|null
     */
    public function getFiledCurrencyCode()
    {
        return $this->FiledCurrencyCode;
    }
    /**
     * Set FiledCurrencyCode value
     * @param \StructType\FiledCurrencyCode $filedCurrencyCode
     * @return \StructType\SurchargeTypeBasic
     */
    public function setFiledCurrencyCode(\StructType\FiledCurrencyCode $filedCurrencyCode = null)
    {
        $this->FiledCurrencyCode = $filedCurrencyCode;
        return $this;
    }
    /**
     * Get FiledAmount value
     * @return \StructType\FiledAmount|null
     */
    public function getFiledAmount()
    {
        return $this->FiledAmount;
    }
    /**
     * Set FiledAmount value
     * @param \StructType\FiledAmount $filedAmount
     * @return \StructType\SurchargeTypeBasic
     */
    public function setFiledAmount(\StructType\FiledAmount $filedAmount = null)
    {
        $this->FiledAmount = $filedAmount;
        return $this;
    }
}
