<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SurchargeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Amount added on to a usual charge for a specific product, purpose, or service.
 * @subpackage Structs
 */
class SurchargeType extends SurchargeTypeBasic
{
    /**
     * The Segment
     * Meta information extracted from the WSDL
     * - documentation: Segment number to which the surcharge applies. Example: 1
     * @var int
     */
    public $Segment;
    /**
     * The AllRefundableInd
     * Meta information extracted from the WSDL
     * - documentation: DEPRECATED - This element is deprecated as of 24.1 and will be decommissioned in a future release. Please consult implementation guidance on alternatives to this element. When true, all tax breakdown amounts are refundable. | An
     * indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AllRefundableInd;
    /**
     * The Breakdown
     * Meta information extracted from the WSDL
     * - documentation: Amount added on to a charge for a specific product, purpose, or service.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FeeType[]
     */
    public $Breakdown;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - documentation: Summary of all fee amounts.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $TotalAmount;
    /**
     * Constructor method for SurchargeType
     * @uses SurchargeType::setSegment()
     * @uses SurchargeType::setAllRefundableInd()
     * @uses SurchargeType::setBreakdown()
     * @uses SurchargeType::setTotalAmount()
     * @param int $segment
     * @param bool $allRefundableInd
     * @param \StructType\FeeType[] $breakdown
     * @param \StructType\AmountType $totalAmount
     */
    public function __construct($segment = null, $allRefundableInd = null, array $breakdown = array(), \StructType\AmountType $totalAmount = null)
    {
        $this
            ->setSegment($segment)
            ->setAllRefundableInd($allRefundableInd)
            ->setBreakdown($breakdown)
            ->setTotalAmount($totalAmount);
    }
    /**
     * Get Segment value
     * @return int|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @param int $segment
     * @return \StructType\SurchargeType
     */
    public function setSegment($segment = null)
    {
        // validation for constraint: int
        if (!is_null($segment) && !(is_int($segment) || ctype_digit($segment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($segment, true), gettype($segment)), __LINE__);
        }
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Get AllRefundableInd value
     * @return bool|null
     */
    public function getAllRefundableInd()
    {
        return $this->AllRefundableInd;
    }
    /**
     * Set AllRefundableInd value
     * @param bool $allRefundableInd
     * @return \StructType\SurchargeType
     */
    public function setAllRefundableInd($allRefundableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($allRefundableInd) && !is_bool($allRefundableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allRefundableInd, true), gettype($allRefundableInd)), __LINE__);
        }
        $this->AllRefundableInd = $allRefundableInd;
        return $this;
    }
    /**
     * Get Breakdown value
     * @return \StructType\FeeType[]|null
     */
    public function getBreakdown()
    {
        return $this->Breakdown;
    }
    /**
     * This method is responsible for validating the values passed to the setBreakdown method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBreakdown method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBreakdownForArrayConstraintsFromSetBreakdown(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $surchargeTypeBreakdownItem) {
            // validation for constraint: itemType
            if (!$surchargeTypeBreakdownItem instanceof \StructType\FeeType) {
                $invalidValues[] = is_object($surchargeTypeBreakdownItem) ? get_class($surchargeTypeBreakdownItem) : sprintf('%s(%s)', gettype($surchargeTypeBreakdownItem), var_export($surchargeTypeBreakdownItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Breakdown property can only contain items of type \StructType\FeeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Breakdown value
     * @throws \InvalidArgumentException
     * @param \StructType\FeeType[] $breakdown
     * @return \StructType\SurchargeType
     */
    public function setBreakdown(array $breakdown = array())
    {
        // validation for constraint: array
        if ('' !== ($breakdownArrayErrorMessage = self::validateBreakdownForArrayConstraintsFromSetBreakdown($breakdown))) {
            throw new \InvalidArgumentException($breakdownArrayErrorMessage, __LINE__);
        }
        $this->Breakdown = $breakdown;
        return $this;
    }
    /**
     * Add item to Breakdown value
     * @throws \InvalidArgumentException
     * @param \StructType\FeeType $item
     * @return \StructType\SurchargeType
     */
    public function addToBreakdown(\StructType\FeeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FeeType) {
            throw new \InvalidArgumentException(sprintf('The Breakdown property can only contain items of type \StructType\FeeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Breakdown[] = $item;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return \StructType\AmountType|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param \StructType\AmountType $totalAmount
     * @return \StructType\SurchargeType
     */
    public function setTotalAmount(\StructType\AmountType $totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
}
