<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplierPriceType StructType
 * Meta information extracted from the WSDL
 * - documentation: The amount of money expected, required, or given in payment for something.
 * @subpackage Structs
 */
class SupplierPriceType extends AbstractStructBase
{
    /**
     * The BaseAmount
     * Meta information extracted from the WSDL
     * - documentation: Total Base Fare Amount. Example: 200000
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $BaseAmount;
    /**
     * The CurConversion
     * Meta information extracted from the WSDL
     * - documentation: The result of converting one currency into another currency. E.g. local currency to USD, air miles to monetary.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CurConversionType[]
     */
    public $CurConversion;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - documentation: Deduction from the price amount, made in advance of its payment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DiscountType
     */
    public $Discount;
    /**
     * The Fee
     * Meta information extracted from the WSDL
     * - documentation: Amount added on to a charge for a specific product, purpose, or service.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FeeType[]
     */
    public $Fee;
    /**
     * The Surcharge
     * Meta information extracted from the WSDL
     * - documentation: Amount added on to a usual charge for a specific product, purpose, or service.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SurchargeType[]
     */
    public $Surcharge;
    /**
     * The TaxSummary
     * Meta information extracted from the WSDL
     * - documentation: Tax summary information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxSummaryType[]
     */
    public $TaxSummary;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - documentation: Total monetary price amount, including all tax, surcharge, and fee amounts.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $TotalAmount;
    /**
     * Constructor method for SupplierPriceType
     * @uses SupplierPriceType::setBaseAmount()
     * @uses SupplierPriceType::setCurConversion()
     * @uses SupplierPriceType::setDiscount()
     * @uses SupplierPriceType::setFee()
     * @uses SupplierPriceType::setSurcharge()
     * @uses SupplierPriceType::setTaxSummary()
     * @uses SupplierPriceType::setTotalAmount()
     * @param \StructType\AmountType $baseAmount
     * @param \StructType\CurConversionType[] $curConversion
     * @param \StructType\DiscountType $discount
     * @param \StructType\FeeType[] $fee
     * @param \StructType\SurchargeType[] $surcharge
     * @param \StructType\TaxSummaryType[] $taxSummary
     * @param \StructType\AmountType $totalAmount
     */
    public function __construct(\StructType\AmountType $baseAmount = null, array $curConversion = array(), \StructType\DiscountType $discount = null, array $fee = array(), array $surcharge = array(), array $taxSummary = array(), \StructType\AmountType $totalAmount = null)
    {
        $this
            ->setBaseAmount($baseAmount)
            ->setCurConversion($curConversion)
            ->setDiscount($discount)
            ->setFee($fee)
            ->setSurcharge($surcharge)
            ->setTaxSummary($taxSummary)
            ->setTotalAmount($totalAmount);
    }
    /**
     * Get BaseAmount value
     * @return \StructType\AmountType|null
     */
    public function getBaseAmount()
    {
        return $this->BaseAmount;
    }
    /**
     * Set BaseAmount value
     * @param \StructType\AmountType $baseAmount
     * @return \StructType\SupplierPriceType
     */
    public function setBaseAmount(\StructType\AmountType $baseAmount = null)
    {
        $this->BaseAmount = $baseAmount;
        return $this;
    }
    /**
     * Get CurConversion value
     * @return \StructType\CurConversionType[]|null
     */
    public function getCurConversion()
    {
        return $this->CurConversion;
    }
    /**
     * This method is responsible for validating the values passed to the setCurConversion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurConversion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurConversionForArrayConstraintsFromSetCurConversion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierPriceTypeCurConversionItem) {
            // validation for constraint: itemType
            if (!$supplierPriceTypeCurConversionItem instanceof \StructType\CurConversionType) {
                $invalidValues[] = is_object($supplierPriceTypeCurConversionItem) ? get_class($supplierPriceTypeCurConversionItem) : sprintf('%s(%s)', gettype($supplierPriceTypeCurConversionItem), var_export($supplierPriceTypeCurConversionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CurConversion property can only contain items of type \StructType\CurConversionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CurConversion value
     * @throws \InvalidArgumentException
     * @param \StructType\CurConversionType[] $curConversion
     * @return \StructType\SupplierPriceType
     */
    public function setCurConversion(array $curConversion = array())
    {
        // validation for constraint: array
        if ('' !== ($curConversionArrayErrorMessage = self::validateCurConversionForArrayConstraintsFromSetCurConversion($curConversion))) {
            throw new \InvalidArgumentException($curConversionArrayErrorMessage, __LINE__);
        }
        $this->CurConversion = $curConversion;
        return $this;
    }
    /**
     * Add item to CurConversion value
     * @throws \InvalidArgumentException
     * @param \StructType\CurConversionType $item
     * @return \StructType\SupplierPriceType
     */
    public function addToCurConversion(\StructType\CurConversionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CurConversionType) {
            throw new \InvalidArgumentException(sprintf('The CurConversion property can only contain items of type \StructType\CurConversionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CurConversion[] = $item;
        return $this;
    }
    /**
     * Get Discount value
     * @return \StructType\DiscountType|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param \StructType\DiscountType $discount
     * @return \StructType\SupplierPriceType
     */
    public function setDiscount(\StructType\DiscountType $discount = null)
    {
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get Fee value
     * @return \StructType\FeeType[]|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * This method is responsible for validating the values passed to the setFee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeeForArrayConstraintsFromSetFee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierPriceTypeFeeItem) {
            // validation for constraint: itemType
            if (!$supplierPriceTypeFeeItem instanceof \StructType\FeeType) {
                $invalidValues[] = is_object($supplierPriceTypeFeeItem) ? get_class($supplierPriceTypeFeeItem) : sprintf('%s(%s)', gettype($supplierPriceTypeFeeItem), var_export($supplierPriceTypeFeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fee property can only contain items of type \StructType\FeeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fee value
     * @throws \InvalidArgumentException
     * @param \StructType\FeeType[] $fee
     * @return \StructType\SupplierPriceType
     */
    public function setFee(array $fee = array())
    {
        // validation for constraint: array
        if ('' !== ($feeArrayErrorMessage = self::validateFeeForArrayConstraintsFromSetFee($fee))) {
            throw new \InvalidArgumentException($feeArrayErrorMessage, __LINE__);
        }
        $this->Fee = $fee;
        return $this;
    }
    /**
     * Add item to Fee value
     * @throws \InvalidArgumentException
     * @param \StructType\FeeType $item
     * @return \StructType\SupplierPriceType
     */
    public function addToFee(\StructType\FeeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FeeType) {
            throw new \InvalidArgumentException(sprintf('The Fee property can only contain items of type \StructType\FeeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Fee[] = $item;
        return $this;
    }
    /**
     * Get Surcharge value
     * @return \StructType\SurchargeType[]|null
     */
    public function getSurcharge()
    {
        return $this->Surcharge;
    }
    /**
     * This method is responsible for validating the values passed to the setSurcharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSurcharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSurchargeForArrayConstraintsFromSetSurcharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierPriceTypeSurchargeItem) {
            // validation for constraint: itemType
            if (!$supplierPriceTypeSurchargeItem instanceof \StructType\SurchargeType) {
                $invalidValues[] = is_object($supplierPriceTypeSurchargeItem) ? get_class($supplierPriceTypeSurchargeItem) : sprintf('%s(%s)', gettype($supplierPriceTypeSurchargeItem), var_export($supplierPriceTypeSurchargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Surcharge property can only contain items of type \StructType\SurchargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Surcharge value
     * @throws \InvalidArgumentException
     * @param \StructType\SurchargeType[] $surcharge
     * @return \StructType\SupplierPriceType
     */
    public function setSurcharge(array $surcharge = array())
    {
        // validation for constraint: array
        if ('' !== ($surchargeArrayErrorMessage = self::validateSurchargeForArrayConstraintsFromSetSurcharge($surcharge))) {
            throw new \InvalidArgumentException($surchargeArrayErrorMessage, __LINE__);
        }
        $this->Surcharge = $surcharge;
        return $this;
    }
    /**
     * Add item to Surcharge value
     * @throws \InvalidArgumentException
     * @param \StructType\SurchargeType $item
     * @return \StructType\SupplierPriceType
     */
    public function addToSurcharge(\StructType\SurchargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SurchargeType) {
            throw new \InvalidArgumentException(sprintf('The Surcharge property can only contain items of type \StructType\SurchargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Surcharge[] = $item;
        return $this;
    }
    /**
     * Get TaxSummary value
     * @return \StructType\TaxSummaryType[]|null
     */
    public function getTaxSummary()
    {
        return $this->TaxSummary;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxSummaryForArrayConstraintsFromSetTaxSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierPriceTypeTaxSummaryItem) {
            // validation for constraint: itemType
            if (!$supplierPriceTypeTaxSummaryItem instanceof \StructType\TaxSummaryType) {
                $invalidValues[] = is_object($supplierPriceTypeTaxSummaryItem) ? get_class($supplierPriceTypeTaxSummaryItem) : sprintf('%s(%s)', gettype($supplierPriceTypeTaxSummaryItem), var_export($supplierPriceTypeTaxSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxSummary property can only contain items of type \StructType\TaxSummaryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxSummaryType[] $taxSummary
     * @return \StructType\SupplierPriceType
     */
    public function setTaxSummary(array $taxSummary = array())
    {
        // validation for constraint: array
        if ('' !== ($taxSummaryArrayErrorMessage = self::validateTaxSummaryForArrayConstraintsFromSetTaxSummary($taxSummary))) {
            throw new \InvalidArgumentException($taxSummaryArrayErrorMessage, __LINE__);
        }
        $this->TaxSummary = $taxSummary;
        return $this;
    }
    /**
     * Add item to TaxSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxSummaryType $item
     * @return \StructType\SupplierPriceType
     */
    public function addToTaxSummary(\StructType\TaxSummaryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxSummaryType) {
            throw new \InvalidArgumentException(sprintf('The TaxSummary property can only contain items of type \StructType\TaxSummaryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxSummary[] = $item;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return \StructType\AmountType|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param \StructType\AmountType $totalAmount
     * @return \StructType\SupplierPriceType
     */
    public function setTotalAmount(\StructType\AmountType $totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
}
