<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplierOrderItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: A Supplier individually priced item within a Supplier Order, made up of one or more Services. May or may not be a selected Offer Item (e.g. non-chargeable Services available on request such as a wheelchair).
 * @subpackage Structs
 */
class SupplierOrderItemType extends AbstractStructBase
{
    /**
     * The OrderItemID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which exists uniquely within an Order. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderItemID;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - documentation: A Supplier Ordered Service specialization of the instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of
     * shopping, a service can be sold to multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\SupplierOrderedServiceType[]
     */
    public $Service;
    /**
     * The AcceptanceRule
     * Meta information extracted from the WSDL
     * - documentation: A rule which is an account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AcceptanceRuleType[]
     */
    public $AcceptanceRule;
    /**
     * The AirlineTaxonomy
     * Meta information extracted from the WSDL
     * - documentation: Used in the context of the Airline Taxonomy to define a product or service to the seller or to request a collection of products and services from an airline. For more information on what values should be placed within these fields,
     * see the implementation guide at: https://guides.developer.iata.org
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineTaxonomyType[]
     */
    public $AirlineTaxonomy;
    /**
     * The BilateralTimeLimit
     * Meta information extracted from the WSDL
     * - documentation: A bilaterally agreed limitation or restriction of time.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BilateralTimeLimitType[]
     */
    public $BilateralTimeLimit;
    /**
     * The CabinTypeList
     * Meta information extracted from the WSDL
     * - documentation: List of Cabin Types Technical object only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CabinTypeListType
     */
    public $CabinTypeList;
    /**
     * The CancelRestrictions
     * Meta information extracted from the WSDL
     * - documentation: These are a set of qualifying conditions/rules/restrictions that are related to a constrained priced grouping of services for the Cancellation action.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CancelRestrictionsType[]
     */
    public $CancelRestrictions;
    /**
     * The ChangeRestrictions
     * Meta information extracted from the WSDL
     * - documentation: These are a set of qualifying conditions/rules/restriction that are related to a constrained priced grouping of services for a Change/modification action.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ChangeRestrictionsType[]
     */
    public $ChangeRestrictions;
    /**
     * The CombinableCarrier
     * Meta information extracted from the WSDL
     * - documentation: Interline variant of the carrier abie. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * Business Identifier Fields: - Airline Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InterlineCarrierType[]
     */
    public $CombinableCarrier;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - documentation: Order Item creation Timestamp. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreationDateTime;
    /**
     * The DisclosureRefID
     * Meta information extracted from the WSDL
     * - documentation: References a Disclosure ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DisclosureRefID;
    /**
     * The FareDetail
     * Meta information extracted from the WSDL
     * - documentation: The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareDetailType[]
     */
    public $FareDetail;
    /**
     * The GrandTotalAmount
     * Meta information extracted from the WSDL
     * - documentation: Reflects the Differential Total Amount and the Penalty Total Amount, if netted.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $GrandTotalAmount;
    /**
     * The MinimumConnectiontimeDuration
     * Meta information extracted from the WSDL
     * - documentation: The minimum time needed for the passenger to transit from a flight service to the next flight service. | A duration is the specification of a length of time without a fixed start or end time, expressed in Gregorian calendar time
     * units (Year, Month, Week, or Day) and Hours, Minutes or Seconds
     * - base: xs:duration
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MinimumConnectiontimeDuration;
    /**
     * The NamingTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The time by which an Order Item must be completed with individual passenger names. Examples: 2015-01-13T13:59:38Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute,
     * second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NamingTimeLimitDateTime;
    /**
     * The OwnerTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether or not the owner is the Supplier or Retailer. | Specifies the type of Owner for a given Offer/Order/Order Item (E.g. ORA, POA).
     * - base: OwnerTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OwnerTypeCode;
    /**
     * The PenaltyRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Penalty ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PenaltyRefID;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SupplierPriceType
     */
    public $Price;
    /**
     * The ReusableInd
     * Meta information extracted from the WSDL
     * - documentation: If Reusable = true, indicates that part of the value of the OrderItem may be reused for reshopping or refund. Exact reusable amount is unknown until Seller requests to reshop or to process a refund for this OrderItem. | An indicator
     * is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ReusableInd;
    /**
     * The SpecialServiceList
     * Meta information extracted from the WSDL
     * - documentation: List of Special service types. Technical object only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SpecialServiceListType
     */
    public $SpecialServiceList;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the Order Item Status instance. See ATSB Codeset OrderItem for possible values. | The possible statuses of an Order Item {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Ordered Item Status,
     * Coded.{/codeListName} {codeListIdentifier}ORDERITEM{/codeListIdentifier} | represents the status of an Order Item
     * - base: OrderItemStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The WebAddressURI
     * Meta information extracted from the WSDL
     * - documentation: Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer. | A string of characters used to identify a resource. Such identification
     * enables interaction with representations of the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebAddressURI;
    /**
     * Constructor method for SupplierOrderItemType
     * @uses SupplierOrderItemType::setOrderItemID()
     * @uses SupplierOrderItemType::setOwnerCode()
     * @uses SupplierOrderItemType::setService()
     * @uses SupplierOrderItemType::setAcceptanceRule()
     * @uses SupplierOrderItemType::setAirlineTaxonomy()
     * @uses SupplierOrderItemType::setBilateralTimeLimit()
     * @uses SupplierOrderItemType::setCabinTypeList()
     * @uses SupplierOrderItemType::setCancelRestrictions()
     * @uses SupplierOrderItemType::setChangeRestrictions()
     * @uses SupplierOrderItemType::setCombinableCarrier()
     * @uses SupplierOrderItemType::setCreationDateTime()
     * @uses SupplierOrderItemType::setDisclosureRefID()
     * @uses SupplierOrderItemType::setFareDetail()
     * @uses SupplierOrderItemType::setGrandTotalAmount()
     * @uses SupplierOrderItemType::setMinimumConnectiontimeDuration()
     * @uses SupplierOrderItemType::setNamingTimeLimitDateTime()
     * @uses SupplierOrderItemType::setOwnerTypeCode()
     * @uses SupplierOrderItemType::setPenaltyRefID()
     * @uses SupplierOrderItemType::setPrice()
     * @uses SupplierOrderItemType::setReusableInd()
     * @uses SupplierOrderItemType::setSpecialServiceList()
     * @uses SupplierOrderItemType::setStatusCode()
     * @uses SupplierOrderItemType::setWebAddressURI()
     * @param string $orderItemID
     * @param string $ownerCode
     * @param \StructType\SupplierOrderedServiceType[] $service
     * @param \StructType\AcceptanceRuleType[] $acceptanceRule
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @param \StructType\BilateralTimeLimitType[] $bilateralTimeLimit
     * @param \StructType\CabinTypeListType $cabinTypeList
     * @param \StructType\CancelRestrictionsType[] $cancelRestrictions
     * @param \StructType\ChangeRestrictionsType[] $changeRestrictions
     * @param \StructType\InterlineCarrierType[] $combinableCarrier
     * @param string $creationDateTime
     * @param string[] $disclosureRefID
     * @param \StructType\FareDetailType[] $fareDetail
     * @param \StructType\AmountType $grandTotalAmount
     * @param string $minimumConnectiontimeDuration
     * @param string $namingTimeLimitDateTime
     * @param string $ownerTypeCode
     * @param string[] $penaltyRefID
     * @param \StructType\SupplierPriceType $price
     * @param bool $reusableInd
     * @param \StructType\SpecialServiceListType $specialServiceList
     * @param string $statusCode
     * @param string $webAddressURI
     */
    public function __construct($orderItemID = null, $ownerCode = null, array $service = array(), array $acceptanceRule = array(), array $airlineTaxonomy = array(), array $bilateralTimeLimit = array(), \StructType\CabinTypeListType $cabinTypeList = null, array $cancelRestrictions = array(), array $changeRestrictions = array(), array $combinableCarrier = array(), $creationDateTime = null, array $disclosureRefID = array(), array $fareDetail = array(), \StructType\AmountType $grandTotalAmount = null, $minimumConnectiontimeDuration = null, $namingTimeLimitDateTime = null, $ownerTypeCode = null, array $penaltyRefID = array(), \StructType\SupplierPriceType $price = null, $reusableInd = null, \StructType\SpecialServiceListType $specialServiceList = null, $statusCode = null, $webAddressURI = null)
    {
        $this
            ->setOrderItemID($orderItemID)
            ->setOwnerCode($ownerCode)
            ->setService($service)
            ->setAcceptanceRule($acceptanceRule)
            ->setAirlineTaxonomy($airlineTaxonomy)
            ->setBilateralTimeLimit($bilateralTimeLimit)
            ->setCabinTypeList($cabinTypeList)
            ->setCancelRestrictions($cancelRestrictions)
            ->setChangeRestrictions($changeRestrictions)
            ->setCombinableCarrier($combinableCarrier)
            ->setCreationDateTime($creationDateTime)
            ->setDisclosureRefID($disclosureRefID)
            ->setFareDetail($fareDetail)
            ->setGrandTotalAmount($grandTotalAmount)
            ->setMinimumConnectiontimeDuration($minimumConnectiontimeDuration)
            ->setNamingTimeLimitDateTime($namingTimeLimitDateTime)
            ->setOwnerTypeCode($ownerTypeCode)
            ->setPenaltyRefID($penaltyRefID)
            ->setPrice($price)
            ->setReusableInd($reusableInd)
            ->setSpecialServiceList($specialServiceList)
            ->setStatusCode($statusCode)
            ->setWebAddressURI($webAddressURI);
    }
    /**
     * Get OrderItemID value
     * @return string
     */
    public function getOrderItemID()
    {
        return $this->OrderItemID;
    }
    /**
     * Set OrderItemID value
     * @param string $orderItemID
     * @return \StructType\SupplierOrderItemType
     */
    public function setOrderItemID($orderItemID = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemID) && !is_string($orderItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderItemID, true), gettype($orderItemID)), __LINE__);
        }
        $this->OrderItemID = $orderItemID;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\SupplierOrderItemType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\SupplierOrderedServiceType[]
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * This method is responsible for validating the values passed to the setService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceForArrayConstraintsFromSetService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOrderItemTypeServiceItem) {
            // validation for constraint: itemType
            if (!$supplierOrderItemTypeServiceItem instanceof \StructType\SupplierOrderedServiceType) {
                $invalidValues[] = is_object($supplierOrderItemTypeServiceItem) ? get_class($supplierOrderItemTypeServiceItem) : sprintf('%s(%s)', gettype($supplierOrderItemTypeServiceItem), var_export($supplierOrderItemTypeServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service property can only contain items of type \StructType\SupplierOrderedServiceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierOrderedServiceType[] $service
     * @return \StructType\SupplierOrderItemType
     */
    public function setService(array $service = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceArrayErrorMessage = self::validateServiceForArrayConstraintsFromSetService($service))) {
            throw new \InvalidArgumentException($serviceArrayErrorMessage, __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierOrderedServiceType $item
     * @return \StructType\SupplierOrderItemType
     */
    public function addToService(\StructType\SupplierOrderedServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierOrderedServiceType) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of type \StructType\SupplierOrderedServiceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
    /**
     * Get AcceptanceRule value
     * @return \StructType\AcceptanceRuleType[]|null
     */
    public function getAcceptanceRule()
    {
        return $this->AcceptanceRule;
    }
    /**
     * This method is responsible for validating the values passed to the setAcceptanceRule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAcceptanceRule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAcceptanceRuleForArrayConstraintsFromSetAcceptanceRule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOrderItemTypeAcceptanceRuleItem) {
            // validation for constraint: itemType
            if (!$supplierOrderItemTypeAcceptanceRuleItem instanceof \StructType\AcceptanceRuleType) {
                $invalidValues[] = is_object($supplierOrderItemTypeAcceptanceRuleItem) ? get_class($supplierOrderItemTypeAcceptanceRuleItem) : sprintf('%s(%s)', gettype($supplierOrderItemTypeAcceptanceRuleItem), var_export($supplierOrderItemTypeAcceptanceRuleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AcceptanceRule property can only contain items of type \StructType\AcceptanceRuleType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AcceptanceRule value
     * @throws \InvalidArgumentException
     * @param \StructType\AcceptanceRuleType[] $acceptanceRule
     * @return \StructType\SupplierOrderItemType
     */
    public function setAcceptanceRule(array $acceptanceRule = array())
    {
        // validation for constraint: array
        if ('' !== ($acceptanceRuleArrayErrorMessage = self::validateAcceptanceRuleForArrayConstraintsFromSetAcceptanceRule($acceptanceRule))) {
            throw new \InvalidArgumentException($acceptanceRuleArrayErrorMessage, __LINE__);
        }
        $this->AcceptanceRule = $acceptanceRule;
        return $this;
    }
    /**
     * Add item to AcceptanceRule value
     * @throws \InvalidArgumentException
     * @param \StructType\AcceptanceRuleType $item
     * @return \StructType\SupplierOrderItemType
     */
    public function addToAcceptanceRule(\StructType\AcceptanceRuleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AcceptanceRuleType) {
            throw new \InvalidArgumentException(sprintf('The AcceptanceRule property can only contain items of type \StructType\AcceptanceRuleType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AcceptanceRule[] = $item;
        return $this;
    }
    /**
     * Get AirlineTaxonomy value
     * @return \StructType\AirlineTaxonomyType[]|null
     */
    public function getAirlineTaxonomy()
    {
        return $this->AirlineTaxonomy;
    }
    /**
     * This method is responsible for validating the values passed to the setAirlineTaxonomy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirlineTaxonomy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOrderItemTypeAirlineTaxonomyItem) {
            // validation for constraint: itemType
            if (!$supplierOrderItemTypeAirlineTaxonomyItem instanceof \StructType\AirlineTaxonomyType) {
                $invalidValues[] = is_object($supplierOrderItemTypeAirlineTaxonomyItem) ? get_class($supplierOrderItemTypeAirlineTaxonomyItem) : sprintf('%s(%s)', gettype($supplierOrderItemTypeAirlineTaxonomyItem), var_export($supplierOrderItemTypeAirlineTaxonomyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType[] $airlineTaxonomy
     * @return \StructType\SupplierOrderItemType
     */
    public function setAirlineTaxonomy(array $airlineTaxonomy = array())
    {
        // validation for constraint: array
        if ('' !== ($airlineTaxonomyArrayErrorMessage = self::validateAirlineTaxonomyForArrayConstraintsFromSetAirlineTaxonomy($airlineTaxonomy))) {
            throw new \InvalidArgumentException($airlineTaxonomyArrayErrorMessage, __LINE__);
        }
        $this->AirlineTaxonomy = $airlineTaxonomy;
        return $this;
    }
    /**
     * Add item to AirlineTaxonomy value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineTaxonomyType $item
     * @return \StructType\SupplierOrderItemType
     */
    public function addToAirlineTaxonomy(\StructType\AirlineTaxonomyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineTaxonomyType) {
            throw new \InvalidArgumentException(sprintf('The AirlineTaxonomy property can only contain items of type \StructType\AirlineTaxonomyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirlineTaxonomy[] = $item;
        return $this;
    }
    /**
     * Get BilateralTimeLimit value
     * @return \StructType\BilateralTimeLimitType[]|null
     */
    public function getBilateralTimeLimit()
    {
        return $this->BilateralTimeLimit;
    }
    /**
     * This method is responsible for validating the values passed to the setBilateralTimeLimit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBilateralTimeLimit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBilateralTimeLimitForArrayConstraintsFromSetBilateralTimeLimit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOrderItemTypeBilateralTimeLimitItem) {
            // validation for constraint: itemType
            if (!$supplierOrderItemTypeBilateralTimeLimitItem instanceof \StructType\BilateralTimeLimitType) {
                $invalidValues[] = is_object($supplierOrderItemTypeBilateralTimeLimitItem) ? get_class($supplierOrderItemTypeBilateralTimeLimitItem) : sprintf('%s(%s)', gettype($supplierOrderItemTypeBilateralTimeLimitItem), var_export($supplierOrderItemTypeBilateralTimeLimitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BilateralTimeLimit property can only contain items of type \StructType\BilateralTimeLimitType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BilateralTimeLimit value
     * @throws \InvalidArgumentException
     * @param \StructType\BilateralTimeLimitType[] $bilateralTimeLimit
     * @return \StructType\SupplierOrderItemType
     */
    public function setBilateralTimeLimit(array $bilateralTimeLimit = array())
    {
        // validation for constraint: array
        if ('' !== ($bilateralTimeLimitArrayErrorMessage = self::validateBilateralTimeLimitForArrayConstraintsFromSetBilateralTimeLimit($bilateralTimeLimit))) {
            throw new \InvalidArgumentException($bilateralTimeLimitArrayErrorMessage, __LINE__);
        }
        $this->BilateralTimeLimit = $bilateralTimeLimit;
        return $this;
    }
    /**
     * Add item to BilateralTimeLimit value
     * @throws \InvalidArgumentException
     * @param \StructType\BilateralTimeLimitType $item
     * @return \StructType\SupplierOrderItemType
     */
    public function addToBilateralTimeLimit(\StructType\BilateralTimeLimitType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BilateralTimeLimitType) {
            throw new \InvalidArgumentException(sprintf('The BilateralTimeLimit property can only contain items of type \StructType\BilateralTimeLimitType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BilateralTimeLimit[] = $item;
        return $this;
    }
    /**
     * Get CabinTypeList value
     * @return \StructType\CabinTypeListType|null
     */
    public function getCabinTypeList()
    {
        return $this->CabinTypeList;
    }
    /**
     * Set CabinTypeList value
     * @param \StructType\CabinTypeListType $cabinTypeList
     * @return \StructType\SupplierOrderItemType
     */
    public function setCabinTypeList(\StructType\CabinTypeListType $cabinTypeList = null)
    {
        $this->CabinTypeList = $cabinTypeList;
        return $this;
    }
    /**
     * Get CancelRestrictions value
     * @return \StructType\CancelRestrictionsType[]|null
     */
    public function getCancelRestrictions()
    {
        return $this->CancelRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setCancelRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCancelRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCancelRestrictionsForArrayConstraintsFromSetCancelRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOrderItemTypeCancelRestrictionsItem) {
            // validation for constraint: itemType
            if (!$supplierOrderItemTypeCancelRestrictionsItem instanceof \StructType\CancelRestrictionsType) {
                $invalidValues[] = is_object($supplierOrderItemTypeCancelRestrictionsItem) ? get_class($supplierOrderItemTypeCancelRestrictionsItem) : sprintf('%s(%s)', gettype($supplierOrderItemTypeCancelRestrictionsItem), var_export($supplierOrderItemTypeCancelRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CancelRestrictions property can only contain items of type \StructType\CancelRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CancelRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRestrictionsType[] $cancelRestrictions
     * @return \StructType\SupplierOrderItemType
     */
    public function setCancelRestrictions(array $cancelRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($cancelRestrictionsArrayErrorMessage = self::validateCancelRestrictionsForArrayConstraintsFromSetCancelRestrictions($cancelRestrictions))) {
            throw new \InvalidArgumentException($cancelRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->CancelRestrictions = $cancelRestrictions;
        return $this;
    }
    /**
     * Add item to CancelRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\CancelRestrictionsType $item
     * @return \StructType\SupplierOrderItemType
     */
    public function addToCancelRestrictions(\StructType\CancelRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CancelRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The CancelRestrictions property can only contain items of type \StructType\CancelRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CancelRestrictions[] = $item;
        return $this;
    }
    /**
     * Get ChangeRestrictions value
     * @return \StructType\ChangeRestrictionsType[]|null
     */
    public function getChangeRestrictions()
    {
        return $this->ChangeRestrictions;
    }
    /**
     * This method is responsible for validating the values passed to the setChangeRestrictions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChangeRestrictions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChangeRestrictionsForArrayConstraintsFromSetChangeRestrictions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOrderItemTypeChangeRestrictionsItem) {
            // validation for constraint: itemType
            if (!$supplierOrderItemTypeChangeRestrictionsItem instanceof \StructType\ChangeRestrictionsType) {
                $invalidValues[] = is_object($supplierOrderItemTypeChangeRestrictionsItem) ? get_class($supplierOrderItemTypeChangeRestrictionsItem) : sprintf('%s(%s)', gettype($supplierOrderItemTypeChangeRestrictionsItem), var_export($supplierOrderItemTypeChangeRestrictionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ChangeRestrictions property can only contain items of type \StructType\ChangeRestrictionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChangeRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRestrictionsType[] $changeRestrictions
     * @return \StructType\SupplierOrderItemType
     */
    public function setChangeRestrictions(array $changeRestrictions = array())
    {
        // validation for constraint: array
        if ('' !== ($changeRestrictionsArrayErrorMessage = self::validateChangeRestrictionsForArrayConstraintsFromSetChangeRestrictions($changeRestrictions))) {
            throw new \InvalidArgumentException($changeRestrictionsArrayErrorMessage, __LINE__);
        }
        $this->ChangeRestrictions = $changeRestrictions;
        return $this;
    }
    /**
     * Add item to ChangeRestrictions value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeRestrictionsType $item
     * @return \StructType\SupplierOrderItemType
     */
    public function addToChangeRestrictions(\StructType\ChangeRestrictionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangeRestrictionsType) {
            throw new \InvalidArgumentException(sprintf('The ChangeRestrictions property can only contain items of type \StructType\ChangeRestrictionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ChangeRestrictions[] = $item;
        return $this;
    }
    /**
     * Get CombinableCarrier value
     * @return \StructType\InterlineCarrierType[]|null
     */
    public function getCombinableCarrier()
    {
        return $this->CombinableCarrier;
    }
    /**
     * This method is responsible for validating the values passed to the setCombinableCarrier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCombinableCarrier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCombinableCarrierForArrayConstraintsFromSetCombinableCarrier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOrderItemTypeCombinableCarrierItem) {
            // validation for constraint: itemType
            if (!$supplierOrderItemTypeCombinableCarrierItem instanceof \StructType\InterlineCarrierType) {
                $invalidValues[] = is_object($supplierOrderItemTypeCombinableCarrierItem) ? get_class($supplierOrderItemTypeCombinableCarrierItem) : sprintf('%s(%s)', gettype($supplierOrderItemTypeCombinableCarrierItem), var_export($supplierOrderItemTypeCombinableCarrierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CombinableCarrier property can only contain items of type \StructType\InterlineCarrierType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CombinableCarrier value
     * @throws \InvalidArgumentException
     * @param \StructType\InterlineCarrierType[] $combinableCarrier
     * @return \StructType\SupplierOrderItemType
     */
    public function setCombinableCarrier(array $combinableCarrier = array())
    {
        // validation for constraint: array
        if ('' !== ($combinableCarrierArrayErrorMessage = self::validateCombinableCarrierForArrayConstraintsFromSetCombinableCarrier($combinableCarrier))) {
            throw new \InvalidArgumentException($combinableCarrierArrayErrorMessage, __LINE__);
        }
        $this->CombinableCarrier = $combinableCarrier;
        return $this;
    }
    /**
     * Add item to CombinableCarrier value
     * @throws \InvalidArgumentException
     * @param \StructType\InterlineCarrierType $item
     * @return \StructType\SupplierOrderItemType
     */
    public function addToCombinableCarrier(\StructType\InterlineCarrierType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InterlineCarrierType) {
            throw new \InvalidArgumentException(sprintf('The CombinableCarrier property can only contain items of type \StructType\InterlineCarrierType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CombinableCarrier[] = $item;
        return $this;
    }
    /**
     * Get CreationDateTime value
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return $this->CreationDateTime;
    }
    /**
     * Set CreationDateTime value
     * @param string $creationDateTime
     * @return \StructType\SupplierOrderItemType
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        $this->CreationDateTime = $creationDateTime;
        return $this;
    }
    /**
     * Get DisclosureRefID value
     * @return string[]|null
     */
    public function getDisclosureRefID()
    {
        return $this->DisclosureRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setDisclosureRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisclosureRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDisclosureRefIDForArrayConstraintsFromSetDisclosureRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOrderItemTypeDisclosureRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($supplierOrderItemTypeDisclosureRefIDItem)) {
                $invalidValues[] = is_object($supplierOrderItemTypeDisclosureRefIDItem) ? get_class($supplierOrderItemTypeDisclosureRefIDItem) : sprintf('%s(%s)', gettype($supplierOrderItemTypeDisclosureRefIDItem), var_export($supplierOrderItemTypeDisclosureRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DisclosureRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DisclosureRefID value
     * @throws \InvalidArgumentException
     * @param string[] $disclosureRefID
     * @return \StructType\SupplierOrderItemType
     */
    public function setDisclosureRefID(array $disclosureRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($disclosureRefIDArrayErrorMessage = self::validateDisclosureRefIDForArrayConstraintsFromSetDisclosureRefID($disclosureRefID))) {
            throw new \InvalidArgumentException($disclosureRefIDArrayErrorMessage, __LINE__);
        }
        $this->DisclosureRefID = $disclosureRefID;
        return $this;
    }
    /**
     * Add item to DisclosureRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SupplierOrderItemType
     */
    public function addToDisclosureRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DisclosureRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DisclosureRefID[] = $item;
        return $this;
    }
    /**
     * Get FareDetail value
     * @return \StructType\FareDetailType[]|null
     */
    public function getFareDetail()
    {
        return $this->FareDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setFareDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareDetailForArrayConstraintsFromSetFareDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOrderItemTypeFareDetailItem) {
            // validation for constraint: itemType
            if (!$supplierOrderItemTypeFareDetailItem instanceof \StructType\FareDetailType) {
                $invalidValues[] = is_object($supplierOrderItemTypeFareDetailItem) ? get_class($supplierOrderItemTypeFareDetailItem) : sprintf('%s(%s)', gettype($supplierOrderItemTypeFareDetailItem), var_export($supplierOrderItemTypeFareDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareDetail property can only contain items of type \StructType\FareDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FareDetailType[] $fareDetail
     * @return \StructType\SupplierOrderItemType
     */
    public function setFareDetail(array $fareDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($fareDetailArrayErrorMessage = self::validateFareDetailForArrayConstraintsFromSetFareDetail($fareDetail))) {
            throw new \InvalidArgumentException($fareDetailArrayErrorMessage, __LINE__);
        }
        $this->FareDetail = $fareDetail;
        return $this;
    }
    /**
     * Add item to FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FareDetailType $item
     * @return \StructType\SupplierOrderItemType
     */
    public function addToFareDetail(\StructType\FareDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareDetailType) {
            throw new \InvalidArgumentException(sprintf('The FareDetail property can only contain items of type \StructType\FareDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareDetail[] = $item;
        return $this;
    }
    /**
     * Get GrandTotalAmount value
     * @return \StructType\AmountType|null
     */
    public function getGrandTotalAmount()
    {
        return $this->GrandTotalAmount;
    }
    /**
     * Set GrandTotalAmount value
     * @param \StructType\AmountType $grandTotalAmount
     * @return \StructType\SupplierOrderItemType
     */
    public function setGrandTotalAmount(\StructType\AmountType $grandTotalAmount = null)
    {
        $this->GrandTotalAmount = $grandTotalAmount;
        return $this;
    }
    /**
     * Get MinimumConnectiontimeDuration value
     * @return string|null
     */
    public function getMinimumConnectiontimeDuration()
    {
        return $this->MinimumConnectiontimeDuration;
    }
    /**
     * Set MinimumConnectiontimeDuration value
     * @param string $minimumConnectiontimeDuration
     * @return \StructType\SupplierOrderItemType
     */
    public function setMinimumConnectiontimeDuration($minimumConnectiontimeDuration = null)
    {
        // validation for constraint: string
        if (!is_null($minimumConnectiontimeDuration) && !is_string($minimumConnectiontimeDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumConnectiontimeDuration, true), gettype($minimumConnectiontimeDuration)), __LINE__);
        }
        $this->MinimumConnectiontimeDuration = $minimumConnectiontimeDuration;
        return $this;
    }
    /**
     * Get NamingTimeLimitDateTime value
     * @return string|null
     */
    public function getNamingTimeLimitDateTime()
    {
        return $this->NamingTimeLimitDateTime;
    }
    /**
     * Set NamingTimeLimitDateTime value
     * @param string $namingTimeLimitDateTime
     * @return \StructType\SupplierOrderItemType
     */
    public function setNamingTimeLimitDateTime($namingTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($namingTimeLimitDateTime) && !is_string($namingTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namingTimeLimitDateTime, true), gettype($namingTimeLimitDateTime)), __LINE__);
        }
        $this->NamingTimeLimitDateTime = $namingTimeLimitDateTime;
        return $this;
    }
    /**
     * Get OwnerTypeCode value
     * @return string|null
     */
    public function getOwnerTypeCode()
    {
        return $this->OwnerTypeCode;
    }
    /**
     * Set OwnerTypeCode value
     * @param string $ownerTypeCode
     * @return \StructType\SupplierOrderItemType
     */
    public function setOwnerTypeCode($ownerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerTypeCode) && !is_string($ownerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerTypeCode, true), gettype($ownerTypeCode)), __LINE__);
        }
        $this->OwnerTypeCode = $ownerTypeCode;
        return $this;
    }
    /**
     * Get PenaltyRefID value
     * @return string[]|null
     */
    public function getPenaltyRefID()
    {
        return $this->PenaltyRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPenaltyRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPenaltyRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplierOrderItemTypePenaltyRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($supplierOrderItemTypePenaltyRefIDItem)) {
                $invalidValues[] = is_object($supplierOrderItemTypePenaltyRefIDItem) ? get_class($supplierOrderItemTypePenaltyRefIDItem) : sprintf('%s(%s)', gettype($supplierOrderItemTypePenaltyRefIDItem), var_export($supplierOrderItemTypePenaltyRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string[] $penaltyRefID
     * @return \StructType\SupplierOrderItemType
     */
    public function setPenaltyRefID(array $penaltyRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($penaltyRefIDArrayErrorMessage = self::validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID($penaltyRefID))) {
            throw new \InvalidArgumentException($penaltyRefIDArrayErrorMessage, __LINE__);
        }
        $this->PenaltyRefID = $penaltyRefID;
        return $this;
    }
    /**
     * Add item to PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SupplierOrderItemType
     */
    public function addToPenaltyRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PenaltyRefID[] = $item;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\SupplierPriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\SupplierPriceType $price
     * @return \StructType\SupplierOrderItemType
     */
    public function setPrice(\StructType\SupplierPriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get ReusableInd value
     * @return bool|null
     */
    public function getReusableInd()
    {
        return $this->ReusableInd;
    }
    /**
     * Set ReusableInd value
     * @param bool $reusableInd
     * @return \StructType\SupplierOrderItemType
     */
    public function setReusableInd($reusableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($reusableInd) && !is_bool($reusableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reusableInd, true), gettype($reusableInd)), __LINE__);
        }
        $this->ReusableInd = $reusableInd;
        return $this;
    }
    /**
     * Get SpecialServiceList value
     * @return \StructType\SpecialServiceListType|null
     */
    public function getSpecialServiceList()
    {
        return $this->SpecialServiceList;
    }
    /**
     * Set SpecialServiceList value
     * @param \StructType\SpecialServiceListType $specialServiceList
     * @return \StructType\SupplierOrderItemType
     */
    public function setSpecialServiceList(\StructType\SpecialServiceListType $specialServiceList = null)
    {
        $this->SpecialServiceList = $specialServiceList;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\SupplierOrderItemType
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get WebAddressURI value
     * @return string|null
     */
    public function getWebAddressURI()
    {
        return $this->WebAddressURI;
    }
    /**
     * Set WebAddressURI value
     * @param string $webAddressURI
     * @return \StructType\SupplierOrderItemType
     */
    public function setWebAddressURI($webAddressURI = null)
    {
        // validation for constraint: string
        if (!is_null($webAddressURI) && !is_string($webAddressURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webAddressURI, true), gettype($webAddressURI)), __LINE__);
        }
        $this->WebAddressURI = $webAddressURI;
        return $this;
    }
}
