<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopInformation StructType
 * Meta information extracted from the WSDL
 * - documentation: ONLY used in case of a Change of Gauge flight the equipment for the continuation of the flight is mapped here. | Stop information groupA Change of Gauge flight requires the @ChangeOfGauge attribte to be set to Y; it also requires to
 * map the new equipment used from this stop forward.
 * @subpackage Structs
 */
class StopInformation extends AbstractStructBase
{
    /**
     * The AirportCode
     * Meta information extracted from the WSDL
     * - documentation: Airport code. Example: MIA
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * - ref: AirportCode
     * @var string
     */
    public $AirportCode;
    /**
     * The AirportName
     * Meta information extracted from the WSDL
     * - ref: AirportName
     * @var string
     */
    public $AirportName;
    /**
     * The ArrivalDate
     * Meta information extracted from the WSDL
     * - ref: ArrivalDate
     * @var string
     */
    public $ArrivalDate;
    /**
     * The ArrivalTime
     * Meta information extracted from the WSDL
     * - documentation: Stop arrival time in ISO 8601 format (hh:mm). Example: 14:50 | Time in ISO 8601 format (hh:mm). Example: 14:30 | Time in ISO 8601 twenty-four hour clock format. Example: 14:00
     * - base: xs:string
     * - length: 5
     * - pattern: ([0-1][0-9]|2[0-3]):[0-5][0-9]
     * @var string
     */
    public $ArrivalTime;
    /**
     * The DepartureDate
     * Meta information extracted from the WSDL
     * - ref: DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The DepartureTime
     * Meta information extracted from the WSDL
     * - documentation: Stop departure time in ISO 8601 format (hh:mm). Example: 14:50 | Time in ISO 8601 format (hh:mm). Example: 14:30 | Time in ISO 8601 twenty-four hour clock format. Example: 14:00
     * - base: xs:string
     * - length: 5
     * - pattern: ([0-1][0-9]|2[0-3]):[0-5][0-9]
     * @var string
     */
    public $DepartureTime;
    /**
     * The Equipment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: Equipment
     * @var \StructType\Equipment
     */
    public $Equipment;
    /**
     * The ChangeOfGauge
     * Meta information extracted from the WSDL
     * - documentation: Possible Value: YSet if the flight is a Change of Gauge flight which will also require to map the NEW equipment (for the next leg of this flight) to the "Equipment" node
     * @var string
     */
    public $ChangeOfGauge;
    /**
     * Constructor method for StopInformation
     * @uses StopInformation::setAirportCode()
     * @uses StopInformation::setAirportName()
     * @uses StopInformation::setArrivalDate()
     * @uses StopInformation::setArrivalTime()
     * @uses StopInformation::setDepartureDate()
     * @uses StopInformation::setDepartureTime()
     * @uses StopInformation::setEquipment()
     * @uses StopInformation::setChangeOfGauge()
     * @param string $airportCode
     * @param string $airportName
     * @param string $arrivalDate
     * @param string $arrivalTime
     * @param string $departureDate
     * @param string $departureTime
     * @param \StructType\Equipment $equipment
     * @param string $changeOfGauge
     */
    public function __construct($airportCode = null, $airportName = null, $arrivalDate = null, $arrivalTime = null, $departureDate = null, $departureTime = null, \StructType\Equipment $equipment = null, $changeOfGauge = null)
    {
        $this
            ->setAirportCode($airportCode)
            ->setAirportName($airportName)
            ->setArrivalDate($arrivalDate)
            ->setArrivalTime($arrivalTime)
            ->setDepartureDate($departureDate)
            ->setDepartureTime($departureTime)
            ->setEquipment($equipment)
            ->setChangeOfGauge($changeOfGauge);
    }
    /**
     * Get AirportCode value
     * @return string|null
     */
    public function getAirportCode()
    {
        return $this->AirportCode;
    }
    /**
     * Set AirportCode value
     * @param string $airportCode
     * @return \StructType\StopInformation
     */
    public function setAirportCode($airportCode = null)
    {
        // validation for constraint: string
        if (!is_null($airportCode) && !is_string($airportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airportCode, true), gettype($airportCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($airportCode) && mb_strlen($airportCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($airportCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($airportCode) && mb_strlen($airportCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($airportCode)), __LINE__);
        }
        $this->AirportCode = $airportCode;
        return $this;
    }
    /**
     * Get AirportName value
     * @return string|null
     */
    public function getAirportName()
    {
        return $this->AirportName;
    }
    /**
     * Set AirportName value
     * @param string $airportName
     * @return \StructType\StopInformation
     */
    public function setAirportName($airportName = null)
    {
        // validation for constraint: string
        if (!is_null($airportName) && !is_string($airportName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airportName, true), gettype($airportName)), __LINE__);
        }
        $this->AirportName = $airportName;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string|null
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\StopInformation
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDate, true), gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get ArrivalTime value
     * @return string|null
     */
    public function getArrivalTime()
    {
        return $this->ArrivalTime;
    }
    /**
     * Set ArrivalTime value
     * @param string $arrivalTime
     * @return \StructType\StopInformation
     */
    public function setArrivalTime($arrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalTime) && !is_string($arrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalTime, true), gettype($arrivalTime)), __LINE__);
        }
        // validation for constraint: length(5)
        if (!is_null($arrivalTime) && mb_strlen($arrivalTime) !== 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 5', mb_strlen($arrivalTime)), __LINE__);
        }
        // validation for constraint: pattern(([0-1][0-9]|2[0-3]):[0-5][0-9])
        if (!is_null($arrivalTime) && !preg_match('/([0-1][0-9]|2[0-3]):[0-5][0-9]/', $arrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-1][0-9]|2[0-3]):[0-5][0-9]', var_export($arrivalTime, true)), __LINE__);
        }
        $this->ArrivalTime = $arrivalTime;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\StopInformation
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get DepartureTime value
     * @return string|null
     */
    public function getDepartureTime()
    {
        return $this->DepartureTime;
    }
    /**
     * Set DepartureTime value
     * @param string $departureTime
     * @return \StructType\StopInformation
     */
    public function setDepartureTime($departureTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureTime) && !is_string($departureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureTime, true), gettype($departureTime)), __LINE__);
        }
        // validation for constraint: length(5)
        if (!is_null($departureTime) && mb_strlen($departureTime) !== 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 5', mb_strlen($departureTime)), __LINE__);
        }
        // validation for constraint: pattern(([0-1][0-9]|2[0-3]):[0-5][0-9])
        if (!is_null($departureTime) && !preg_match('/([0-1][0-9]|2[0-3]):[0-5][0-9]/', $departureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-1][0-9]|2[0-3]):[0-5][0-9]', var_export($departureTime, true)), __LINE__);
        }
        $this->DepartureTime = $departureTime;
        return $this;
    }
    /**
     * Get Equipment value
     * @return \StructType\Equipment|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * Set Equipment value
     * @param \StructType\Equipment $equipment
     * @return \StructType\StopInformation
     */
    public function setEquipment(\StructType\Equipment $equipment = null)
    {
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Get ChangeOfGauge value
     * @return string|null
     */
    public function getChangeOfGauge()
    {
        return $this->ChangeOfGauge;
    }
    /**
     * Set ChangeOfGauge value
     * @param string $changeOfGauge
     * @return \StructType\StopInformation
     */
    public function setChangeOfGauge($changeOfGauge = null)
    {
        // validation for constraint: string
        if (!is_null($changeOfGauge) && !is_string($changeOfGauge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeOfGauge, true), gettype($changeOfGauge)), __LINE__);
        }
        $this->ChangeOfGauge = $changeOfGauge;
        return $this;
    }
}
