<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialServiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Special service information
 * @subpackage Structs
 */
class SpecialServiceType extends AbstractStructBase
{
    /**
     * The AddlDataMeasure
     * Meta information extracted from the WSDL
     * - documentation: Provides additional supporting measurement information in case the Special Service requires it.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MeasureType
     */
    public $AddlDataMeasure;
    /**
     * The FreeText
     * Meta information extracted from the WSDL
     * - documentation: Free text | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FreeText;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - documentation: A quantity is a counted number of non-monetary units, possibly including fractions. | A quantity is a counted number of non-monetary units, possibly including fractions
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Qty;
    /**
     * The SpecialServiceCode
     * Meta information extracted from the WSDL
     * - documentation: Code that identifies the special service. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SpecialServiceCode;
    /**
     * Constructor method for SpecialServiceType
     * @uses SpecialServiceType::setAddlDataMeasure()
     * @uses SpecialServiceType::setFreeText()
     * @uses SpecialServiceType::setQty()
     * @uses SpecialServiceType::setSpecialServiceCode()
     * @param \StructType\MeasureType $addlDataMeasure
     * @param string $freeText
     * @param float $qty
     * @param string $specialServiceCode
     */
    public function __construct(\StructType\MeasureType $addlDataMeasure = null, $freeText = null, $qty = null, $specialServiceCode = null)
    {
        $this
            ->setAddlDataMeasure($addlDataMeasure)
            ->setFreeText($freeText)
            ->setQty($qty)
            ->setSpecialServiceCode($specialServiceCode);
    }
    /**
     * Get AddlDataMeasure value
     * @return \StructType\MeasureType|null
     */
    public function getAddlDataMeasure()
    {
        return $this->AddlDataMeasure;
    }
    /**
     * Set AddlDataMeasure value
     * @param \StructType\MeasureType $addlDataMeasure
     * @return \StructType\SpecialServiceType
     */
    public function setAddlDataMeasure(\StructType\MeasureType $addlDataMeasure = null)
    {
        $this->AddlDataMeasure = $addlDataMeasure;
        return $this;
    }
    /**
     * Get FreeText value
     * @return string|null
     */
    public function getFreeText()
    {
        return $this->FreeText;
    }
    /**
     * Set FreeText value
     * @param string $freeText
     * @return \StructType\SpecialServiceType
     */
    public function setFreeText($freeText = null)
    {
        // validation for constraint: string
        if (!is_null($freeText) && !is_string($freeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freeText, true), gettype($freeText)), __LINE__);
        }
        $this->FreeText = $freeText;
        return $this;
    }
    /**
     * Get Qty value
     * @return float|null
     */
    public function getQty()
    {
        return $this->Qty;
    }
    /**
     * Set Qty value
     * @param float $qty
     * @return \StructType\SpecialServiceType
     */
    public function setQty($qty = null)
    {
        // validation for constraint: float
        if (!is_null($qty) && !(is_float($qty) || is_numeric($qty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        $this->Qty = $qty;
        return $this;
    }
    /**
     * Get SpecialServiceCode value
     * @return string|null
     */
    public function getSpecialServiceCode()
    {
        return $this->SpecialServiceCode;
    }
    /**
     * Set SpecialServiceCode value
     * @param string $specialServiceCode
     * @return \StructType\SpecialServiceType
     */
    public function setSpecialServiceCode($specialServiceCode = null)
    {
        // validation for constraint: string
        if (!is_null($specialServiceCode) && !is_string($specialServiceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialServiceCode, true), gettype($specialServiceCode)), __LINE__);
        }
        $this->SpecialServiceCode = $specialServiceCode;
        return $this;
    }
}
