<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Slider StructType
 * @subpackage Structs
 */
class Slider extends AbstractStructBase
{
    /**
     * The Diagnostics
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Diagnostics
     */
    public $Diagnostics;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Position[]
     */
    public $Position;
    /**
     * Constructor method for Slider
     * @uses Slider::setDiagnostics()
     * @uses Slider::setPosition()
     * @param \StructType\Diagnostics $diagnostics
     * @param \StructType\Position[] $position
     */
    public function __construct(\StructType\Diagnostics $diagnostics = null, array $position = array())
    {
        $this
            ->setDiagnostics($diagnostics)
            ->setPosition($position);
    }
    /**
     * Get Diagnostics value
     * @return \StructType\Diagnostics|null
     */
    public function getDiagnostics()
    {
        return $this->Diagnostics;
    }
    /**
     * Set Diagnostics value
     * @param \StructType\Diagnostics $diagnostics
     * @return \StructType\Slider
     */
    public function setDiagnostics(\StructType\Diagnostics $diagnostics = null)
    {
        $this->Diagnostics = $diagnostics;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position[]|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * This method is responsible for validating the values passed to the setPosition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPosition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePositionForArrayConstraintsFromSetPosition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sliderPositionItem) {
            // validation for constraint: itemType
            if (!$sliderPositionItem instanceof \StructType\Position) {
                $invalidValues[] = is_object($sliderPositionItem) ? get_class($sliderPositionItem) : sprintf('%s(%s)', gettype($sliderPositionItem), var_export($sliderPositionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Position property can only contain items of type \StructType\Position, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position[] $position
     * @return \StructType\Slider
     */
    public function setPosition(array $position = array())
    {
        // validation for constraint: array
        if ('' !== ($positionArrayErrorMessage = self::validatePositionForArrayConstraintsFromSetPosition($position))) {
            throw new \InvalidArgumentException($positionArrayErrorMessage, __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Add item to Position value
     * @throws \InvalidArgumentException
     * @param \StructType\Position $item
     * @return \StructType\Slider
     */
    public function addToPosition(\StructType\Position $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Position) {
            throw new \InvalidArgumentException(sprintf('The Position property can only contain items of type \StructType\Position, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Position[] = $item;
        return $this;
    }
}
