<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShoppingRequestDataListsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data List definition for this message.
 * @subpackage Structs
 */
class ShoppingRequestDataListsType extends AbstractStructBase
{
    /**
     * The BaggageAllowanceList
     * Meta information extracted from the WSDL
     * - documentation: Baggage allowance data list definition
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BaggageAllowanceListType
     */
    public $BaggageAllowanceList;
    /**
     * The BaggageDisclosureList
     * Meta information extracted from the WSDL
     * - documentation: Baggage disclosure data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BaggageDisclosureListType
     */
    public $BaggageDisclosureList;
    /**
     * The ContactInfoList
     * Meta information extracted from the WSDL
     * - documentation: Contact info data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ContactInfoListType
     */
    public $ContactInfoList;
    /**
     * The DatedMarketingSegmentList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated marketing segments used in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DatedMarketingSegmentListType
     */
    public $DatedMarketingSegmentList;
    /**
     * The DatedOperatingSegmentList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated operating segments used in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DatedOperatingSegmentListType
     */
    public $DatedOperatingSegmentList;
    /**
     * The DisclosureList
     * Meta information extracted from the WSDL
     * - documentation: Disclosure data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DisclosureListType
     */
    public $DisclosureList;
    /**
     * The OriginDestList
     * Meta information extracted from the WSDL
     * - documentation: Origin Destination data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OriginDestListType
     */
    public $OriginDestList;
    /**
     * The PaxJourneyList
     * Meta information extracted from the WSDL
     * - documentation: Journey data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxJourneyListType
     */
    public $PaxJourneyList;
    /**
     * The PaxList
     * Meta information extracted from the WSDL
     * - documentation: Passenger data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxListType
     */
    public $PaxList;
    /**
     * The PenaltyList
     * Meta information extracted from the WSDL
     * - documentation: Penalty data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PenaltyListType
     */
    public $PenaltyList;
    /**
     * The PriceClassList
     * Meta information extracted from the WSDL
     * - documentation: Price Class data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceClassListType
     */
    public $PriceClassList;
    /**
     * The SeatProfileList
     * Meta information extracted from the WSDL
     * - documentation: Seat Profile data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SeatProfileListType
     */
    public $SeatProfileList;
    /**
     * The ServiceDefinitionList
     * Meta information extracted from the WSDL
     * - documentation: Service Definition data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceDefinitionListType
     */
    public $ServiceDefinitionList;
    /**
     * The ShoppingRequestPaxSegmentList
     * Meta information extracted from the WSDL
     * - documentation: A shopping request specialization of a Passenger Segment data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShoppingRequestPaxSegmentListType
     */
    public $ShoppingRequestPaxSegmentList;
    /**
     * The TermsList
     * Meta information extracted from the WSDL
     * - documentation: Offer/Order Terms list
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TermsListType
     */
    public $TermsList;
    /**
     * Constructor method for ShoppingRequestDataListsType
     * @uses ShoppingRequestDataListsType::setBaggageAllowanceList()
     * @uses ShoppingRequestDataListsType::setBaggageDisclosureList()
     * @uses ShoppingRequestDataListsType::setContactInfoList()
     * @uses ShoppingRequestDataListsType::setDatedMarketingSegmentList()
     * @uses ShoppingRequestDataListsType::setDatedOperatingSegmentList()
     * @uses ShoppingRequestDataListsType::setDisclosureList()
     * @uses ShoppingRequestDataListsType::setOriginDestList()
     * @uses ShoppingRequestDataListsType::setPaxJourneyList()
     * @uses ShoppingRequestDataListsType::setPaxList()
     * @uses ShoppingRequestDataListsType::setPenaltyList()
     * @uses ShoppingRequestDataListsType::setPriceClassList()
     * @uses ShoppingRequestDataListsType::setSeatProfileList()
     * @uses ShoppingRequestDataListsType::setServiceDefinitionList()
     * @uses ShoppingRequestDataListsType::setShoppingRequestPaxSegmentList()
     * @uses ShoppingRequestDataListsType::setTermsList()
     * @param \StructType\BaggageAllowanceListType $baggageAllowanceList
     * @param \StructType\BaggageDisclosureListType $baggageDisclosureList
     * @param \StructType\ContactInfoListType $contactInfoList
     * @param \StructType\DatedMarketingSegmentListType $datedMarketingSegmentList
     * @param \StructType\DatedOperatingSegmentListType $datedOperatingSegmentList
     * @param \StructType\DisclosureListType $disclosureList
     * @param \StructType\OriginDestListType $originDestList
     * @param \StructType\PaxJourneyListType $paxJourneyList
     * @param \StructType\PaxListType $paxList
     * @param \StructType\PenaltyListType $penaltyList
     * @param \StructType\PriceClassListType $priceClassList
     * @param \StructType\SeatProfileListType $seatProfileList
     * @param \StructType\ServiceDefinitionListType $serviceDefinitionList
     * @param \StructType\ShoppingRequestPaxSegmentListType $shoppingRequestPaxSegmentList
     * @param \StructType\TermsListType $termsList
     */
    public function __construct(\StructType\BaggageAllowanceListType $baggageAllowanceList = null, \StructType\BaggageDisclosureListType $baggageDisclosureList = null, \StructType\ContactInfoListType $contactInfoList = null, \StructType\DatedMarketingSegmentListType $datedMarketingSegmentList = null, \StructType\DatedOperatingSegmentListType $datedOperatingSegmentList = null, \StructType\DisclosureListType $disclosureList = null, \StructType\OriginDestListType $originDestList = null, \StructType\PaxJourneyListType $paxJourneyList = null, \StructType\PaxListType $paxList = null, \StructType\PenaltyListType $penaltyList = null, \StructType\PriceClassListType $priceClassList = null, \StructType\SeatProfileListType $seatProfileList = null, \StructType\ServiceDefinitionListType $serviceDefinitionList = null, \StructType\ShoppingRequestPaxSegmentListType $shoppingRequestPaxSegmentList = null, \StructType\TermsListType $termsList = null)
    {
        $this
            ->setBaggageAllowanceList($baggageAllowanceList)
            ->setBaggageDisclosureList($baggageDisclosureList)
            ->setContactInfoList($contactInfoList)
            ->setDatedMarketingSegmentList($datedMarketingSegmentList)
            ->setDatedOperatingSegmentList($datedOperatingSegmentList)
            ->setDisclosureList($disclosureList)
            ->setOriginDestList($originDestList)
            ->setPaxJourneyList($paxJourneyList)
            ->setPaxList($paxList)
            ->setPenaltyList($penaltyList)
            ->setPriceClassList($priceClassList)
            ->setSeatProfileList($seatProfileList)
            ->setServiceDefinitionList($serviceDefinitionList)
            ->setShoppingRequestPaxSegmentList($shoppingRequestPaxSegmentList)
            ->setTermsList($termsList);
    }
    /**
     * Get BaggageAllowanceList value
     * @return \StructType\BaggageAllowanceListType|null
     */
    public function getBaggageAllowanceList()
    {
        return $this->BaggageAllowanceList;
    }
    /**
     * Set BaggageAllowanceList value
     * @param \StructType\BaggageAllowanceListType $baggageAllowanceList
     * @return \StructType\ShoppingRequestDataListsType
     */
    public function setBaggageAllowanceList(\StructType\BaggageAllowanceListType $baggageAllowanceList = null)
    {
        $this->BaggageAllowanceList = $baggageAllowanceList;
        return $this;
    }
    /**
     * Get BaggageDisclosureList value
     * @return \StructType\BaggageDisclosureListType|null
     */
    public function getBaggageDisclosureList()
    {
        return $this->BaggageDisclosureList;
    }
    /**
     * Set BaggageDisclosureList value
     * @param \StructType\BaggageDisclosureListType $baggageDisclosureList
     * @return \StructType\ShoppingRequestDataListsType
     */
    public function setBaggageDisclosureList(\StructType\BaggageDisclosureListType $baggageDisclosureList = null)
    {
        $this->BaggageDisclosureList = $baggageDisclosureList;
        return $this;
    }
    /**
     * Get ContactInfoList value
     * @return \StructType\ContactInfoListType|null
     */
    public function getContactInfoList()
    {
        return $this->ContactInfoList;
    }
    /**
     * Set ContactInfoList value
     * @param \StructType\ContactInfoListType $contactInfoList
     * @return \StructType\ShoppingRequestDataListsType
     */
    public function setContactInfoList(\StructType\ContactInfoListType $contactInfoList = null)
    {
        $this->ContactInfoList = $contactInfoList;
        return $this;
    }
    /**
     * Get DatedMarketingSegmentList value
     * @return \StructType\DatedMarketingSegmentListType|null
     */
    public function getDatedMarketingSegmentList()
    {
        return $this->DatedMarketingSegmentList;
    }
    /**
     * Set DatedMarketingSegmentList value
     * @param \StructType\DatedMarketingSegmentListType $datedMarketingSegmentList
     * @return \StructType\ShoppingRequestDataListsType
     */
    public function setDatedMarketingSegmentList(\StructType\DatedMarketingSegmentListType $datedMarketingSegmentList = null)
    {
        $this->DatedMarketingSegmentList = $datedMarketingSegmentList;
        return $this;
    }
    /**
     * Get DatedOperatingSegmentList value
     * @return \StructType\DatedOperatingSegmentListType|null
     */
    public function getDatedOperatingSegmentList()
    {
        return $this->DatedOperatingSegmentList;
    }
    /**
     * Set DatedOperatingSegmentList value
     * @param \StructType\DatedOperatingSegmentListType $datedOperatingSegmentList
     * @return \StructType\ShoppingRequestDataListsType
     */
    public function setDatedOperatingSegmentList(\StructType\DatedOperatingSegmentListType $datedOperatingSegmentList = null)
    {
        $this->DatedOperatingSegmentList = $datedOperatingSegmentList;
        return $this;
    }
    /**
     * Get DisclosureList value
     * @return \StructType\DisclosureListType|null
     */
    public function getDisclosureList()
    {
        return $this->DisclosureList;
    }
    /**
     * Set DisclosureList value
     * @param \StructType\DisclosureListType $disclosureList
     * @return \StructType\ShoppingRequestDataListsType
     */
    public function setDisclosureList(\StructType\DisclosureListType $disclosureList = null)
    {
        $this->DisclosureList = $disclosureList;
        return $this;
    }
    /**
     * Get OriginDestList value
     * @return \StructType\OriginDestListType|null
     */
    public function getOriginDestList()
    {
        return $this->OriginDestList;
    }
    /**
     * Set OriginDestList value
     * @param \StructType\OriginDestListType $originDestList
     * @return \StructType\ShoppingRequestDataListsType
     */
    public function setOriginDestList(\StructType\OriginDestListType $originDestList = null)
    {
        $this->OriginDestList = $originDestList;
        return $this;
    }
    /**
     * Get PaxJourneyList value
     * @return \StructType\PaxJourneyListType|null
     */
    public function getPaxJourneyList()
    {
        return $this->PaxJourneyList;
    }
    /**
     * Set PaxJourneyList value
     * @param \StructType\PaxJourneyListType $paxJourneyList
     * @return \StructType\ShoppingRequestDataListsType
     */
    public function setPaxJourneyList(\StructType\PaxJourneyListType $paxJourneyList = null)
    {
        $this->PaxJourneyList = $paxJourneyList;
        return $this;
    }
    /**
     * Get PaxList value
     * @return \StructType\PaxListType|null
     */
    public function getPaxList()
    {
        return $this->PaxList;
    }
    /**
     * Set PaxList value
     * @param \StructType\PaxListType $paxList
     * @return \StructType\ShoppingRequestDataListsType
     */
    public function setPaxList(\StructType\PaxListType $paxList = null)
    {
        $this->PaxList = $paxList;
        return $this;
    }
    /**
     * Get PenaltyList value
     * @return \StructType\PenaltyListType|null
     */
    public function getPenaltyList()
    {
        return $this->PenaltyList;
    }
    /**
     * Set PenaltyList value
     * @param \StructType\PenaltyListType $penaltyList
     * @return \StructType\ShoppingRequestDataListsType
     */
    public function setPenaltyList(\StructType\PenaltyListType $penaltyList = null)
    {
        $this->PenaltyList = $penaltyList;
        return $this;
    }
    /**
     * Get PriceClassList value
     * @return \StructType\PriceClassListType|null
     */
    public function getPriceClassList()
    {
        return $this->PriceClassList;
    }
    /**
     * Set PriceClassList value
     * @param \StructType\PriceClassListType $priceClassList
     * @return \StructType\ShoppingRequestDataListsType
     */
    public function setPriceClassList(\StructType\PriceClassListType $priceClassList = null)
    {
        $this->PriceClassList = $priceClassList;
        return $this;
    }
    /**
     * Get SeatProfileList value
     * @return \StructType\SeatProfileListType|null
     */
    public function getSeatProfileList()
    {
        return $this->SeatProfileList;
    }
    /**
     * Set SeatProfileList value
     * @param \StructType\SeatProfileListType $seatProfileList
     * @return \StructType\ShoppingRequestDataListsType
     */
    public function setSeatProfileList(\StructType\SeatProfileListType $seatProfileList = null)
    {
        $this->SeatProfileList = $seatProfileList;
        return $this;
    }
    /**
     * Get ServiceDefinitionList value
     * @return \StructType\ServiceDefinitionListType|null
     */
    public function getServiceDefinitionList()
    {
        return $this->ServiceDefinitionList;
    }
    /**
     * Set ServiceDefinitionList value
     * @param \StructType\ServiceDefinitionListType $serviceDefinitionList
     * @return \StructType\ShoppingRequestDataListsType
     */
    public function setServiceDefinitionList(\StructType\ServiceDefinitionListType $serviceDefinitionList = null)
    {
        $this->ServiceDefinitionList = $serviceDefinitionList;
        return $this;
    }
    /**
     * Get ShoppingRequestPaxSegmentList value
     * @return \StructType\ShoppingRequestPaxSegmentListType|null
     */
    public function getShoppingRequestPaxSegmentList()
    {
        return $this->ShoppingRequestPaxSegmentList;
    }
    /**
     * Set ShoppingRequestPaxSegmentList value
     * @param \StructType\ShoppingRequestPaxSegmentListType $shoppingRequestPaxSegmentList
     * @return \StructType\ShoppingRequestDataListsType
     */
    public function setShoppingRequestPaxSegmentList(\StructType\ShoppingRequestPaxSegmentListType $shoppingRequestPaxSegmentList = null)
    {
        $this->ShoppingRequestPaxSegmentList = $shoppingRequestPaxSegmentList;
        return $this;
    }
    /**
     * Get TermsList value
     * @return \StructType\TermsListType|null
     */
    public function getTermsList()
    {
        return $this->TermsList;
    }
    /**
     * Set TermsList value
     * @param \StructType\TermsListType $termsList
     * @return \StructType\ShoppingRequestDataListsType
     */
    public function setTermsList(\StructType\TermsListType $termsList = null)
    {
        $this->TermsList = $termsList;
        return $this;
    }
}
