<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SettlementInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to the value of a product or service as it pertains to interline transactions.
 * @subpackage Structs
 */
class SettlementInfoType extends AbstractStructBase
{
    /**
     * The MethodCode
     * Meta information extracted from the WSDL
     * - documentation: Settlement method. Examples: - AD (Internal Airline Document). - DS (Direct Settlement). - EA (EMD Associated or Internal Airline Document). | Settlement Method enumeration Code {codeListAgencyName}IATA{/codeListAgencyName}
     * {codeListIdentifier}PADIS SST{/codeListIdentifier} | Settlement method information code.
     * - base: ServiceSettlementMethodCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MethodCode;
    /**
     * The SettlementAmount
     * Meta information extracted from the WSDL
     * - documentation: Settlement (Price) Value. Example: 300 (USD) Note: This represents a Settlement value that is only used between the POA and ORA.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $SettlementAmount;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommissionType[]
     */
    public $Commission;
    /**
     * The Fee
     * Meta information extracted from the WSDL
     * - documentation: Amount added on to a charge for a specific product, purpose, or service.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FeeType[]
     */
    public $Fee;
    /**
     * The Surcharge
     * Meta information extracted from the WSDL
     * - documentation: Amount added on to a usual charge for a specific product, purpose, or service.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SurchargeType[]
     */
    public $Surcharge;
    /**
     * The Tax
     * Meta information extracted from the WSDL
     * - documentation: A compulsory contribution to state revenue, levied by the government on workers' income and business profits or added to the cost of some goods, services, and transactions.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TaxType[]
     */
    public $Tax;
    /**
     * The TaxableInd
     * Meta information extracted from the WSDL
     * - documentation: In some markets, commission is VAT-able (i.e. Taxable) | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $TaxableInd;
    /**
     * Constructor method for SettlementInfoType
     * @uses SettlementInfoType::setMethodCode()
     * @uses SettlementInfoType::setSettlementAmount()
     * @uses SettlementInfoType::setCommission()
     * @uses SettlementInfoType::setFee()
     * @uses SettlementInfoType::setSurcharge()
     * @uses SettlementInfoType::setTax()
     * @uses SettlementInfoType::setTaxableInd()
     * @param string $methodCode
     * @param \StructType\AmountType $settlementAmount
     * @param \StructType\CommissionType[] $commission
     * @param \StructType\FeeType[] $fee
     * @param \StructType\SurchargeType[] $surcharge
     * @param \StructType\TaxType[] $tax
     * @param bool $taxableInd
     */
    public function __construct($methodCode = null, \StructType\AmountType $settlementAmount = null, array $commission = array(), array $fee = array(), array $surcharge = array(), array $tax = array(), $taxableInd = null)
    {
        $this
            ->setMethodCode($methodCode)
            ->setSettlementAmount($settlementAmount)
            ->setCommission($commission)
            ->setFee($fee)
            ->setSurcharge($surcharge)
            ->setTax($tax)
            ->setTaxableInd($taxableInd);
    }
    /**
     * Get MethodCode value
     * @return string
     */
    public function getMethodCode()
    {
        return $this->MethodCode;
    }
    /**
     * Set MethodCode value
     * @param string $methodCode
     * @return \StructType\SettlementInfoType
     */
    public function setMethodCode($methodCode = null)
    {
        // validation for constraint: string
        if (!is_null($methodCode) && !is_string($methodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($methodCode, true), gettype($methodCode)), __LINE__);
        }
        $this->MethodCode = $methodCode;
        return $this;
    }
    /**
     * Get SettlementAmount value
     * @return \StructType\AmountType
     */
    public function getSettlementAmount()
    {
        return $this->SettlementAmount;
    }
    /**
     * Set SettlementAmount value
     * @param \StructType\AmountType $settlementAmount
     * @return \StructType\SettlementInfoType
     */
    public function setSettlementAmount(\StructType\AmountType $settlementAmount = null)
    {
        $this->SettlementAmount = $settlementAmount;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\CommissionType[]|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * This method is responsible for validating the values passed to the setCommission method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommission method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionForArrayConstraintsFromSetCommission(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $settlementInfoTypeCommissionItem) {
            // validation for constraint: itemType
            if (!$settlementInfoTypeCommissionItem instanceof \StructType\CommissionType) {
                $invalidValues[] = is_object($settlementInfoTypeCommissionItem) ? get_class($settlementInfoTypeCommissionItem) : sprintf('%s(%s)', gettype($settlementInfoTypeCommissionItem), var_export($settlementInfoTypeCommissionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType[] $commission
     * @return \StructType\SettlementInfoType
     */
    public function setCommission(array $commission = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionArrayErrorMessage = self::validateCommissionForArrayConstraintsFromSetCommission($commission))) {
            throw new \InvalidArgumentException($commissionArrayErrorMessage, __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Add item to Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType $item
     * @return \StructType\SettlementInfoType
     */
    public function addToCommission(\StructType\CommissionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommissionType) {
            throw new \InvalidArgumentException(sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commission[] = $item;
        return $this;
    }
    /**
     * Get Fee value
     * @return \StructType\FeeType[]|null
     */
    public function getFee()
    {
        return $this->Fee;
    }
    /**
     * This method is responsible for validating the values passed to the setFee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeeForArrayConstraintsFromSetFee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $settlementInfoTypeFeeItem) {
            // validation for constraint: itemType
            if (!$settlementInfoTypeFeeItem instanceof \StructType\FeeType) {
                $invalidValues[] = is_object($settlementInfoTypeFeeItem) ? get_class($settlementInfoTypeFeeItem) : sprintf('%s(%s)', gettype($settlementInfoTypeFeeItem), var_export($settlementInfoTypeFeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Fee property can only contain items of type \StructType\FeeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Fee value
     * @throws \InvalidArgumentException
     * @param \StructType\FeeType[] $fee
     * @return \StructType\SettlementInfoType
     */
    public function setFee(array $fee = array())
    {
        // validation for constraint: array
        if ('' !== ($feeArrayErrorMessage = self::validateFeeForArrayConstraintsFromSetFee($fee))) {
            throw new \InvalidArgumentException($feeArrayErrorMessage, __LINE__);
        }
        $this->Fee = $fee;
        return $this;
    }
    /**
     * Add item to Fee value
     * @throws \InvalidArgumentException
     * @param \StructType\FeeType $item
     * @return \StructType\SettlementInfoType
     */
    public function addToFee(\StructType\FeeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FeeType) {
            throw new \InvalidArgumentException(sprintf('The Fee property can only contain items of type \StructType\FeeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Fee[] = $item;
        return $this;
    }
    /**
     * Get Surcharge value
     * @return \StructType\SurchargeType[]|null
     */
    public function getSurcharge()
    {
        return $this->Surcharge;
    }
    /**
     * This method is responsible for validating the values passed to the setSurcharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSurcharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSurchargeForArrayConstraintsFromSetSurcharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $settlementInfoTypeSurchargeItem) {
            // validation for constraint: itemType
            if (!$settlementInfoTypeSurchargeItem instanceof \StructType\SurchargeType) {
                $invalidValues[] = is_object($settlementInfoTypeSurchargeItem) ? get_class($settlementInfoTypeSurchargeItem) : sprintf('%s(%s)', gettype($settlementInfoTypeSurchargeItem), var_export($settlementInfoTypeSurchargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Surcharge property can only contain items of type \StructType\SurchargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Surcharge value
     * @throws \InvalidArgumentException
     * @param \StructType\SurchargeType[] $surcharge
     * @return \StructType\SettlementInfoType
     */
    public function setSurcharge(array $surcharge = array())
    {
        // validation for constraint: array
        if ('' !== ($surchargeArrayErrorMessage = self::validateSurchargeForArrayConstraintsFromSetSurcharge($surcharge))) {
            throw new \InvalidArgumentException($surchargeArrayErrorMessage, __LINE__);
        }
        $this->Surcharge = $surcharge;
        return $this;
    }
    /**
     * Add item to Surcharge value
     * @throws \InvalidArgumentException
     * @param \StructType\SurchargeType $item
     * @return \StructType\SettlementInfoType
     */
    public function addToSurcharge(\StructType\SurchargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SurchargeType) {
            throw new \InvalidArgumentException(sprintf('The Surcharge property can only contain items of type \StructType\SurchargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Surcharge[] = $item;
        return $this;
    }
    /**
     * Get Tax value
     * @return \StructType\TaxType[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * This method is responsible for validating the values passed to the setTax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxForArrayConstraintsFromSetTax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $settlementInfoTypeTaxItem) {
            // validation for constraint: itemType
            if (!$settlementInfoTypeTaxItem instanceof \StructType\TaxType) {
                $invalidValues[] = is_object($settlementInfoTypeTaxItem) ? get_class($settlementInfoTypeTaxItem) : sprintf('%s(%s)', gettype($settlementInfoTypeTaxItem), var_export($settlementInfoTypeTaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax property can only contain items of type \StructType\TaxType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxType[] $tax
     * @return \StructType\SettlementInfoType
     */
    public function setTax(array $tax = array())
    {
        // validation for constraint: array
        if ('' !== ($taxArrayErrorMessage = self::validateTaxForArrayConstraintsFromSetTax($tax))) {
            throw new \InvalidArgumentException($taxArrayErrorMessage, __LINE__);
        }
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \StructType\TaxType $item
     * @return \StructType\SettlementInfoType
     */
    public function addToTax(\StructType\TaxType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TaxType) {
            throw new \InvalidArgumentException(sprintf('The Tax property can only contain items of type \StructType\TaxType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get TaxableInd value
     * @return bool|null
     */
    public function getTaxableInd()
    {
        return $this->TaxableInd;
    }
    /**
     * Set TaxableInd value
     * @param bool $taxableInd
     * @return \StructType\SettlementInfoType
     */
    public function setTaxableInd($taxableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxableInd) && !is_bool($taxableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxableInd, true), gettype($taxableInd)), __LINE__);
        }
        $this->TaxableInd = $taxableInd;
        return $this;
    }
}
