<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SettlementDataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Amounts that define the funds to be cleared as a result of the payment commitment and the selected payment method, and the date when the funds must be remitted.
 * @subpackage Structs
 */
class SettlementDataType extends AbstractStructBase
{
    /**
     * The NetClearanceAmount
     * Meta information extracted from the WSDL
     * - documentation: The amount agreed to be cleared in the Agreement between the two parties to the Agreement. It is obtained from the Commitment in the Agreement. The value of the Net Clearance Amount in the Payment Commitment of the Agreement can be
     * either positive [+] or negative [-]. If it is positive [+] then the party initiating the clearance request will be the Payee in the clearance, i.e. the initiator of the clearance is to receive funds. If it is negative [-] then the party initiating
     * the clearance request will be the Payer in the clearance, i.e. the initiator of the clearance has to pay-out funds. It is the absolute value of the Net Clearance Amount that is used in the Clearance.
     * @var \StructType\AmountType
     */
    public $NetClearanceAmount;
    /**
     * The ORA_NetPayable
     * Meta information extracted from the WSDL
     * - documentation: Amount owed by ORA that has not yet been paid.
     * @var \StructType\AmountType
     */
    public $ORA_NetPayable;
    /**
     * The ORA_NetReceivable
     * Meta information extracted from the WSDL
     * - documentation: Amount owed to ORA at a particular time and not yet paid
     * @var \StructType\AmountType
     */
    public $ORA_NetReceivable;
    /**
     * The RemittanceDate
     * Meta information extracted from the WSDL
     * - documentation: This is the date when the Payer will have to transfer the amount in the clearance request into the settlement manager's bank account. | A date is a Gregorian calendar representation in various common resolutions: year, month, week,
     * day.
     * - base: xs:date
     * - minOccurs: 0
     * @var string
     */
    public $RemittanceDate;
    /**
     * Constructor method for SettlementDataType
     * @uses SettlementDataType::setNetClearanceAmount()
     * @uses SettlementDataType::setORA_NetPayable()
     * @uses SettlementDataType::setORA_NetReceivable()
     * @uses SettlementDataType::setRemittanceDate()
     * @param \StructType\AmountType $netClearanceAmount
     * @param \StructType\AmountType $oRA_NetPayable
     * @param \StructType\AmountType $oRA_NetReceivable
     * @param string $remittanceDate
     */
    public function __construct(\StructType\AmountType $netClearanceAmount = null, \StructType\AmountType $oRA_NetPayable = null, \StructType\AmountType $oRA_NetReceivable = null, $remittanceDate = null)
    {
        $this
            ->setNetClearanceAmount($netClearanceAmount)
            ->setORA_NetPayable($oRA_NetPayable)
            ->setORA_NetReceivable($oRA_NetReceivable)
            ->setRemittanceDate($remittanceDate);
    }
    /**
     * Get NetClearanceAmount value
     * @return \StructType\AmountType|null
     */
    public function getNetClearanceAmount()
    {
        return $this->NetClearanceAmount;
    }
    /**
     * Set NetClearanceAmount value
     * @param \StructType\AmountType $netClearanceAmount
     * @return \StructType\SettlementDataType
     */
    public function setNetClearanceAmount(\StructType\AmountType $netClearanceAmount = null)
    {
        $this->NetClearanceAmount = $netClearanceAmount;
        return $this;
    }
    /**
     * Get ORA_NetPayable value
     * @return \StructType\AmountType|null
     */
    public function getORA_NetPayable()
    {
        return $this->ORA_NetPayable;
    }
    /**
     * Set ORA_NetPayable value
     * @param \StructType\AmountType $oRA_NetPayable
     * @return \StructType\SettlementDataType
     */
    public function setORA_NetPayable(\StructType\AmountType $oRA_NetPayable = null)
    {
        $this->ORA_NetPayable = $oRA_NetPayable;
        return $this;
    }
    /**
     * Get ORA_NetReceivable value
     * @return \StructType\AmountType|null
     */
    public function getORA_NetReceivable()
    {
        return $this->ORA_NetReceivable;
    }
    /**
     * Set ORA_NetReceivable value
     * @param \StructType\AmountType $oRA_NetReceivable
     * @return \StructType\SettlementDataType
     */
    public function setORA_NetReceivable(\StructType\AmountType $oRA_NetReceivable = null)
    {
        $this->ORA_NetReceivable = $oRA_NetReceivable;
        return $this;
    }
    /**
     * Get RemittanceDate value
     * @return string|null
     */
    public function getRemittanceDate()
    {
        return $this->RemittanceDate;
    }
    /**
     * Set RemittanceDate value
     * @param string $remittanceDate
     * @return \StructType\SettlementDataType
     */
    public function setRemittanceDate($remittanceDate = null)
    {
        // validation for constraint: string
        if (!is_null($remittanceDate) && !is_string($remittanceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remittanceDate, true), gettype($remittanceDate)), __LINE__);
        }
        $this->RemittanceDate = $remittanceDate;
        return $this;
    }
}
