<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceStatusChangeNotifRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request content for message
 * @subpackage Structs
 */
class ServiceStatusChangeNotifRequestType extends AbstractStructBase
{
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: Delivered Order is a uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and
     * services that are not necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each
     * passenger in an Order may hold different sets of order items at different prices.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\DeliveredOrderType[]
     */
    public $Order;
    /**
     * The PaymentProcessingSummary
     * Meta information extracted from the WSDL
     * - documentation: Payment Processing Delivery Response Summary Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentProcessingDeliveryRequestSummaryType[]
     */
    public $PaymentProcessingSummary;
    /**
     * Constructor method for ServiceStatusChangeNotifRequestType
     * @uses ServiceStatusChangeNotifRequestType::setOrder()
     * @uses ServiceStatusChangeNotifRequestType::setPaymentProcessingSummary()
     * @param \StructType\DeliveredOrderType[] $order
     * @param \StructType\PaymentProcessingDeliveryRequestSummaryType[] $paymentProcessingSummary
     */
    public function __construct(array $order = array(), array $paymentProcessingSummary = array())
    {
        $this
            ->setOrder($order)
            ->setPaymentProcessingSummary($paymentProcessingSummary);
    }
    /**
     * Get Order value
     * @return \StructType\DeliveredOrderType[]
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * This method is responsible for validating the values passed to the setOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderForArrayConstraintsFromSetOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceStatusChangeNotifRequestTypeOrderItem) {
            // validation for constraint: itemType
            if (!$serviceStatusChangeNotifRequestTypeOrderItem instanceof \StructType\DeliveredOrderType) {
                $invalidValues[] = is_object($serviceStatusChangeNotifRequestTypeOrderItem) ? get_class($serviceStatusChangeNotifRequestTypeOrderItem) : sprintf('%s(%s)', gettype($serviceStatusChangeNotifRequestTypeOrderItem), var_export($serviceStatusChangeNotifRequestTypeOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Order property can only contain items of type \StructType\DeliveredOrderType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Order value
     * @throws \InvalidArgumentException
     * @param \StructType\DeliveredOrderType[] $order
     * @return \StructType\ServiceStatusChangeNotifRequestType
     */
    public function setOrder(array $order = array())
    {
        // validation for constraint: array
        if ('' !== ($orderArrayErrorMessage = self::validateOrderForArrayConstraintsFromSetOrder($order))) {
            throw new \InvalidArgumentException($orderArrayErrorMessage, __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Add item to Order value
     * @throws \InvalidArgumentException
     * @param \StructType\DeliveredOrderType $item
     * @return \StructType\ServiceStatusChangeNotifRequestType
     */
    public function addToOrder(\StructType\DeliveredOrderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeliveredOrderType) {
            throw new \InvalidArgumentException(sprintf('The Order property can only contain items of type \StructType\DeliveredOrderType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Order[] = $item;
        return $this;
    }
    /**
     * Get PaymentProcessingSummary value
     * @return \StructType\PaymentProcessingDeliveryRequestSummaryType[]|null
     */
    public function getPaymentProcessingSummary()
    {
        return $this->PaymentProcessingSummary;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentProcessingSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentProcessingSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentProcessingSummaryForArrayConstraintsFromSetPaymentProcessingSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceStatusChangeNotifRequestTypePaymentProcessingSummaryItem) {
            // validation for constraint: itemType
            if (!$serviceStatusChangeNotifRequestTypePaymentProcessingSummaryItem instanceof \StructType\PaymentProcessingDeliveryRequestSummaryType) {
                $invalidValues[] = is_object($serviceStatusChangeNotifRequestTypePaymentProcessingSummaryItem) ? get_class($serviceStatusChangeNotifRequestTypePaymentProcessingSummaryItem) : sprintf('%s(%s)', gettype($serviceStatusChangeNotifRequestTypePaymentProcessingSummaryItem), var_export($serviceStatusChangeNotifRequestTypePaymentProcessingSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentProcessingSummary property can only contain items of type \StructType\PaymentProcessingDeliveryRequestSummaryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentProcessingSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentProcessingDeliveryRequestSummaryType[] $paymentProcessingSummary
     * @return \StructType\ServiceStatusChangeNotifRequestType
     */
    public function setPaymentProcessingSummary(array $paymentProcessingSummary = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentProcessingSummaryArrayErrorMessage = self::validatePaymentProcessingSummaryForArrayConstraintsFromSetPaymentProcessingSummary($paymentProcessingSummary))) {
            throw new \InvalidArgumentException($paymentProcessingSummaryArrayErrorMessage, __LINE__);
        }
        $this->PaymentProcessingSummary = $paymentProcessingSummary;
        return $this;
    }
    /**
     * Add item to PaymentProcessingSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentProcessingDeliveryRequestSummaryType $item
     * @return \StructType\ServiceStatusChangeNotifRequestType
     */
    public function addToPaymentProcessingSummary(\StructType\PaymentProcessingDeliveryRequestSummaryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentProcessingDeliveryRequestSummaryType) {
            throw new \InvalidArgumentException(sprintf('The PaymentProcessingSummary property can only contain items of type \StructType\PaymentProcessingDeliveryRequestSummaryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentProcessingSummary[] = $item;
        return $this;
    }
}
