<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceOrderType StructType
 * Meta information extracted from the WSDL
 * - documentation: Functions to allow a Seller to request additions, replacement or deletions of OrderItems in this specific Order.
 * @subpackage Structs
 */
class ServiceOrderType extends AbstractStructBase
{
    /**
     * The AddOfferItems
     * Meta information extracted from the WSDL
     * - documentation: An action to request new Added Offer Items for the specified Order. If used in conjunction with a 'Delete' function, the intention is to replace the deleted item with whatever has been requested in this Add function's shopping query.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddOfferItemsType
     */
    public $AddOfferItems;
    /**
     * The DeleteOrderItem
     * Meta information extracted from the WSDL
     * - documentation: Contains affected existing order items and related services to retain that will be impacted by any new offers in the message. The primary use case is when an existing order item is to be deleted or partial deletion either with a
     * replacement in a new offer or a an offer to be used for the deletion.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AffectedOrderItemRequestType[]
     */
    public $DeleteOrderItem;
    /**
     * Constructor method for ServiceOrderType
     * @uses ServiceOrderType::setAddOfferItems()
     * @uses ServiceOrderType::setDeleteOrderItem()
     * @param \StructType\AddOfferItemsType $addOfferItems
     * @param \StructType\AffectedOrderItemRequestType[] $deleteOrderItem
     */
    public function __construct(\StructType\AddOfferItemsType $addOfferItems = null, array $deleteOrderItem = array())
    {
        $this
            ->setAddOfferItems($addOfferItems)
            ->setDeleteOrderItem($deleteOrderItem);
    }
    /**
     * Get AddOfferItems value
     * @return \StructType\AddOfferItemsType|null
     */
    public function getAddOfferItems()
    {
        return $this->AddOfferItems;
    }
    /**
     * Set AddOfferItems value
     * @param \StructType\AddOfferItemsType $addOfferItems
     * @return \StructType\ServiceOrderType
     */
    public function setAddOfferItems(\StructType\AddOfferItemsType $addOfferItems = null)
    {
        $this->AddOfferItems = $addOfferItems;
        return $this;
    }
    /**
     * Get DeleteOrderItem value
     * @return \StructType\AffectedOrderItemRequestType[]|null
     */
    public function getDeleteOrderItem()
    {
        return $this->DeleteOrderItem;
    }
    /**
     * This method is responsible for validating the values passed to the setDeleteOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeleteOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeleteOrderItemForArrayConstraintsFromSetDeleteOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceOrderTypeDeleteOrderItemItem) {
            // validation for constraint: itemType
            if (!$serviceOrderTypeDeleteOrderItemItem instanceof \StructType\AffectedOrderItemRequestType) {
                $invalidValues[] = is_object($serviceOrderTypeDeleteOrderItemItem) ? get_class($serviceOrderTypeDeleteOrderItemItem) : sprintf('%s(%s)', gettype($serviceOrderTypeDeleteOrderItemItem), var_export($serviceOrderTypeDeleteOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeleteOrderItem property can only contain items of type \StructType\AffectedOrderItemRequestType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeleteOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedOrderItemRequestType[] $deleteOrderItem
     * @return \StructType\ServiceOrderType
     */
    public function setDeleteOrderItem(array $deleteOrderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($deleteOrderItemArrayErrorMessage = self::validateDeleteOrderItemForArrayConstraintsFromSetDeleteOrderItem($deleteOrderItem))) {
            throw new \InvalidArgumentException($deleteOrderItemArrayErrorMessage, __LINE__);
        }
        $this->DeleteOrderItem = $deleteOrderItem;
        return $this;
    }
    /**
     * Add item to DeleteOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedOrderItemRequestType $item
     * @return \StructType\ServiceOrderType
     */
    public function addToDeleteOrderItem(\StructType\AffectedOrderItemRequestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedOrderItemRequestType) {
            throw new \InvalidArgumentException(sprintf('The DeleteOrderItem property can only contain items of type \StructType\AffectedOrderItemRequestType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeleteOrderItem[] = $item;
        return $this;
    }
}
