<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceListRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request content for Service List Request message
 * @subpackage Structs
 */
class ServiceListRequestType extends AbstractStructBase
{
    /**
     * The ServiceListCoreRequest
     * Meta information extracted from the WSDL
     * - documentation: Service List Core Request
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ServiceListCoreRequestType
     */
    public $ServiceListCoreRequest;
    /**
     * The ContactInfoList
     * Meta information extracted from the WSDL
     * - documentation: Contact info data list definition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactInfoListType[]
     */
    public $ContactInfoList;
    /**
     * The DatedMarketingSegmentList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated marketing segments used in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DatedMarketingSegmentListType
     */
    public $DatedMarketingSegmentList;
    /**
     * The DatedOperatingLegList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated operating legs used in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DatedOperatingLegListType
     */
    public $DatedOperatingLegList;
    /**
     * The DatedOperatingSegmentList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated operating segments used in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DatedOperatingSegmentListType
     */
    public $DatedOperatingSegmentList;
    /**
     * The FareWaiver
     * Meta information extracted from the WSDL
     * - documentation: Validating carrier-assigned fare rule modification or override information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareWaiverType[]
     */
    public $FareWaiver;
    /**
     * The Metadata
     * Meta information extracted from the WSDL
     * - documentation: Message wide metadata information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MetadataType
     */
    public $Metadata;
    /**
     * The OfferCriteria
     * Meta information extracted from the WSDL
     * - documentation: Further qualifies the flight request by influencing which results are returned in the shopping response, including preferred or required criteria.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OfferCriteriaType
     */
    public $OfferCriteria;
    /**
     * The Pax
     * Meta information extracted from the WSDL
     * - documentation: Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to
     * fulfillment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaxType[]
     */
    public $Pax;
    /**
     * The PaxSegmentList
     * Meta information extracted from the WSDL
     * - documentation: Segment data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxSegmentListType
     */
    public $PaxSegmentList;
    /**
     * The PaymentFunctions
     * Meta information extracted from the WSDL
     * - documentation: Is the container of all payment relevant functions.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentFunctionsCriteriaType[]
     */
    public $PaymentFunctions;
    /**
     * The Policy
     * Meta information extracted from the WSDL
     * - documentation: Message policy information, including PCI, PII information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PolicyType[]
     */
    public $Policy;
    /**
     * The ResponseParameters
     * Meta information extracted from the WSDL
     * - documentation: A set of Information related to how response results should be returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseParametersRequestType
     */
    public $ResponseParameters;
    /**
     * Constructor method for ServiceListRequestType
     * @uses ServiceListRequestType::setServiceListCoreRequest()
     * @uses ServiceListRequestType::setContactInfoList()
     * @uses ServiceListRequestType::setDatedMarketingSegmentList()
     * @uses ServiceListRequestType::setDatedOperatingLegList()
     * @uses ServiceListRequestType::setDatedOperatingSegmentList()
     * @uses ServiceListRequestType::setFareWaiver()
     * @uses ServiceListRequestType::setMetadata()
     * @uses ServiceListRequestType::setOfferCriteria()
     * @uses ServiceListRequestType::setPax()
     * @uses ServiceListRequestType::setPaxSegmentList()
     * @uses ServiceListRequestType::setPaymentFunctions()
     * @uses ServiceListRequestType::setPolicy()
     * @uses ServiceListRequestType::setResponseParameters()
     * @param \StructType\ServiceListCoreRequestType $serviceListCoreRequest
     * @param \StructType\ContactInfoListType[] $contactInfoList
     * @param \StructType\DatedMarketingSegmentListType $datedMarketingSegmentList
     * @param \StructType\DatedOperatingLegListType $datedOperatingLegList
     * @param \StructType\DatedOperatingSegmentListType $datedOperatingSegmentList
     * @param \StructType\FareWaiverType[] $fareWaiver
     * @param \StructType\MetadataType $metadata
     * @param \StructType\OfferCriteriaType $offerCriteria
     * @param \StructType\PaxType[] $pax
     * @param \StructType\PaxSegmentListType $paxSegmentList
     * @param \StructType\PaymentFunctionsCriteriaType[] $paymentFunctions
     * @param \StructType\PolicyType[] $policy
     * @param \StructType\ResponseParametersRequestType $responseParameters
     */
    public function __construct(\StructType\ServiceListCoreRequestType $serviceListCoreRequest = null, array $contactInfoList = array(), \StructType\DatedMarketingSegmentListType $datedMarketingSegmentList = null, \StructType\DatedOperatingLegListType $datedOperatingLegList = null, \StructType\DatedOperatingSegmentListType $datedOperatingSegmentList = null, array $fareWaiver = array(), \StructType\MetadataType $metadata = null, \StructType\OfferCriteriaType $offerCriteria = null, array $pax = array(), \StructType\PaxSegmentListType $paxSegmentList = null, array $paymentFunctions = array(), array $policy = array(), \StructType\ResponseParametersRequestType $responseParameters = null)
    {
        $this
            ->setServiceListCoreRequest($serviceListCoreRequest)
            ->setContactInfoList($contactInfoList)
            ->setDatedMarketingSegmentList($datedMarketingSegmentList)
            ->setDatedOperatingLegList($datedOperatingLegList)
            ->setDatedOperatingSegmentList($datedOperatingSegmentList)
            ->setFareWaiver($fareWaiver)
            ->setMetadata($metadata)
            ->setOfferCriteria($offerCriteria)
            ->setPax($pax)
            ->setPaxSegmentList($paxSegmentList)
            ->setPaymentFunctions($paymentFunctions)
            ->setPolicy($policy)
            ->setResponseParameters($responseParameters);
    }
    /**
     * Get ServiceListCoreRequest value
     * @return \StructType\ServiceListCoreRequestType
     */
    public function getServiceListCoreRequest()
    {
        return $this->ServiceListCoreRequest;
    }
    /**
     * Set ServiceListCoreRequest value
     * @param \StructType\ServiceListCoreRequestType $serviceListCoreRequest
     * @return \StructType\ServiceListRequestType
     */
    public function setServiceListCoreRequest(\StructType\ServiceListCoreRequestType $serviceListCoreRequest = null)
    {
        $this->ServiceListCoreRequest = $serviceListCoreRequest;
        return $this;
    }
    /**
     * Get ContactInfoList value
     * @return \StructType\ContactInfoListType[]|null
     */
    public function getContactInfoList()
    {
        return $this->ContactInfoList;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInfoList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInfoList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInfoListForArrayConstraintsFromSetContactInfoList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceListRequestTypeContactInfoListItem) {
            // validation for constraint: itemType
            if (!$serviceListRequestTypeContactInfoListItem instanceof \StructType\ContactInfoListType) {
                $invalidValues[] = is_object($serviceListRequestTypeContactInfoListItem) ? get_class($serviceListRequestTypeContactInfoListItem) : sprintf('%s(%s)', gettype($serviceListRequestTypeContactInfoListItem), var_export($serviceListRequestTypeContactInfoListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInfoList property can only contain items of type \StructType\ContactInfoListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInfoList value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoListType[] $contactInfoList
     * @return \StructType\ServiceListRequestType
     */
    public function setContactInfoList(array $contactInfoList = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInfoListArrayErrorMessage = self::validateContactInfoListForArrayConstraintsFromSetContactInfoList($contactInfoList))) {
            throw new \InvalidArgumentException($contactInfoListArrayErrorMessage, __LINE__);
        }
        $this->ContactInfoList = $contactInfoList;
        return $this;
    }
    /**
     * Add item to ContactInfoList value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoListType $item
     * @return \StructType\ServiceListRequestType
     */
    public function addToContactInfoList(\StructType\ContactInfoListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactInfoListType) {
            throw new \InvalidArgumentException(sprintf('The ContactInfoList property can only contain items of type \StructType\ContactInfoListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactInfoList[] = $item;
        return $this;
    }
    /**
     * Get DatedMarketingSegmentList value
     * @return \StructType\DatedMarketingSegmentListType|null
     */
    public function getDatedMarketingSegmentList()
    {
        return $this->DatedMarketingSegmentList;
    }
    /**
     * Set DatedMarketingSegmentList value
     * @param \StructType\DatedMarketingSegmentListType $datedMarketingSegmentList
     * @return \StructType\ServiceListRequestType
     */
    public function setDatedMarketingSegmentList(\StructType\DatedMarketingSegmentListType $datedMarketingSegmentList = null)
    {
        $this->DatedMarketingSegmentList = $datedMarketingSegmentList;
        return $this;
    }
    /**
     * Get DatedOperatingLegList value
     * @return \StructType\DatedOperatingLegListType|null
     */
    public function getDatedOperatingLegList()
    {
        return $this->DatedOperatingLegList;
    }
    /**
     * Set DatedOperatingLegList value
     * @param \StructType\DatedOperatingLegListType $datedOperatingLegList
     * @return \StructType\ServiceListRequestType
     */
    public function setDatedOperatingLegList(\StructType\DatedOperatingLegListType $datedOperatingLegList = null)
    {
        $this->DatedOperatingLegList = $datedOperatingLegList;
        return $this;
    }
    /**
     * Get DatedOperatingSegmentList value
     * @return \StructType\DatedOperatingSegmentListType|null
     */
    public function getDatedOperatingSegmentList()
    {
        return $this->DatedOperatingSegmentList;
    }
    /**
     * Set DatedOperatingSegmentList value
     * @param \StructType\DatedOperatingSegmentListType $datedOperatingSegmentList
     * @return \StructType\ServiceListRequestType
     */
    public function setDatedOperatingSegmentList(\StructType\DatedOperatingSegmentListType $datedOperatingSegmentList = null)
    {
        $this->DatedOperatingSegmentList = $datedOperatingSegmentList;
        return $this;
    }
    /**
     * Get FareWaiver value
     * @return \StructType\FareWaiverType[]|null
     */
    public function getFareWaiver()
    {
        return $this->FareWaiver;
    }
    /**
     * This method is responsible for validating the values passed to the setFareWaiver method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareWaiver method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareWaiverForArrayConstraintsFromSetFareWaiver(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceListRequestTypeFareWaiverItem) {
            // validation for constraint: itemType
            if (!$serviceListRequestTypeFareWaiverItem instanceof \StructType\FareWaiverType) {
                $invalidValues[] = is_object($serviceListRequestTypeFareWaiverItem) ? get_class($serviceListRequestTypeFareWaiverItem) : sprintf('%s(%s)', gettype($serviceListRequestTypeFareWaiverItem), var_export($serviceListRequestTypeFareWaiverItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareWaiver property can only contain items of type \StructType\FareWaiverType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareWaiver value
     * @throws \InvalidArgumentException
     * @param \StructType\FareWaiverType[] $fareWaiver
     * @return \StructType\ServiceListRequestType
     */
    public function setFareWaiver(array $fareWaiver = array())
    {
        // validation for constraint: array
        if ('' !== ($fareWaiverArrayErrorMessage = self::validateFareWaiverForArrayConstraintsFromSetFareWaiver($fareWaiver))) {
            throw new \InvalidArgumentException($fareWaiverArrayErrorMessage, __LINE__);
        }
        $this->FareWaiver = $fareWaiver;
        return $this;
    }
    /**
     * Add item to FareWaiver value
     * @throws \InvalidArgumentException
     * @param \StructType\FareWaiverType $item
     * @return \StructType\ServiceListRequestType
     */
    public function addToFareWaiver(\StructType\FareWaiverType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareWaiverType) {
            throw new \InvalidArgumentException(sprintf('The FareWaiver property can only contain items of type \StructType\FareWaiverType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareWaiver[] = $item;
        return $this;
    }
    /**
     * Get Metadata value
     * @return \StructType\MetadataType|null
     */
    public function getMetadata()
    {
        return $this->Metadata;
    }
    /**
     * Set Metadata value
     * @param \StructType\MetadataType $metadata
     * @return \StructType\ServiceListRequestType
     */
    public function setMetadata(\StructType\MetadataType $metadata = null)
    {
        $this->Metadata = $metadata;
        return $this;
    }
    /**
     * Get OfferCriteria value
     * @return \StructType\OfferCriteriaType|null
     */
    public function getOfferCriteria()
    {
        return $this->OfferCriteria;
    }
    /**
     * Set OfferCriteria value
     * @param \StructType\OfferCriteriaType $offerCriteria
     * @return \StructType\ServiceListRequestType
     */
    public function setOfferCriteria(\StructType\OfferCriteriaType $offerCriteria = null)
    {
        $this->OfferCriteria = $offerCriteria;
        return $this;
    }
    /**
     * Get Pax value
     * @return \StructType\PaxType[]|null
     */
    public function getPax()
    {
        return $this->Pax;
    }
    /**
     * This method is responsible for validating the values passed to the setPax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxForArrayConstraintsFromSetPax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceListRequestTypePaxItem) {
            // validation for constraint: itemType
            if (!$serviceListRequestTypePaxItem instanceof \StructType\PaxType) {
                $invalidValues[] = is_object($serviceListRequestTypePaxItem) ? get_class($serviceListRequestTypePaxItem) : sprintf('%s(%s)', gettype($serviceListRequestTypePaxItem), var_export($serviceListRequestTypePaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Pax property can only contain items of type \StructType\PaxType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Pax value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxType[] $pax
     * @return \StructType\ServiceListRequestType
     */
    public function setPax(array $pax = array())
    {
        // validation for constraint: array
        if ('' !== ($paxArrayErrorMessage = self::validatePaxForArrayConstraintsFromSetPax($pax))) {
            throw new \InvalidArgumentException($paxArrayErrorMessage, __LINE__);
        }
        $this->Pax = $pax;
        return $this;
    }
    /**
     * Add item to Pax value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxType $item
     * @return \StructType\ServiceListRequestType
     */
    public function addToPax(\StructType\PaxType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaxType) {
            throw new \InvalidArgumentException(sprintf('The Pax property can only contain items of type \StructType\PaxType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Pax[] = $item;
        return $this;
    }
    /**
     * Get PaxSegmentList value
     * @return \StructType\PaxSegmentListType|null
     */
    public function getPaxSegmentList()
    {
        return $this->PaxSegmentList;
    }
    /**
     * Set PaxSegmentList value
     * @param \StructType\PaxSegmentListType $paxSegmentList
     * @return \StructType\ServiceListRequestType
     */
    public function setPaxSegmentList(\StructType\PaxSegmentListType $paxSegmentList = null)
    {
        $this->PaxSegmentList = $paxSegmentList;
        return $this;
    }
    /**
     * Get PaymentFunctions value
     * @return \StructType\PaymentFunctionsCriteriaType[]|null
     */
    public function getPaymentFunctions()
    {
        return $this->PaymentFunctions;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFunctions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFunctions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceListRequestTypePaymentFunctionsItem) {
            // validation for constraint: itemType
            if (!$serviceListRequestTypePaymentFunctionsItem instanceof \StructType\PaymentFunctionsCriteriaType) {
                $invalidValues[] = is_object($serviceListRequestTypePaymentFunctionsItem) ? get_class($serviceListRequestTypePaymentFunctionsItem) : sprintf('%s(%s)', gettype($serviceListRequestTypePaymentFunctionsItem), var_export($serviceListRequestTypePaymentFunctionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentFunctionsCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFunctionsCriteriaType[] $paymentFunctions
     * @return \StructType\ServiceListRequestType
     */
    public function setPaymentFunctions(array $paymentFunctions = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFunctionsArrayErrorMessage = self::validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions($paymentFunctions))) {
            throw new \InvalidArgumentException($paymentFunctionsArrayErrorMessage, __LINE__);
        }
        $this->PaymentFunctions = $paymentFunctions;
        return $this;
    }
    /**
     * Add item to PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFunctionsCriteriaType $item
     * @return \StructType\ServiceListRequestType
     */
    public function addToPaymentFunctions(\StructType\PaymentFunctionsCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentFunctionsCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentFunctionsCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentFunctions[] = $item;
        return $this;
    }
    /**
     * Get Policy value
     * @return \StructType\PolicyType[]|null
     */
    public function getPolicy()
    {
        return $this->Policy;
    }
    /**
     * This method is responsible for validating the values passed to the setPolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePolicyForArrayConstraintsFromSetPolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceListRequestTypePolicyItem) {
            // validation for constraint: itemType
            if (!$serviceListRequestTypePolicyItem instanceof \StructType\PolicyType) {
                $invalidValues[] = is_object($serviceListRequestTypePolicyItem) ? get_class($serviceListRequestTypePolicyItem) : sprintf('%s(%s)', gettype($serviceListRequestTypePolicyItem), var_export($serviceListRequestTypePolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Policy property can only contain items of type \StructType\PolicyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Policy value
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyType[] $policy
     * @return \StructType\ServiceListRequestType
     */
    public function setPolicy(array $policy = array())
    {
        // validation for constraint: array
        if ('' !== ($policyArrayErrorMessage = self::validatePolicyForArrayConstraintsFromSetPolicy($policy))) {
            throw new \InvalidArgumentException($policyArrayErrorMessage, __LINE__);
        }
        $this->Policy = $policy;
        return $this;
    }
    /**
     * Add item to Policy value
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyType $item
     * @return \StructType\ServiceListRequestType
     */
    public function addToPolicy(\StructType\PolicyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PolicyType) {
            throw new \InvalidArgumentException(sprintf('The Policy property can only contain items of type \StructType\PolicyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Policy[] = $item;
        return $this;
    }
    /**
     * Get ResponseParameters value
     * @return \StructType\ResponseParametersRequestType|null
     */
    public function getResponseParameters()
    {
        return $this->ResponseParameters;
    }
    /**
     * Set ResponseParameters value
     * @param \StructType\ResponseParametersRequestType $responseParameters
     * @return \StructType\ServiceListRequestType
     */
    public function setResponseParameters(\StructType\ResponseParametersRequestType $responseParameters = null)
    {
        $this->ResponseParameters = $responseParameters;
        return $this;
    }
}
