<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceListCoreRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Service List Core Request
 * @subpackage Structs
 */
class ServiceListCoreRequestType extends AbstractStructBase
{
    /**
     * The OfferRequest
     * Meta information extracted from the WSDL
     * - documentation: This is a request using offers
     * - choice: OfferRequest | OrderRequest | PaxSegmentRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ServiceListOfferRequestType
     */
    public $OfferRequest;
    /**
     * The OrderRequest
     * Meta information extracted from the WSDL
     * - documentation: This is request using Order(s)
     * - choice: OfferRequest | OrderRequest | PaxSegmentRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ServiceListOrderRequestType
     */
    public $OrderRequest;
    /**
     * The PaxSegmentRequest
     * Meta information extracted from the WSDL
     * - documentation: This is a request using Passenger Segment(s)
     * - choice: OfferRequest | OrderRequest | PaxSegmentRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaxSegmentRequestType
     */
    public $PaxSegmentRequest;
    /**
     * Constructor method for ServiceListCoreRequestType
     * @uses ServiceListCoreRequestType::setOfferRequest()
     * @uses ServiceListCoreRequestType::setOrderRequest()
     * @uses ServiceListCoreRequestType::setPaxSegmentRequest()
     * @param \StructType\ServiceListOfferRequestType $offerRequest
     * @param \StructType\ServiceListOrderRequestType $orderRequest
     * @param \StructType\PaxSegmentRequestType $paxSegmentRequest
     */
    public function __construct(\StructType\ServiceListOfferRequestType $offerRequest = null, \StructType\ServiceListOrderRequestType $orderRequest = null, \StructType\PaxSegmentRequestType $paxSegmentRequest = null)
    {
        $this
            ->setOfferRequest($offerRequest)
            ->setOrderRequest($orderRequest)
            ->setPaxSegmentRequest($paxSegmentRequest);
    }
    /**
     * Get OfferRequest value
     * @return \StructType\ServiceListOfferRequestType
     */
    public function getOfferRequest()
    {
        return isset($this->OfferRequest) ? $this->OfferRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOfferRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfferRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOfferRequestForChoiceConstraintsFromSetOfferRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OrderRequest',
            'PaxSegmentRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OfferRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: OfferRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OfferRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceListOfferRequestType $offerRequest
     * @return \StructType\ServiceListCoreRequestType
     */
    public function setOfferRequest(\StructType\ServiceListOfferRequestType $offerRequest = null)
    {
        // validation for constraint: choice(OfferRequest, OrderRequest, PaxSegmentRequest)
        if ('' !== ($offerRequestChoiceErrorMessage = self::validateOfferRequestForChoiceConstraintsFromSetOfferRequest($offerRequest))) {
            throw new \InvalidArgumentException($offerRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($offerRequest) || (is_array($offerRequest) && empty($offerRequest))) {
            unset($this->OfferRequest);
        } else {
            $this->OfferRequest = $offerRequest;
        }
        return $this;
    }
    /**
     * Get OrderRequest value
     * @return \StructType\ServiceListOrderRequestType
     */
    public function getOrderRequest()
    {
        return isset($this->OrderRequest) ? $this->OrderRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOrderRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOrderRequestForChoiceConstraintsFromSetOrderRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferRequest',
            'PaxSegmentRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OrderRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: OrderRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OrderRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceListOrderRequestType $orderRequest
     * @return \StructType\ServiceListCoreRequestType
     */
    public function setOrderRequest(\StructType\ServiceListOrderRequestType $orderRequest = null)
    {
        // validation for constraint: choice(OfferRequest, OrderRequest, PaxSegmentRequest)
        if ('' !== ($orderRequestChoiceErrorMessage = self::validateOrderRequestForChoiceConstraintsFromSetOrderRequest($orderRequest))) {
            throw new \InvalidArgumentException($orderRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($orderRequest) || (is_array($orderRequest) && empty($orderRequest))) {
            unset($this->OrderRequest);
        } else {
            $this->OrderRequest = $orderRequest;
        }
        return $this;
    }
    /**
     * Get PaxSegmentRequest value
     * @return \StructType\PaxSegmentRequestType
     */
    public function getPaxSegmentRequest()
    {
        return isset($this->PaxSegmentRequest) ? $this->PaxSegmentRequest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPaxSegmentRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxSegmentRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaxSegmentRequestForChoiceConstraintsFromSetPaxSegmentRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferRequest',
            'OrderRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaxSegmentRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: PaxSegmentRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaxSegmentRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaxSegmentRequestType $paxSegmentRequest
     * @return \StructType\ServiceListCoreRequestType
     */
    public function setPaxSegmentRequest(\StructType\PaxSegmentRequestType $paxSegmentRequest = null)
    {
        // validation for constraint: choice(OfferRequest, OrderRequest, PaxSegmentRequest)
        if ('' !== ($paxSegmentRequestChoiceErrorMessage = self::validatePaxSegmentRequestForChoiceConstraintsFromSetPaxSegmentRequest($paxSegmentRequest))) {
            throw new \InvalidArgumentException($paxSegmentRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($paxSegmentRequest) || (is_array($paxSegmentRequest) && empty($paxSegmentRequest))) {
            unset($this->PaxSegmentRequest);
        } else {
            $this->PaxSegmentRequest = $paxSegmentRequest;
        }
        return $this;
    }
}
