<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceKeyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Service Key specialization of an instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order. At the time of shopping, a service can
 * be sold to multiple passengers on a given journey. At time of order, the services should be applied to a single passenger on a single segment.
 * @subpackage Structs
 */
class ServiceKeyType extends AbstractStructBase
{
    /**
     * The ServiceID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely Identifies a Service within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceID;
    /**
     * The BookingRef
     * Meta information extracted from the WSDL
     * - documentation: Information related to a booking or reservation.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\BookingRefType[]
     */
    public $BookingRef;
    /**
     * The DatedOperatingLegRef
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Dated Operating Leg within this message
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DatedOperatingLegRefType
     */
    public $DatedOperatingLegRef;
    /**
     * The ValidatingCarrier
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CarrierType
     */
    public $ValidatingCarrier;
    /**
     * Constructor method for ServiceKeyType
     * @uses ServiceKeyType::setServiceID()
     * @uses ServiceKeyType::setBookingRef()
     * @uses ServiceKeyType::setDatedOperatingLegRef()
     * @uses ServiceKeyType::setValidatingCarrier()
     * @param string $serviceID
     * @param \StructType\BookingRefType[] $bookingRef
     * @param \StructType\DatedOperatingLegRefType $datedOperatingLegRef
     * @param \StructType\CarrierType $validatingCarrier
     */
    public function __construct($serviceID = null, array $bookingRef = array(), \StructType\DatedOperatingLegRefType $datedOperatingLegRef = null, \StructType\CarrierType $validatingCarrier = null)
    {
        $this
            ->setServiceID($serviceID)
            ->setBookingRef($bookingRef)
            ->setDatedOperatingLegRef($datedOperatingLegRef)
            ->setValidatingCarrier($validatingCarrier);
    }
    /**
     * Get ServiceID value
     * @return string
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param string $serviceID
     * @return \StructType\ServiceKeyType
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceID) && !is_string($serviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceID, true), gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
    /**
     * Get BookingRef value
     * @return \StructType\BookingRefType[]|null
     */
    public function getBookingRef()
    {
        return $this->BookingRef;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingRefForArrayConstraintsFromSetBookingRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceKeyTypeBookingRefItem) {
            // validation for constraint: itemType
            if (!$serviceKeyTypeBookingRefItem instanceof \StructType\BookingRefType) {
                $invalidValues[] = is_object($serviceKeyTypeBookingRefItem) ? get_class($serviceKeyTypeBookingRefItem) : sprintf('%s(%s)', gettype($serviceKeyTypeBookingRefItem), var_export($serviceKeyTypeBookingRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType[] $bookingRef
     * @return \StructType\ServiceKeyType
     */
    public function setBookingRef(array $bookingRef = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingRefArrayErrorMessage = self::validateBookingRefForArrayConstraintsFromSetBookingRef($bookingRef))) {
            throw new \InvalidArgumentException($bookingRefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($bookingRef) && count($bookingRef) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($bookingRef)), __LINE__);
        }
        $this->BookingRef = $bookingRef;
        return $this;
    }
    /**
     * Add item to BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType $item
     * @return \StructType\ServiceKeyType
     */
    public function addToBookingRef(\StructType\BookingRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingRefType) {
            throw new \InvalidArgumentException(sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->BookingRef) && count($this->BookingRef) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->BookingRef)), __LINE__);
        }
        $this->BookingRef[] = $item;
        return $this;
    }
    /**
     * Get DatedOperatingLegRef value
     * @return \StructType\DatedOperatingLegRefType|null
     */
    public function getDatedOperatingLegRef()
    {
        return $this->DatedOperatingLegRef;
    }
    /**
     * Set DatedOperatingLegRef value
     * @param \StructType\DatedOperatingLegRefType $datedOperatingLegRef
     * @return \StructType\ServiceKeyType
     */
    public function setDatedOperatingLegRef(\StructType\DatedOperatingLegRefType $datedOperatingLegRef = null)
    {
        $this->DatedOperatingLegRef = $datedOperatingLegRef;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return \StructType\CarrierType|null
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @param \StructType\CarrierType $validatingCarrier
     * @return \StructType\ServiceKeyType
     */
    public function setValidatingCarrier(\StructType\CarrierType $validatingCarrier = null)
    {
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
}
