<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceDeliveryResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to the Service Delivery Response message.
 * @subpackage Structs
 */
class ServiceDeliveryResponseType extends AbstractStructBase
{
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: Delivered Order is a uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and
     * services that are not necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each
     * passenger in an Order may hold different sets of order items at different prices.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\DeliveredOrderType[]
     */
    public $Order;
    /**
     * The DataLists
     * Meta information extracted from the WSDL
     * - documentation: Data List definition for this message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceDeliveryDataListsType
     */
    public $DataLists;
    /**
     * The PaymentProcessingSummary
     * Meta information extracted from the WSDL
     * - documentation: Payment Processing Delivery Response Summary Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentProcessingDeliveryResponseSummaryType[]
     */
    public $PaymentProcessingSummary;
    /**
     * The Warning
     * Meta information extracted from the WSDL
     * - documentation: Contains information related to potential business errors detected during processing of the preceding request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WarningType[]
     */
    public $Warning;
    /**
     * Constructor method for ServiceDeliveryResponseType
     * @uses ServiceDeliveryResponseType::setOrder()
     * @uses ServiceDeliveryResponseType::setDataLists()
     * @uses ServiceDeliveryResponseType::setPaymentProcessingSummary()
     * @uses ServiceDeliveryResponseType::setWarning()
     * @param \StructType\DeliveredOrderType[] $order
     * @param \StructType\ServiceDeliveryDataListsType $dataLists
     * @param \StructType\PaymentProcessingDeliveryResponseSummaryType[] $paymentProcessingSummary
     * @param \StructType\WarningType[] $warning
     */
    public function __construct(array $order = array(), \StructType\ServiceDeliveryDataListsType $dataLists = null, array $paymentProcessingSummary = array(), array $warning = array())
    {
        $this
            ->setOrder($order)
            ->setDataLists($dataLists)
            ->setPaymentProcessingSummary($paymentProcessingSummary)
            ->setWarning($warning);
    }
    /**
     * Get Order value
     * @return \StructType\DeliveredOrderType[]
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * This method is responsible for validating the values passed to the setOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderForArrayConstraintsFromSetOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceDeliveryResponseTypeOrderItem) {
            // validation for constraint: itemType
            if (!$serviceDeliveryResponseTypeOrderItem instanceof \StructType\DeliveredOrderType) {
                $invalidValues[] = is_object($serviceDeliveryResponseTypeOrderItem) ? get_class($serviceDeliveryResponseTypeOrderItem) : sprintf('%s(%s)', gettype($serviceDeliveryResponseTypeOrderItem), var_export($serviceDeliveryResponseTypeOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Order property can only contain items of type \StructType\DeliveredOrderType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Order value
     * @throws \InvalidArgumentException
     * @param \StructType\DeliveredOrderType[] $order
     * @return \StructType\ServiceDeliveryResponseType
     */
    public function setOrder(array $order = array())
    {
        // validation for constraint: array
        if ('' !== ($orderArrayErrorMessage = self::validateOrderForArrayConstraintsFromSetOrder($order))) {
            throw new \InvalidArgumentException($orderArrayErrorMessage, __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Add item to Order value
     * @throws \InvalidArgumentException
     * @param \StructType\DeliveredOrderType $item
     * @return \StructType\ServiceDeliveryResponseType
     */
    public function addToOrder(\StructType\DeliveredOrderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeliveredOrderType) {
            throw new \InvalidArgumentException(sprintf('The Order property can only contain items of type \StructType\DeliveredOrderType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Order[] = $item;
        return $this;
    }
    /**
     * Get DataLists value
     * @return \StructType\ServiceDeliveryDataListsType|null
     */
    public function getDataLists()
    {
        return $this->DataLists;
    }
    /**
     * Set DataLists value
     * @param \StructType\ServiceDeliveryDataListsType $dataLists
     * @return \StructType\ServiceDeliveryResponseType
     */
    public function setDataLists(\StructType\ServiceDeliveryDataListsType $dataLists = null)
    {
        $this->DataLists = $dataLists;
        return $this;
    }
    /**
     * Get PaymentProcessingSummary value
     * @return \StructType\PaymentProcessingDeliveryResponseSummaryType[]|null
     */
    public function getPaymentProcessingSummary()
    {
        return $this->PaymentProcessingSummary;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentProcessingSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentProcessingSummary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentProcessingSummaryForArrayConstraintsFromSetPaymentProcessingSummary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceDeliveryResponseTypePaymentProcessingSummaryItem) {
            // validation for constraint: itemType
            if (!$serviceDeliveryResponseTypePaymentProcessingSummaryItem instanceof \StructType\PaymentProcessingDeliveryResponseSummaryType) {
                $invalidValues[] = is_object($serviceDeliveryResponseTypePaymentProcessingSummaryItem) ? get_class($serviceDeliveryResponseTypePaymentProcessingSummaryItem) : sprintf('%s(%s)', gettype($serviceDeliveryResponseTypePaymentProcessingSummaryItem), var_export($serviceDeliveryResponseTypePaymentProcessingSummaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentProcessingSummary property can only contain items of type \StructType\PaymentProcessingDeliveryResponseSummaryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentProcessingSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentProcessingDeliveryResponseSummaryType[] $paymentProcessingSummary
     * @return \StructType\ServiceDeliveryResponseType
     */
    public function setPaymentProcessingSummary(array $paymentProcessingSummary = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentProcessingSummaryArrayErrorMessage = self::validatePaymentProcessingSummaryForArrayConstraintsFromSetPaymentProcessingSummary($paymentProcessingSummary))) {
            throw new \InvalidArgumentException($paymentProcessingSummaryArrayErrorMessage, __LINE__);
        }
        $this->PaymentProcessingSummary = $paymentProcessingSummary;
        return $this;
    }
    /**
     * Add item to PaymentProcessingSummary value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentProcessingDeliveryResponseSummaryType $item
     * @return \StructType\ServiceDeliveryResponseType
     */
    public function addToPaymentProcessingSummary(\StructType\PaymentProcessingDeliveryResponseSummaryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentProcessingDeliveryResponseSummaryType) {
            throw new \InvalidArgumentException(sprintf('The PaymentProcessingSummary property can only contain items of type \StructType\PaymentProcessingDeliveryResponseSummaryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentProcessingSummary[] = $item;
        return $this;
    }
    /**
     * Get Warning value
     * @return \StructType\WarningType[]|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * This method is responsible for validating the values passed to the setWarning method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarning method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningForArrayConstraintsFromSetWarning(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceDeliveryResponseTypeWarningItem) {
            // validation for constraint: itemType
            if (!$serviceDeliveryResponseTypeWarningItem instanceof \StructType\WarningType) {
                $invalidValues[] = is_object($serviceDeliveryResponseTypeWarningItem) ? get_class($serviceDeliveryResponseTypeWarningItem) : sprintf('%s(%s)', gettype($serviceDeliveryResponseTypeWarningItem), var_export($serviceDeliveryResponseTypeWarningItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType[] $warning
     * @return \StructType\ServiceDeliveryResponseType
     */
    public function setWarning(array $warning = array())
    {
        // validation for constraint: array
        if ('' !== ($warningArrayErrorMessage = self::validateWarningForArrayConstraintsFromSetWarning($warning))) {
            throw new \InvalidArgumentException($warningArrayErrorMessage, __LINE__);
        }
        $this->Warning = $warning;
        return $this;
    }
    /**
     * Add item to Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType $item
     * @return \StructType\ServiceDeliveryResponseType
     */
    public function addToWarning(\StructType\WarningType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WarningType) {
            throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Warning[] = $item;
        return $this;
    }
}
