<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Reason for Issuance Group and Subgroup code(s) that specify the requested categories of Optional Services to be returned in the results.
 * @subpackage Structs
 */
class ServiceCriteriaType extends AbstractStructBase
{
    /**
     * The IncludeInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, specified service should be included in search results. When FALSE, exclude shopping results including the specified service. | An indicator is a list of two mutually exclusive Boolean values that express the only possible
     * states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeInd;
    /**
     * The PrefLevel
     * Meta information extracted from the WSDL
     * - documentation: Information supporting a preference including preference level code (Examples: Preferred, Required or Exclude.).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PrefLevelType
     */
    public $PrefLevel;
    /**
     * The RFIC
     * Meta information extracted from the WSDL
     * - documentation: Reason For Issuance Code Examples: A (Air Transportation) C (Baggage) E (Airport Services) F (Merchandise) G (In-flight Services) Refer to PADIS Codeset for data element 4183 - Special Condition. | Enumeration values for Reason for
     * Issuance codes. {codeListAgencyName}PADIS{/codeListAgencyName} {codeListName}Special condition{/codeListName} {codeListIdentifier}4183{/codeListIdentifier} | Additional BDT to specify the reason for issuance code.
     * - base: RFIC_CodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9A-Z]{1,3}
     * @var string
     */
    public $RFIC;
    /**
     * The RFISC
     * Meta information extracted from the WSDL
     * - documentation: Reason For Issuance Sub Code. Examples: 0CC (First Checked Bag) 0B1 (In-flight Entertainment) 0BX (Lounge) | Enumeration values for Reason for Issuance sub codes. Examples: 0CC (First Checked Bag). 0B1 (In-flight Entertainment). 0BX
     * (Lounge). 0B3 (Meal/ Beverage). 0B5 (Pre-reserved Seat Assignment). 0G6 (Priority Boarding). {codeListAgencyName}ATPCo{/codeListAgencyName} {codeListName}Optional Services Industry Sub Codes{/codeListName} | Additional BDT to specify the reason for
     * issuance sub code.
     * - base: RFISC_CodeContentType
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $RFISC;
    /**
     * The ServicePricingOnlyInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, service pricing only is requested. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ServicePricingOnlyInd;
    /**
     * The TaxonomyCode
     * Meta information extracted from the WSDL
     * - documentation: Used for defining a product or service within the Shared Industry Taxonomy or bilaterally. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TaxonomyCode;
    /**
     * Constructor method for ServiceCriteriaType
     * @uses ServiceCriteriaType::setIncludeInd()
     * @uses ServiceCriteriaType::setPrefLevel()
     * @uses ServiceCriteriaType::setRFIC()
     * @uses ServiceCriteriaType::setRFISC()
     * @uses ServiceCriteriaType::setServicePricingOnlyInd()
     * @uses ServiceCriteriaType::setTaxonomyCode()
     * @param bool $includeInd
     * @param \StructType\PrefLevelType $prefLevel
     * @param string $rFIC
     * @param string[] $rFISC
     * @param bool $servicePricingOnlyInd
     * @param string[] $taxonomyCode
     */
    public function __construct($includeInd = null, \StructType\PrefLevelType $prefLevel = null, $rFIC = null, array $rFISC = array(), $servicePricingOnlyInd = null, array $taxonomyCode = array())
    {
        $this
            ->setIncludeInd($includeInd)
            ->setPrefLevel($prefLevel)
            ->setRFIC($rFIC)
            ->setRFISC($rFISC)
            ->setServicePricingOnlyInd($servicePricingOnlyInd)
            ->setTaxonomyCode($taxonomyCode);
    }
    /**
     * Get IncludeInd value
     * @return bool|null
     */
    public function getIncludeInd()
    {
        return $this->IncludeInd;
    }
    /**
     * Set IncludeInd value
     * @param bool $includeInd
     * @return \StructType\ServiceCriteriaType
     */
    public function setIncludeInd($includeInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeInd) && !is_bool($includeInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeInd, true), gettype($includeInd)), __LINE__);
        }
        $this->IncludeInd = $includeInd;
        return $this;
    }
    /**
     * Get PrefLevel value
     * @return \StructType\PrefLevelType|null
     */
    public function getPrefLevel()
    {
        return $this->PrefLevel;
    }
    /**
     * Set PrefLevel value
     * @param \StructType\PrefLevelType $prefLevel
     * @return \StructType\ServiceCriteriaType
     */
    public function setPrefLevel(\StructType\PrefLevelType $prefLevel = null)
    {
        $this->PrefLevel = $prefLevel;
        return $this;
    }
    /**
     * Get RFIC value
     * @return string|null
     */
    public function getRFIC()
    {
        return $this->RFIC;
    }
    /**
     * Set RFIC value
     * @param string $rFIC
     * @return \StructType\ServiceCriteriaType
     */
    public function setRFIC($rFIC = null)
    {
        // validation for constraint: string
        if (!is_null($rFIC) && !is_string($rFIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFIC, true), gettype($rFIC)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3})
        if (!is_null($rFIC) && !preg_match('/[0-9A-Z]{1,3}/', $rFIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}', var_export($rFIC, true)), __LINE__);
        }
        $this->RFIC = $rFIC;
        return $this;
    }
    /**
     * Get RFISC value
     * @return string[]|null
     */
    public function getRFISC()
    {
        return $this->RFISC;
    }
    /**
     * This method is responsible for validating the values passed to the setRFISC method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRFISC method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRFISCForArrayConstraintsFromSetRFISC(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceCriteriaTypeRFISCItem) {
            // validation for constraint: itemType
            if (!is_string($serviceCriteriaTypeRFISCItem)) {
                $invalidValues[] = is_object($serviceCriteriaTypeRFISCItem) ? get_class($serviceCriteriaTypeRFISCItem) : sprintf('%s(%s)', gettype($serviceCriteriaTypeRFISCItem), var_export($serviceCriteriaTypeRFISCItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RFISC property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RFISC value
     * @throws \InvalidArgumentException
     * @param string[] $rFISC
     * @return \StructType\ServiceCriteriaType
     */
    public function setRFISC(array $rFISC = array())
    {
        // validation for constraint: array
        if ('' !== ($rFISCArrayErrorMessage = self::validateRFISCForArrayConstraintsFromSetRFISC($rFISC))) {
            throw new \InvalidArgumentException($rFISCArrayErrorMessage, __LINE__);
        }
        $this->RFISC = $rFISC;
        return $this;
    }
    /**
     * Add item to RFISC value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ServiceCriteriaType
     */
    public function addToRFISC($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The RFISC property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RFISC[] = $item;
        return $this;
    }
    /**
     * Get ServicePricingOnlyInd value
     * @return bool|null
     */
    public function getServicePricingOnlyInd()
    {
        return $this->ServicePricingOnlyInd;
    }
    /**
     * Set ServicePricingOnlyInd value
     * @param bool $servicePricingOnlyInd
     * @return \StructType\ServiceCriteriaType
     */
    public function setServicePricingOnlyInd($servicePricingOnlyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($servicePricingOnlyInd) && !is_bool($servicePricingOnlyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($servicePricingOnlyInd, true), gettype($servicePricingOnlyInd)), __LINE__);
        }
        $this->ServicePricingOnlyInd = $servicePricingOnlyInd;
        return $this;
    }
    /**
     * Get TaxonomyCode value
     * @return string[]|null
     */
    public function getTaxonomyCode()
    {
        return $this->TaxonomyCode;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxonomyCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxonomyCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxonomyCodeForArrayConstraintsFromSetTaxonomyCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceCriteriaTypeTaxonomyCodeItem) {
            // validation for constraint: itemType
            if (!is_string($serviceCriteriaTypeTaxonomyCodeItem)) {
                $invalidValues[] = is_object($serviceCriteriaTypeTaxonomyCodeItem) ? get_class($serviceCriteriaTypeTaxonomyCodeItem) : sprintf('%s(%s)', gettype($serviceCriteriaTypeTaxonomyCodeItem), var_export($serviceCriteriaTypeTaxonomyCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxonomyCode property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxonomyCode value
     * @throws \InvalidArgumentException
     * @param string[] $taxonomyCode
     * @return \StructType\ServiceCriteriaType
     */
    public function setTaxonomyCode(array $taxonomyCode = array())
    {
        // validation for constraint: array
        if ('' !== ($taxonomyCodeArrayErrorMessage = self::validateTaxonomyCodeForArrayConstraintsFromSetTaxonomyCode($taxonomyCode))) {
            throw new \InvalidArgumentException($taxonomyCodeArrayErrorMessage, __LINE__);
        }
        $this->TaxonomyCode = $taxonomyCode;
        return $this;
    }
    /**
     * Add item to TaxonomyCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ServiceCriteriaType
     */
    public function addToTaxonomyCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The TaxonomyCode property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxonomyCode[] = $item;
        return $this;
    }
}
