<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectedOfferItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: OfferItem selected by the Passenger for inclusion in the requested Order. Repeat occurrence of OfferItem (once per passenger) if different passengers want to select different service options, different quantities of a-la-carte items
 * or different seat locations. As a minimum, all mandatory OfferItems from a desired Offer should be explicitly defined within these selections and should repeat the same Passenger and Flight Segment associations defined in the originating OfferItems.
 * Optional OfferItems may then be appended as further items selected by the Passenger. OfferItems from the originating Offers may take on two different forms, which in turn drives how the ALaCarteSelection element is to be used - If the OfferItem
 * referenced comes originally from an a-la-carte Offer, then the use of the ALaCarteSelection element should be used to defined the Quantity of said OfferItem. On the other hand, if the OfferItem comes from a standard type of Offer in the previous
 * shopping response, the ALaCarteSelection element should not be used, as the quantity is explicitly driven by what is defined in that OfferItem's associations (to passengers and/or flight segments).
 * @subpackage Structs
 */
class SelectedOfferItemType extends AbstractStructBase
{
    /**
     * The OfferItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the OfferItemID of the selected OfferItem (contained in either a standard Offer or an a-la-carte Offer) returned in a previous shopping response. | An identifier is a character string used to uniquely identify one
     * instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OfferItemRefID;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to passenger(s) for which this OfferItem and selected Services (in case of Service Bundles) applies. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme
     * that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $PaxRefID;
    /**
     * The SelectedALaCarteOfferItem
     * Meta information extracted from the WSDL
     * - documentation: Use to select the quantity of Offer Items from the A La Carte Offer Items.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SelectedALaCarteOfferItemType
     */
    public $SelectedALaCarteOfferItem;
    /**
     * The SelectedBundleServices
     * Meta information extracted from the WSDL
     * - documentation: For service bundle selection - only to be used for bundles with optional choices (e.g. pick 2 out of 4)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SelectedBundleServicesType
     */
    public $SelectedBundleServices;
    /**
     * The SelectedSeat
     * Meta information extracted from the WSDL
     * - documentation: Selection of specific seat location, as provided in seat availability messages. When used, only a single Passenger must be referenced for a single Segment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SelectedSeatType
     */
    public $SelectedSeat;
    /**
     * Constructor method for SelectedOfferItemType
     * @uses SelectedOfferItemType::setOfferItemRefID()
     * @uses SelectedOfferItemType::setPaxRefID()
     * @uses SelectedOfferItemType::setSelectedALaCarteOfferItem()
     * @uses SelectedOfferItemType::setSelectedBundleServices()
     * @uses SelectedOfferItemType::setSelectedSeat()
     * @param string $offerItemRefID
     * @param string[] $paxRefID
     * @param \StructType\SelectedALaCarteOfferItemType $selectedALaCarteOfferItem
     * @param \StructType\SelectedBundleServicesType $selectedBundleServices
     * @param \StructType\SelectedSeatType $selectedSeat
     */
    public function __construct($offerItemRefID = null, array $paxRefID = array(), \StructType\SelectedALaCarteOfferItemType $selectedALaCarteOfferItem = null, \StructType\SelectedBundleServicesType $selectedBundleServices = null, \StructType\SelectedSeatType $selectedSeat = null)
    {
        $this
            ->setOfferItemRefID($offerItemRefID)
            ->setPaxRefID($paxRefID)
            ->setSelectedALaCarteOfferItem($selectedALaCarteOfferItem)
            ->setSelectedBundleServices($selectedBundleServices)
            ->setSelectedSeat($selectedSeat);
    }
    /**
     * Get OfferItemRefID value
     * @return string
     */
    public function getOfferItemRefID()
    {
        return $this->OfferItemRefID;
    }
    /**
     * Set OfferItemRefID value
     * @param string $offerItemRefID
     * @return \StructType\SelectedOfferItemType
     */
    public function setOfferItemRefID($offerItemRefID = null)
    {
        // validation for constraint: string
        if (!is_null($offerItemRefID) && !is_string($offerItemRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerItemRefID, true), gettype($offerItemRefID)), __LINE__);
        }
        $this->OfferItemRefID = $offerItemRefID;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string[]
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxRefIDForArrayConstraintsFromSetPaxRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $selectedOfferItemTypePaxRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($selectedOfferItemTypePaxRefIDItem)) {
                $invalidValues[] = is_object($selectedOfferItemTypePaxRefIDItem) ? get_class($selectedOfferItemTypePaxRefIDItem) : sprintf('%s(%s)', gettype($selectedOfferItemTypePaxRefIDItem), var_export($selectedOfferItemTypePaxRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paxRefID
     * @return \StructType\SelectedOfferItemType
     */
    public function setPaxRefID(array $paxRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxRefIDArrayErrorMessage = self::validatePaxRefIDForArrayConstraintsFromSetPaxRefID($paxRefID))) {
            throw new \InvalidArgumentException($paxRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Add item to PaxRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SelectedOfferItemType
     */
    public function addToPaxRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxRefID[] = $item;
        return $this;
    }
    /**
     * Get SelectedALaCarteOfferItem value
     * @return \StructType\SelectedALaCarteOfferItemType|null
     */
    public function getSelectedALaCarteOfferItem()
    {
        return $this->SelectedALaCarteOfferItem;
    }
    /**
     * Set SelectedALaCarteOfferItem value
     * @param \StructType\SelectedALaCarteOfferItemType $selectedALaCarteOfferItem
     * @return \StructType\SelectedOfferItemType
     */
    public function setSelectedALaCarteOfferItem(\StructType\SelectedALaCarteOfferItemType $selectedALaCarteOfferItem = null)
    {
        $this->SelectedALaCarteOfferItem = $selectedALaCarteOfferItem;
        return $this;
    }
    /**
     * Get SelectedBundleServices value
     * @return \StructType\SelectedBundleServicesType|null
     */
    public function getSelectedBundleServices()
    {
        return $this->SelectedBundleServices;
    }
    /**
     * Set SelectedBundleServices value
     * @param \StructType\SelectedBundleServicesType $selectedBundleServices
     * @return \StructType\SelectedOfferItemType
     */
    public function setSelectedBundleServices(\StructType\SelectedBundleServicesType $selectedBundleServices = null)
    {
        $this->SelectedBundleServices = $selectedBundleServices;
        return $this;
    }
    /**
     * Get SelectedSeat value
     * @return \StructType\SelectedSeatType|null
     */
    public function getSelectedSeat()
    {
        return $this->SelectedSeat;
    }
    /**
     * Set SelectedSeat value
     * @param \StructType\SelectedSeatType $selectedSeat
     * @return \StructType\SelectedOfferItemType
     */
    public function setSelectedSeat(\StructType\SelectedSeatType $selectedSeat = null)
    {
        $this->SelectedSeat = $selectedSeat;
        return $this;
    }
}
