<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectedBundleServicesType StructType
 * Meta information extracted from the WSDL
 * - documentation: For service bundle selection - only to be used for bundles with optional choices (e.g. pick 2 out of 4)
 * @subpackage Structs
 */
class SelectedBundleServicesType extends AbstractStructBase
{
    /**
     * The SelectedServiceRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Service (within the Offer Item) form which the Service Bundle is contained. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by
     * an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SelectedServiceRefID;
    /**
     * The SelectedServiceDefinitionRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Service Definition selected by the Passenger as part of a service bundle. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by
     * an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SelectedServiceDefinitionRefID;
    /**
     * Constructor method for SelectedBundleServicesType
     * @uses SelectedBundleServicesType::setSelectedServiceRefID()
     * @uses SelectedBundleServicesType::setSelectedServiceDefinitionRefID()
     * @param string $selectedServiceRefID
     * @param string[] $selectedServiceDefinitionRefID
     */
    public function __construct($selectedServiceRefID = null, array $selectedServiceDefinitionRefID = array())
    {
        $this
            ->setSelectedServiceRefID($selectedServiceRefID)
            ->setSelectedServiceDefinitionRefID($selectedServiceDefinitionRefID);
    }
    /**
     * Get SelectedServiceRefID value
     * @return string
     */
    public function getSelectedServiceRefID()
    {
        return $this->SelectedServiceRefID;
    }
    /**
     * Set SelectedServiceRefID value
     * @param string $selectedServiceRefID
     * @return \StructType\SelectedBundleServicesType
     */
    public function setSelectedServiceRefID($selectedServiceRefID = null)
    {
        // validation for constraint: string
        if (!is_null($selectedServiceRefID) && !is_string($selectedServiceRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedServiceRefID, true), gettype($selectedServiceRefID)), __LINE__);
        }
        $this->SelectedServiceRefID = $selectedServiceRefID;
        return $this;
    }
    /**
     * Get SelectedServiceDefinitionRefID value
     * @return string[]|null
     */
    public function getSelectedServiceDefinitionRefID()
    {
        return $this->SelectedServiceDefinitionRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectedServiceDefinitionRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectedServiceDefinitionRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectedServiceDefinitionRefIDForArrayConstraintsFromSetSelectedServiceDefinitionRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $selectedBundleServicesTypeSelectedServiceDefinitionRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($selectedBundleServicesTypeSelectedServiceDefinitionRefIDItem)) {
                $invalidValues[] = is_object($selectedBundleServicesTypeSelectedServiceDefinitionRefIDItem) ? get_class($selectedBundleServicesTypeSelectedServiceDefinitionRefIDItem) : sprintf('%s(%s)', gettype($selectedBundleServicesTypeSelectedServiceDefinitionRefIDItem), var_export($selectedBundleServicesTypeSelectedServiceDefinitionRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectedServiceDefinitionRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectedServiceDefinitionRefID value
     * @throws \InvalidArgumentException
     * @param string[] $selectedServiceDefinitionRefID
     * @return \StructType\SelectedBundleServicesType
     */
    public function setSelectedServiceDefinitionRefID(array $selectedServiceDefinitionRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($selectedServiceDefinitionRefIDArrayErrorMessage = self::validateSelectedServiceDefinitionRefIDForArrayConstraintsFromSetSelectedServiceDefinitionRefID($selectedServiceDefinitionRefID))) {
            throw new \InvalidArgumentException($selectedServiceDefinitionRefIDArrayErrorMessage, __LINE__);
        }
        $this->SelectedServiceDefinitionRefID = $selectedServiceDefinitionRefID;
        return $this;
    }
    /**
     * Add item to SelectedServiceDefinitionRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SelectedBundleServicesType
     */
    public function addToSelectedServiceDefinitionRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The SelectedServiceDefinitionRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectedServiceDefinitionRefID[] = $item;
        return $this;
    }
}
