<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SecureProgramType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains enrolment information of the Payment Card. e.g. Verified by Visa.
 * @subpackage Structs
 */
class SecureProgramType extends AbstractStructBase
{
    /**
     * The EnrollmentStatusText
     * Meta information extracted from the WSDL
     * - documentation: 3D Secure Program Enrollment Status. Examples: CardNotEnrolled, CardEnrolled, CardMayBeEnrolled, Unknown | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EnrollmentStatusText;
    /**
     * The SecurePaymentProgramName
     * Meta information extracted from the WSDL
     * - documentation: Name of the secure payment program. E.g. Verified by Visa. | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SecurePaymentProgramName;
    /**
     * Constructor method for SecureProgramType
     * @uses SecureProgramType::setEnrollmentStatusText()
     * @uses SecureProgramType::setSecurePaymentProgramName()
     * @param string $enrollmentStatusText
     * @param string $securePaymentProgramName
     */
    public function __construct($enrollmentStatusText = null, $securePaymentProgramName = null)
    {
        $this
            ->setEnrollmentStatusText($enrollmentStatusText)
            ->setSecurePaymentProgramName($securePaymentProgramName);
    }
    /**
     * Get EnrollmentStatusText value
     * @return string|null
     */
    public function getEnrollmentStatusText()
    {
        return $this->EnrollmentStatusText;
    }
    /**
     * Set EnrollmentStatusText value
     * @param string $enrollmentStatusText
     * @return \StructType\SecureProgramType
     */
    public function setEnrollmentStatusText($enrollmentStatusText = null)
    {
        // validation for constraint: string
        if (!is_null($enrollmentStatusText) && !is_string($enrollmentStatusText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enrollmentStatusText, true), gettype($enrollmentStatusText)), __LINE__);
        }
        $this->EnrollmentStatusText = $enrollmentStatusText;
        return $this;
    }
    /**
     * Get SecurePaymentProgramName value
     * @return string|null
     */
    public function getSecurePaymentProgramName()
    {
        return $this->SecurePaymentProgramName;
    }
    /**
     * Set SecurePaymentProgramName value
     * @param string $securePaymentProgramName
     * @return \StructType\SecureProgramType
     */
    public function setSecurePaymentProgramName($securePaymentProgramName = null)
    {
        // validation for constraint: string
        if (!is_null($securePaymentProgramName) && !is_string($securePaymentProgramName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securePaymentProgramName, true), gettype($securePaymentProgramName)), __LINE__);
        }
        $this->SecurePaymentProgramName = $securePaymentProgramName;
        return $this;
    }
}
