<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SecurePaymentVersion1Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the indicators and fields that convey the result of the 3D Secure authentication transaction. Applicable for 3D Secure Version V 1.0.
 * @subpackage Structs
 */
class SecurePaymentVersion1Type extends AbstractStructBase
{
    /**
     * The PayerAuthenticationResponseText
     * Meta information extracted from the WSDL
     * - documentation: The authentication response for the 3-D Secure transaction. It is used to determine whether or not the customer has been authenticated by the card issuer. It must be included in the final authorization request. Example:
     * eJzVWFmzosgSfudXdPQ8Gt1sbkzYRhQ7KCjI/sYOsimgoL/+lp7Tp5c5t2d67tMw8yv/WqiluJXS8WyyVFEQT28qz | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayerAuthenticationResponseText;
    /**
     * Constructor method for SecurePaymentVersion1Type
     * @uses SecurePaymentVersion1Type::setPayerAuthenticationResponseText()
     * @param string $payerAuthenticationResponseText
     */
    public function __construct($payerAuthenticationResponseText = null)
    {
        $this
            ->setPayerAuthenticationResponseText($payerAuthenticationResponseText);
    }
    /**
     * Get PayerAuthenticationResponseText value
     * @return string|null
     */
    public function getPayerAuthenticationResponseText()
    {
        return $this->PayerAuthenticationResponseText;
    }
    /**
     * Set PayerAuthenticationResponseText value
     * @param string $payerAuthenticationResponseText
     * @return \StructType\SecurePaymentVersion1Type
     */
    public function setPayerAuthenticationResponseText($payerAuthenticationResponseText = null)
    {
        // validation for constraint: string
        if (!is_null($payerAuthenticationResponseText) && !is_string($payerAuthenticationResponseText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerAuthenticationResponseText, true), gettype($payerAuthenticationResponseText)), __LINE__);
        }
        $this->PayerAuthenticationResponseText = $payerAuthenticationResponseText;
        return $this;
    }
}
