<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SecurePaymentAuthenticationVersionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Used by Seller if 3D-Secure is supported. Seller can specify which version of 3D-Secure is supported. Note: 3D-Secure context should be used when the Customer-Seller interaction type is web and/or mobile.
 * @subpackage Structs
 */
class SecurePaymentAuthenticationVersionType extends AbstractStructBase
{
    /**
     * The SupportedVersionText
     * Meta information extracted from the WSDL
     * - documentation: Version of 3-D secure being used in this payment transaction. Possible values '3DS2' | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $SupportedVersionText;
    /**
     * The CardEnrollmentVersionText
     * Meta information extracted from the WSDL
     * - documentation: The authentication request for the 3-D Secure transaction. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $CardEnrollmentVersionText;
    /**
     * Constructor method for SecurePaymentAuthenticationVersionType
     * @uses SecurePaymentAuthenticationVersionType::setSupportedVersionText()
     * @uses SecurePaymentAuthenticationVersionType::setCardEnrollmentVersionText()
     * @param string[] $supportedVersionText
     * @param string[] $cardEnrollmentVersionText
     */
    public function __construct(array $supportedVersionText = array(), array $cardEnrollmentVersionText = array())
    {
        $this
            ->setSupportedVersionText($supportedVersionText)
            ->setCardEnrollmentVersionText($cardEnrollmentVersionText);
    }
    /**
     * Get SupportedVersionText value
     * @return string[]
     */
    public function getSupportedVersionText()
    {
        return $this->SupportedVersionText;
    }
    /**
     * This method is responsible for validating the values passed to the setSupportedVersionText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupportedVersionText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupportedVersionTextForArrayConstraintsFromSetSupportedVersionText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $securePaymentAuthenticationVersionTypeSupportedVersionTextItem) {
            // validation for constraint: itemType
            if (!is_string($securePaymentAuthenticationVersionTypeSupportedVersionTextItem)) {
                $invalidValues[] = is_object($securePaymentAuthenticationVersionTypeSupportedVersionTextItem) ? get_class($securePaymentAuthenticationVersionTypeSupportedVersionTextItem) : sprintf('%s(%s)', gettype($securePaymentAuthenticationVersionTypeSupportedVersionTextItem), var_export($securePaymentAuthenticationVersionTypeSupportedVersionTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SupportedVersionText property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SupportedVersionText value
     * @throws \InvalidArgumentException
     * @param string[] $supportedVersionText
     * @return \StructType\SecurePaymentAuthenticationVersionType
     */
    public function setSupportedVersionText(array $supportedVersionText = array())
    {
        // validation for constraint: array
        if ('' !== ($supportedVersionTextArrayErrorMessage = self::validateSupportedVersionTextForArrayConstraintsFromSetSupportedVersionText($supportedVersionText))) {
            throw new \InvalidArgumentException($supportedVersionTextArrayErrorMessage, __LINE__);
        }
        $this->SupportedVersionText = $supportedVersionText;
        return $this;
    }
    /**
     * Add item to SupportedVersionText value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SecurePaymentAuthenticationVersionType
     */
    public function addToSupportedVersionText($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The SupportedVersionText property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SupportedVersionText[] = $item;
        return $this;
    }
    /**
     * Get CardEnrollmentVersionText value
     * @return string[]|null
     */
    public function getCardEnrollmentVersionText()
    {
        return $this->CardEnrollmentVersionText;
    }
    /**
     * This method is responsible for validating the values passed to the setCardEnrollmentVersionText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardEnrollmentVersionText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCardEnrollmentVersionTextForArrayConstraintsFromSetCardEnrollmentVersionText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $securePaymentAuthenticationVersionTypeCardEnrollmentVersionTextItem) {
            // validation for constraint: itemType
            if (!is_string($securePaymentAuthenticationVersionTypeCardEnrollmentVersionTextItem)) {
                $invalidValues[] = is_object($securePaymentAuthenticationVersionTypeCardEnrollmentVersionTextItem) ? get_class($securePaymentAuthenticationVersionTypeCardEnrollmentVersionTextItem) : sprintf('%s(%s)', gettype($securePaymentAuthenticationVersionTypeCardEnrollmentVersionTextItem), var_export($securePaymentAuthenticationVersionTypeCardEnrollmentVersionTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CardEnrollmentVersionText property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CardEnrollmentVersionText value
     * @throws \InvalidArgumentException
     * @param string[] $cardEnrollmentVersionText
     * @return \StructType\SecurePaymentAuthenticationVersionType
     */
    public function setCardEnrollmentVersionText(array $cardEnrollmentVersionText = array())
    {
        // validation for constraint: array
        if ('' !== ($cardEnrollmentVersionTextArrayErrorMessage = self::validateCardEnrollmentVersionTextForArrayConstraintsFromSetCardEnrollmentVersionText($cardEnrollmentVersionText))) {
            throw new \InvalidArgumentException($cardEnrollmentVersionTextArrayErrorMessage, __LINE__);
        }
        $this->CardEnrollmentVersionText = $cardEnrollmentVersionText;
        return $this;
    }
    /**
     * Add item to CardEnrollmentVersionText value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SecurePaymentAuthenticationVersionType
     */
    public function addToCardEnrollmentVersionText($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CardEnrollmentVersionText property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CardEnrollmentVersionText[] = $item;
        return $this;
    }
}
