<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatProfileRefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Temp ABIE to Reference a Seat Profile Reference.
 * @subpackage Structs
 */
class SeatProfileRefType extends AbstractStructBase
{
    /**
     * The SeatProfileRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Seat Profile ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $SeatProfileRefID;
    /**
     * Constructor method for SeatProfileRefType
     * @uses SeatProfileRefType::setSeatProfileRefID()
     * @param string[] $seatProfileRefID
     */
    public function __construct(array $seatProfileRefID = array())
    {
        $this
            ->setSeatProfileRefID($seatProfileRefID);
    }
    /**
     * Get SeatProfileRefID value
     * @return string[]
     */
    public function getSeatProfileRefID()
    {
        return $this->SeatProfileRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatProfileRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatProfileRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatProfileRefIDForArrayConstraintsFromSetSeatProfileRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatProfileRefTypeSeatProfileRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($seatProfileRefTypeSeatProfileRefIDItem)) {
                $invalidValues[] = is_object($seatProfileRefTypeSeatProfileRefIDItem) ? get_class($seatProfileRefTypeSeatProfileRefIDItem) : sprintf('%s(%s)', gettype($seatProfileRefTypeSeatProfileRefIDItem), var_export($seatProfileRefTypeSeatProfileRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatProfileRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatProfileRefID value
     * @throws \InvalidArgumentException
     * @param string[] $seatProfileRefID
     * @return \StructType\SeatProfileRefType
     */
    public function setSeatProfileRefID(array $seatProfileRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($seatProfileRefIDArrayErrorMessage = self::validateSeatProfileRefIDForArrayConstraintsFromSetSeatProfileRefID($seatProfileRefID))) {
            throw new \InvalidArgumentException($seatProfileRefIDArrayErrorMessage, __LINE__);
        }
        $this->SeatProfileRefID = $seatProfileRefID;
        return $this;
    }
    /**
     * Add item to SeatProfileRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SeatProfileRefType
     */
    public function addToSeatProfileRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The SeatProfileRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeatProfileRefID[] = $item;
        return $this;
    }
}
