<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatOnLegType StructType
 * Meta information extracted from the WSDL
 * - documentation: A sitting place for a passenger or crew in a cabin compartment on a Dated Operating Leg. Business Identifier Fields: - [Dated Operating Leg] (all identifier fields) - [Seat] (all identifier fields)
 * @subpackage Structs
 */
class SeatOnLegType extends AbstractStructBase
{
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - documentation: A sitting place for a passenger or crew in a cabin compartment on a transport vehicle.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SeatType
     */
    public $Seat;
    /**
     * The SeatAssignmentAssociations
     * Meta information extracted from the WSDL
     * - documentation: Seat Assignment Associations
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SeatAssignmentAssociationsType
     */
    public $SeatAssignmentAssociations;
    /**
     * The OccupationStatusCode
     * Meta information extracted from the WSDL
     * - documentation: Information related to the availability of a particular Seat on Leg. | Seat status. Examples: SA (Seats are available) WO (Seats waitlist open for segment) WC (Seats waitlist closed for segment) OR (Seats on request only to airline)
     * {codeListAgencyName}PADIS{/codeListAgencyName} {codeListName}Seat occupation{/codeListName} {codeListIdentifier}9865{/codeListIdentifier} | Additional BDT to specify the seat status code.
     * - base: SeatStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OccupationStatusCode;
    /**
     * Constructor method for SeatOnLegType
     * @uses SeatOnLegType::setSeat()
     * @uses SeatOnLegType::setSeatAssignmentAssociations()
     * @uses SeatOnLegType::setOccupationStatusCode()
     * @param \StructType\SeatType $seat
     * @param \StructType\SeatAssignmentAssociationsType $seatAssignmentAssociations
     * @param string $occupationStatusCode
     */
    public function __construct(\StructType\SeatType $seat = null, \StructType\SeatAssignmentAssociationsType $seatAssignmentAssociations = null, $occupationStatusCode = null)
    {
        $this
            ->setSeat($seat)
            ->setSeatAssignmentAssociations($seatAssignmentAssociations)
            ->setOccupationStatusCode($occupationStatusCode);
    }
    /**
     * Get Seat value
     * @return \StructType\SeatType
     */
    public function getSeat()
    {
        return $this->Seat;
    }
    /**
     * Set Seat value
     * @param \StructType\SeatType $seat
     * @return \StructType\SeatOnLegType
     */
    public function setSeat(\StructType\SeatType $seat = null)
    {
        $this->Seat = $seat;
        return $this;
    }
    /**
     * Get SeatAssignmentAssociations value
     * @return \StructType\SeatAssignmentAssociationsType
     */
    public function getSeatAssignmentAssociations()
    {
        return $this->SeatAssignmentAssociations;
    }
    /**
     * Set SeatAssignmentAssociations value
     * @param \StructType\SeatAssignmentAssociationsType $seatAssignmentAssociations
     * @return \StructType\SeatOnLegType
     */
    public function setSeatAssignmentAssociations(\StructType\SeatAssignmentAssociationsType $seatAssignmentAssociations = null)
    {
        $this->SeatAssignmentAssociations = $seatAssignmentAssociations;
        return $this;
    }
    /**
     * Get OccupationStatusCode value
     * @return string|null
     */
    public function getOccupationStatusCode()
    {
        return $this->OccupationStatusCode;
    }
    /**
     * Set OccupationStatusCode value
     * @param string $occupationStatusCode
     * @return \StructType\SeatOnLegType
     */
    public function setOccupationStatusCode($occupationStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($occupationStatusCode) && !is_string($occupationStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($occupationStatusCode, true), gettype($occupationStatusCode)), __LINE__);
        }
        $this->OccupationStatusCode = $occupationStatusCode;
        return $this;
    }
}
