<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatColumnType StructType
 * Meta information extracted from the WSDL
 * - documentation: A sitting place column for a passenger or crew in a cabin compartment on a transport vehicle.
 * @subpackage Structs
 */
class SeatColumnType extends AbstractStructBase
{
    /**
     * The ColumnID
     * Meta information extracted from the WSDL
     * - documentation: Alphabetic character identifying a seat within a row. | Specifies a column (e.g. A, B, C, etc.).
     * - base: xs:token
     * - length: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [A-Z]
     * @var string
     */
    public $ColumnID;
    /**
     * The SeatCharacteristicCode
     * Meta information extracted from the WSDL
     * - documentation: Characteristic of an aircraft seat e.g. A (Aisle seat), E (Exit and emergency exit),..., according to PADIS code list 9825. | Refers to aircraft seat characteristic codes e.g. A (Aisle seat), E (Exit and emergency exit). See PADIS
     * code list 9825. {codeListAgencyName}PADIS{/codeListAgencyName} {codeListName}Seat characteristic,coded{/codeListName} {codeListIdentifier}9825{/codeListIdentifier} | Specifies a Seat Characteristic code.
     * - base: SeatCharacteristicCodeContentType
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SeatCharacteristicCode;
    /**
     * Constructor method for SeatColumnType
     * @uses SeatColumnType::setColumnID()
     * @uses SeatColumnType::setSeatCharacteristicCode()
     * @param string $columnID
     * @param string[] $seatCharacteristicCode
     */
    public function __construct($columnID = null, array $seatCharacteristicCode = array())
    {
        $this
            ->setColumnID($columnID)
            ->setSeatCharacteristicCode($seatCharacteristicCode);
    }
    /**
     * Get ColumnID value
     * @return string
     */
    public function getColumnID()
    {
        return $this->ColumnID;
    }
    /**
     * Set ColumnID value
     * @param string $columnID
     * @return \StructType\SeatColumnType
     */
    public function setColumnID($columnID = null)
    {
        // validation for constraint: string
        if (!is_null($columnID) && !is_string($columnID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($columnID, true), gettype($columnID)), __LINE__);
        }
        // validation for constraint: length(1)
        if (!is_null($columnID) && mb_strlen($columnID) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 1', mb_strlen($columnID)), __LINE__);
        }
        // validation for constraint: pattern([A-Z])
        if (!is_null($columnID) && !preg_match('/[A-Z]/', $columnID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]', var_export($columnID, true)), __LINE__);
        }
        $this->ColumnID = $columnID;
        return $this;
    }
    /**
     * Get SeatCharacteristicCode value
     * @return string[]|null
     */
    public function getSeatCharacteristicCode()
    {
        return $this->SeatCharacteristicCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatCharacteristicCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatCharacteristicCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatCharacteristicCodeForArrayConstraintsFromSetSeatCharacteristicCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatColumnTypeSeatCharacteristicCodeItem) {
            // validation for constraint: itemType
            if (!is_string($seatColumnTypeSeatCharacteristicCodeItem)) {
                $invalidValues[] = is_object($seatColumnTypeSeatCharacteristicCodeItem) ? get_class($seatColumnTypeSeatCharacteristicCodeItem) : sprintf('%s(%s)', gettype($seatColumnTypeSeatCharacteristicCodeItem), var_export($seatColumnTypeSeatCharacteristicCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatCharacteristicCode property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatCharacteristicCode value
     * @throws \InvalidArgumentException
     * @param string[] $seatCharacteristicCode
     * @return \StructType\SeatColumnType
     */
    public function setSeatCharacteristicCode(array $seatCharacteristicCode = array())
    {
        // validation for constraint: array
        if ('' !== ($seatCharacteristicCodeArrayErrorMessage = self::validateSeatCharacteristicCodeForArrayConstraintsFromSetSeatCharacteristicCode($seatCharacteristicCode))) {
            throw new \InvalidArgumentException($seatCharacteristicCodeArrayErrorMessage, __LINE__);
        }
        $this->SeatCharacteristicCode = $seatCharacteristicCode;
        return $this;
    }
    /**
     * Add item to SeatCharacteristicCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SeatColumnType
     */
    public function addToSeatCharacteristicCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The SeatCharacteristicCode property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeatCharacteristicCode[] = $item;
        return $this;
    }
}
