<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatAvailRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request content for Seat Availability Request message
 * @subpackage Structs
 */
class SeatAvailRequestType extends AbstractStructBase
{
    /**
     * The SeatAvailCoreRequest
     * Meta information extracted from the WSDL
     * - documentation: Seat Availability Core Request
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SeatAvailCoreRequestType
     */
    public $SeatAvailCoreRequest;
    /**
     * The ContactInfoList
     * Meta information extracted from the WSDL
     * - documentation: Contact info data list definition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactInfoListType[]
     */
    public $ContactInfoList;
    /**
     * The DatedMarketingSegmentList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated marketing segments used in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DatedMarketingSegmentListType
     */
    public $DatedMarketingSegmentList;
    /**
     * The DatedOperatingLegList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated operating legs used in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DatedOperatingLegListType
     */
    public $DatedOperatingLegList;
    /**
     * The DatedOperatingSegmentList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated operating segments used in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DatedOperatingSegmentListType
     */
    public $DatedOperatingSegmentList;
    /**
     * The DisclosureList
     * Meta information extracted from the WSDL
     * - documentation: Disclosure data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DisclosureListType
     */
    public $DisclosureList;
    /**
     * The FareWaiver
     * Meta information extracted from the WSDL
     * - documentation: Validating carrier-assigned fare rule modification or override information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareWaiverType[]
     */
    public $FareWaiver;
    /**
     * The Metadata
     * Meta information extracted from the WSDL
     * - documentation: Message wide metadata information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MetadataType
     */
    public $Metadata;
    /**
     * The OfferCriteria
     * Meta information extracted from the WSDL
     * - documentation: Further qualifies the flight request by influencing which results are returned in the shopping response, including preferred or required criteria.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OfferCriteriaType
     */
    public $OfferCriteria;
    /**
     * The Pax
     * Meta information extracted from the WSDL
     * - documentation: Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to
     * fulfillment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaxType[]
     */
    public $Pax;
    /**
     * The PaymentFunctions
     * Meta information extracted from the WSDL
     * - documentation: Is the container of all payment relevant functions.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentFunctionsCriteriaType[]
     */
    public $PaymentFunctions;
    /**
     * The Policy
     * Meta information extracted from the WSDL
     * - documentation: Message policy information, including PCI, PII information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PolicyType[]
     */
    public $Policy;
    /**
     * The ResponseParameters
     * Meta information extracted from the WSDL
     * - documentation: A set of Information related to how response results should be returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseParametersRequestType
     */
    public $ResponseParameters;
    /**
     * Constructor method for SeatAvailRequestType
     * @uses SeatAvailRequestType::setSeatAvailCoreRequest()
     * @uses SeatAvailRequestType::setContactInfoList()
     * @uses SeatAvailRequestType::setDatedMarketingSegmentList()
     * @uses SeatAvailRequestType::setDatedOperatingLegList()
     * @uses SeatAvailRequestType::setDatedOperatingSegmentList()
     * @uses SeatAvailRequestType::setDisclosureList()
     * @uses SeatAvailRequestType::setFareWaiver()
     * @uses SeatAvailRequestType::setMetadata()
     * @uses SeatAvailRequestType::setOfferCriteria()
     * @uses SeatAvailRequestType::setPax()
     * @uses SeatAvailRequestType::setPaymentFunctions()
     * @uses SeatAvailRequestType::setPolicy()
     * @uses SeatAvailRequestType::setResponseParameters()
     * @param \StructType\SeatAvailCoreRequestType $seatAvailCoreRequest
     * @param \StructType\ContactInfoListType[] $contactInfoList
     * @param \StructType\DatedMarketingSegmentListType $datedMarketingSegmentList
     * @param \StructType\DatedOperatingLegListType $datedOperatingLegList
     * @param \StructType\DatedOperatingSegmentListType $datedOperatingSegmentList
     * @param \StructType\DisclosureListType $disclosureList
     * @param \StructType\FareWaiverType[] $fareWaiver
     * @param \StructType\MetadataType $metadata
     * @param \StructType\OfferCriteriaType $offerCriteria
     * @param \StructType\PaxType[] $pax
     * @param \StructType\PaymentFunctionsCriteriaType[] $paymentFunctions
     * @param \StructType\PolicyType[] $policy
     * @param \StructType\ResponseParametersRequestType $responseParameters
     */
    public function __construct(\StructType\SeatAvailCoreRequestType $seatAvailCoreRequest = null, array $contactInfoList = array(), \StructType\DatedMarketingSegmentListType $datedMarketingSegmentList = null, \StructType\DatedOperatingLegListType $datedOperatingLegList = null, \StructType\DatedOperatingSegmentListType $datedOperatingSegmentList = null, \StructType\DisclosureListType $disclosureList = null, array $fareWaiver = array(), \StructType\MetadataType $metadata = null, \StructType\OfferCriteriaType $offerCriteria = null, array $pax = array(), array $paymentFunctions = array(), array $policy = array(), \StructType\ResponseParametersRequestType $responseParameters = null)
    {
        $this
            ->setSeatAvailCoreRequest($seatAvailCoreRequest)
            ->setContactInfoList($contactInfoList)
            ->setDatedMarketingSegmentList($datedMarketingSegmentList)
            ->setDatedOperatingLegList($datedOperatingLegList)
            ->setDatedOperatingSegmentList($datedOperatingSegmentList)
            ->setDisclosureList($disclosureList)
            ->setFareWaiver($fareWaiver)
            ->setMetadata($metadata)
            ->setOfferCriteria($offerCriteria)
            ->setPax($pax)
            ->setPaymentFunctions($paymentFunctions)
            ->setPolicy($policy)
            ->setResponseParameters($responseParameters);
    }
    /**
     * Get SeatAvailCoreRequest value
     * @return \StructType\SeatAvailCoreRequestType
     */
    public function getSeatAvailCoreRequest()
    {
        return $this->SeatAvailCoreRequest;
    }
    /**
     * Set SeatAvailCoreRequest value
     * @param \StructType\SeatAvailCoreRequestType $seatAvailCoreRequest
     * @return \StructType\SeatAvailRequestType
     */
    public function setSeatAvailCoreRequest(\StructType\SeatAvailCoreRequestType $seatAvailCoreRequest = null)
    {
        $this->SeatAvailCoreRequest = $seatAvailCoreRequest;
        return $this;
    }
    /**
     * Get ContactInfoList value
     * @return \StructType\ContactInfoListType[]|null
     */
    public function getContactInfoList()
    {
        return $this->ContactInfoList;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInfoList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInfoList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInfoListForArrayConstraintsFromSetContactInfoList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatAvailRequestTypeContactInfoListItem) {
            // validation for constraint: itemType
            if (!$seatAvailRequestTypeContactInfoListItem instanceof \StructType\ContactInfoListType) {
                $invalidValues[] = is_object($seatAvailRequestTypeContactInfoListItem) ? get_class($seatAvailRequestTypeContactInfoListItem) : sprintf('%s(%s)', gettype($seatAvailRequestTypeContactInfoListItem), var_export($seatAvailRequestTypeContactInfoListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInfoList property can only contain items of type \StructType\ContactInfoListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInfoList value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoListType[] $contactInfoList
     * @return \StructType\SeatAvailRequestType
     */
    public function setContactInfoList(array $contactInfoList = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInfoListArrayErrorMessage = self::validateContactInfoListForArrayConstraintsFromSetContactInfoList($contactInfoList))) {
            throw new \InvalidArgumentException($contactInfoListArrayErrorMessage, __LINE__);
        }
        $this->ContactInfoList = $contactInfoList;
        return $this;
    }
    /**
     * Add item to ContactInfoList value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoListType $item
     * @return \StructType\SeatAvailRequestType
     */
    public function addToContactInfoList(\StructType\ContactInfoListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactInfoListType) {
            throw new \InvalidArgumentException(sprintf('The ContactInfoList property can only contain items of type \StructType\ContactInfoListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactInfoList[] = $item;
        return $this;
    }
    /**
     * Get DatedMarketingSegmentList value
     * @return \StructType\DatedMarketingSegmentListType|null
     */
    public function getDatedMarketingSegmentList()
    {
        return $this->DatedMarketingSegmentList;
    }
    /**
     * Set DatedMarketingSegmentList value
     * @param \StructType\DatedMarketingSegmentListType $datedMarketingSegmentList
     * @return \StructType\SeatAvailRequestType
     */
    public function setDatedMarketingSegmentList(\StructType\DatedMarketingSegmentListType $datedMarketingSegmentList = null)
    {
        $this->DatedMarketingSegmentList = $datedMarketingSegmentList;
        return $this;
    }
    /**
     * Get DatedOperatingLegList value
     * @return \StructType\DatedOperatingLegListType|null
     */
    public function getDatedOperatingLegList()
    {
        return $this->DatedOperatingLegList;
    }
    /**
     * Set DatedOperatingLegList value
     * @param \StructType\DatedOperatingLegListType $datedOperatingLegList
     * @return \StructType\SeatAvailRequestType
     */
    public function setDatedOperatingLegList(\StructType\DatedOperatingLegListType $datedOperatingLegList = null)
    {
        $this->DatedOperatingLegList = $datedOperatingLegList;
        return $this;
    }
    /**
     * Get DatedOperatingSegmentList value
     * @return \StructType\DatedOperatingSegmentListType|null
     */
    public function getDatedOperatingSegmentList()
    {
        return $this->DatedOperatingSegmentList;
    }
    /**
     * Set DatedOperatingSegmentList value
     * @param \StructType\DatedOperatingSegmentListType $datedOperatingSegmentList
     * @return \StructType\SeatAvailRequestType
     */
    public function setDatedOperatingSegmentList(\StructType\DatedOperatingSegmentListType $datedOperatingSegmentList = null)
    {
        $this->DatedOperatingSegmentList = $datedOperatingSegmentList;
        return $this;
    }
    /**
     * Get DisclosureList value
     * @return \StructType\DisclosureListType|null
     */
    public function getDisclosureList()
    {
        return $this->DisclosureList;
    }
    /**
     * Set DisclosureList value
     * @param \StructType\DisclosureListType $disclosureList
     * @return \StructType\SeatAvailRequestType
     */
    public function setDisclosureList(\StructType\DisclosureListType $disclosureList = null)
    {
        $this->DisclosureList = $disclosureList;
        return $this;
    }
    /**
     * Get FareWaiver value
     * @return \StructType\FareWaiverType[]|null
     */
    public function getFareWaiver()
    {
        return $this->FareWaiver;
    }
    /**
     * This method is responsible for validating the values passed to the setFareWaiver method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareWaiver method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareWaiverForArrayConstraintsFromSetFareWaiver(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatAvailRequestTypeFareWaiverItem) {
            // validation for constraint: itemType
            if (!$seatAvailRequestTypeFareWaiverItem instanceof \StructType\FareWaiverType) {
                $invalidValues[] = is_object($seatAvailRequestTypeFareWaiverItem) ? get_class($seatAvailRequestTypeFareWaiverItem) : sprintf('%s(%s)', gettype($seatAvailRequestTypeFareWaiverItem), var_export($seatAvailRequestTypeFareWaiverItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareWaiver property can only contain items of type \StructType\FareWaiverType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareWaiver value
     * @throws \InvalidArgumentException
     * @param \StructType\FareWaiverType[] $fareWaiver
     * @return \StructType\SeatAvailRequestType
     */
    public function setFareWaiver(array $fareWaiver = array())
    {
        // validation for constraint: array
        if ('' !== ($fareWaiverArrayErrorMessage = self::validateFareWaiverForArrayConstraintsFromSetFareWaiver($fareWaiver))) {
            throw new \InvalidArgumentException($fareWaiverArrayErrorMessage, __LINE__);
        }
        $this->FareWaiver = $fareWaiver;
        return $this;
    }
    /**
     * Add item to FareWaiver value
     * @throws \InvalidArgumentException
     * @param \StructType\FareWaiverType $item
     * @return \StructType\SeatAvailRequestType
     */
    public function addToFareWaiver(\StructType\FareWaiverType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareWaiverType) {
            throw new \InvalidArgumentException(sprintf('The FareWaiver property can only contain items of type \StructType\FareWaiverType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareWaiver[] = $item;
        return $this;
    }
    /**
     * Get Metadata value
     * @return \StructType\MetadataType|null
     */
    public function getMetadata()
    {
        return $this->Metadata;
    }
    /**
     * Set Metadata value
     * @param \StructType\MetadataType $metadata
     * @return \StructType\SeatAvailRequestType
     */
    public function setMetadata(\StructType\MetadataType $metadata = null)
    {
        $this->Metadata = $metadata;
        return $this;
    }
    /**
     * Get OfferCriteria value
     * @return \StructType\OfferCriteriaType|null
     */
    public function getOfferCriteria()
    {
        return $this->OfferCriteria;
    }
    /**
     * Set OfferCriteria value
     * @param \StructType\OfferCriteriaType $offerCriteria
     * @return \StructType\SeatAvailRequestType
     */
    public function setOfferCriteria(\StructType\OfferCriteriaType $offerCriteria = null)
    {
        $this->OfferCriteria = $offerCriteria;
        return $this;
    }
    /**
     * Get Pax value
     * @return \StructType\PaxType[]|null
     */
    public function getPax()
    {
        return $this->Pax;
    }
    /**
     * This method is responsible for validating the values passed to the setPax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxForArrayConstraintsFromSetPax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatAvailRequestTypePaxItem) {
            // validation for constraint: itemType
            if (!$seatAvailRequestTypePaxItem instanceof \StructType\PaxType) {
                $invalidValues[] = is_object($seatAvailRequestTypePaxItem) ? get_class($seatAvailRequestTypePaxItem) : sprintf('%s(%s)', gettype($seatAvailRequestTypePaxItem), var_export($seatAvailRequestTypePaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Pax property can only contain items of type \StructType\PaxType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Pax value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxType[] $pax
     * @return \StructType\SeatAvailRequestType
     */
    public function setPax(array $pax = array())
    {
        // validation for constraint: array
        if ('' !== ($paxArrayErrorMessage = self::validatePaxForArrayConstraintsFromSetPax($pax))) {
            throw new \InvalidArgumentException($paxArrayErrorMessage, __LINE__);
        }
        $this->Pax = $pax;
        return $this;
    }
    /**
     * Add item to Pax value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxType $item
     * @return \StructType\SeatAvailRequestType
     */
    public function addToPax(\StructType\PaxType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaxType) {
            throw new \InvalidArgumentException(sprintf('The Pax property can only contain items of type \StructType\PaxType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Pax[] = $item;
        return $this;
    }
    /**
     * Get PaymentFunctions value
     * @return \StructType\PaymentFunctionsCriteriaType[]|null
     */
    public function getPaymentFunctions()
    {
        return $this->PaymentFunctions;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFunctions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFunctions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatAvailRequestTypePaymentFunctionsItem) {
            // validation for constraint: itemType
            if (!$seatAvailRequestTypePaymentFunctionsItem instanceof \StructType\PaymentFunctionsCriteriaType) {
                $invalidValues[] = is_object($seatAvailRequestTypePaymentFunctionsItem) ? get_class($seatAvailRequestTypePaymentFunctionsItem) : sprintf('%s(%s)', gettype($seatAvailRequestTypePaymentFunctionsItem), var_export($seatAvailRequestTypePaymentFunctionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentFunctionsCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFunctionsCriteriaType[] $paymentFunctions
     * @return \StructType\SeatAvailRequestType
     */
    public function setPaymentFunctions(array $paymentFunctions = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFunctionsArrayErrorMessage = self::validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions($paymentFunctions))) {
            throw new \InvalidArgumentException($paymentFunctionsArrayErrorMessage, __LINE__);
        }
        $this->PaymentFunctions = $paymentFunctions;
        return $this;
    }
    /**
     * Add item to PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFunctionsCriteriaType $item
     * @return \StructType\SeatAvailRequestType
     */
    public function addToPaymentFunctions(\StructType\PaymentFunctionsCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentFunctionsCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentFunctionsCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentFunctions[] = $item;
        return $this;
    }
    /**
     * Get Policy value
     * @return \StructType\PolicyType[]|null
     */
    public function getPolicy()
    {
        return $this->Policy;
    }
    /**
     * This method is responsible for validating the values passed to the setPolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePolicyForArrayConstraintsFromSetPolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatAvailRequestTypePolicyItem) {
            // validation for constraint: itemType
            if (!$seatAvailRequestTypePolicyItem instanceof \StructType\PolicyType) {
                $invalidValues[] = is_object($seatAvailRequestTypePolicyItem) ? get_class($seatAvailRequestTypePolicyItem) : sprintf('%s(%s)', gettype($seatAvailRequestTypePolicyItem), var_export($seatAvailRequestTypePolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Policy property can only contain items of type \StructType\PolicyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Policy value
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyType[] $policy
     * @return \StructType\SeatAvailRequestType
     */
    public function setPolicy(array $policy = array())
    {
        // validation for constraint: array
        if ('' !== ($policyArrayErrorMessage = self::validatePolicyForArrayConstraintsFromSetPolicy($policy))) {
            throw new \InvalidArgumentException($policyArrayErrorMessage, __LINE__);
        }
        $this->Policy = $policy;
        return $this;
    }
    /**
     * Add item to Policy value
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyType $item
     * @return \StructType\SeatAvailRequestType
     */
    public function addToPolicy(\StructType\PolicyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PolicyType) {
            throw new \InvalidArgumentException(sprintf('The Policy property can only contain items of type \StructType\PolicyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Policy[] = $item;
        return $this;
    }
    /**
     * Get ResponseParameters value
     * @return \StructType\ResponseParametersRequestType|null
     */
    public function getResponseParameters()
    {
        return $this->ResponseParameters;
    }
    /**
     * Set ResponseParameters value
     * @param \StructType\ResponseParametersRequestType $responseParameters
     * @return \StructType\SeatAvailRequestType
     */
    public function setResponseParameters(\StructType\ResponseParametersRequestType $responseParameters = null)
    {
        $this->ResponseParameters = $responseParameters;
        return $this;
    }
}
