<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatAssignmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Seat Location selected by the Passenger (via SeatAvailability) or assigned tot he Passenger by the Airline for a given segment. When used, only a single Passenger must be referenced within the Service.
 * @subpackage Structs
 */
class SeatAssignmentType extends AbstractStructBase
{
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - documentation: A sitting place for a passenger or crew in a cabin compartment on a transport vehicle.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SeatType
     */
    public $Seat;
    /**
     * The SeatAssignmentAssociations
     * Meta information extracted from the WSDL
     * - documentation: Seat Assignment Associations
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SeatAssignmentAssociationsType
     */
    public $SeatAssignmentAssociations;
    /**
     * The ServiceDefinitionRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Service Definition ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceDefinitionRefID;
    /**
     * Constructor method for SeatAssignmentType
     * @uses SeatAssignmentType::setSeat()
     * @uses SeatAssignmentType::setSeatAssignmentAssociations()
     * @uses SeatAssignmentType::setServiceDefinitionRefID()
     * @param \StructType\SeatType $seat
     * @param \StructType\SeatAssignmentAssociationsType $seatAssignmentAssociations
     * @param string $serviceDefinitionRefID
     */
    public function __construct(\StructType\SeatType $seat = null, \StructType\SeatAssignmentAssociationsType $seatAssignmentAssociations = null, $serviceDefinitionRefID = null)
    {
        $this
            ->setSeat($seat)
            ->setSeatAssignmentAssociations($seatAssignmentAssociations)
            ->setServiceDefinitionRefID($serviceDefinitionRefID);
    }
    /**
     * Get Seat value
     * @return \StructType\SeatType
     */
    public function getSeat()
    {
        return $this->Seat;
    }
    /**
     * Set Seat value
     * @param \StructType\SeatType $seat
     * @return \StructType\SeatAssignmentType
     */
    public function setSeat(\StructType\SeatType $seat = null)
    {
        $this->Seat = $seat;
        return $this;
    }
    /**
     * Get SeatAssignmentAssociations value
     * @return \StructType\SeatAssignmentAssociationsType
     */
    public function getSeatAssignmentAssociations()
    {
        return $this->SeatAssignmentAssociations;
    }
    /**
     * Set SeatAssignmentAssociations value
     * @param \StructType\SeatAssignmentAssociationsType $seatAssignmentAssociations
     * @return \StructType\SeatAssignmentType
     */
    public function setSeatAssignmentAssociations(\StructType\SeatAssignmentAssociationsType $seatAssignmentAssociations = null)
    {
        $this->SeatAssignmentAssociations = $seatAssignmentAssociations;
        return $this;
    }
    /**
     * Get ServiceDefinitionRefID value
     * @return string|null
     */
    public function getServiceDefinitionRefID()
    {
        return $this->ServiceDefinitionRefID;
    }
    /**
     * Set ServiceDefinitionRefID value
     * @param string $serviceDefinitionRefID
     * @return \StructType\SeatAssignmentType
     */
    public function setServiceDefinitionRefID($serviceDefinitionRefID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDefinitionRefID) && !is_string($serviceDefinitionRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDefinitionRefID, true), gettype($serviceDefinitionRefID)), __LINE__);
        }
        $this->ServiceDefinitionRefID = $serviceDefinitionRefID;
        return $this;
    }
}
